/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Release;
import com.jcabi.github.ReleaseAsset;
import com.jcabi.github.RtJson;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import jakarta.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtReleaseAsset
implements ReleaseAsset {
    private final transient Request request;
    private final transient Release owner;
    private final transient int num;

    RtReleaseAsset(Request req, Release release, int number) {
        Coordinates coords = release.repo().coordinates();
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/releases").path("/assets").path(Integer.toString(number)).back();
        this.owner = release;
        this.num = number;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Release release() {
        return this.owner;
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public void remove() throws IOException {
        ((RestResponse)this.request.method("DELETE").fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public InputStream raw() throws IOException {
        return new ByteArrayInputStream(((RestResponse)this.request.method("GET").reset("Accept").header("Accept", (Object)"application/vnd.github.v3.raw").fetch().as(RestResponse.class)).assertStatus(200).binary());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtReleaseAsset)) {
            return false;
        }
        RtReleaseAsset other = (RtReleaseAsset)o;
        if (this.num != other.num) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Release this$owner = this.owner;
        Release other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.num;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Release $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

