/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.Organization;
import com.jcabi.github.Organizations;
import com.jcabi.github.RtOrganization;
import com.jcabi.github.RtPagination;
import com.jcabi.http.Request;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtOrganizations
implements Organizations {
    private final transient Request entry;
    private final transient Request request;
    private final transient GitHub ghub;

    RtOrganizations(GitHub github, Request req) {
        this.entry = req;
        this.request = this.entry.uri().path("/user").path("/orgs").back();
        this.ghub = github;
    }

    @Override
    public Organization get(String login) {
        return new RtOrganization(this.ghub, this.entry, login);
    }

    @Override
    public Iterable<Organization> iterate() {
        return new RtPagination<Organization>(this.request, object -> this.get(object.getString("login")));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtOrganizations)) {
            return false;
        }
        RtOrganizations other = (RtOrganizations)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        GitHub this$ghub = this.ghub;
        GitHub other$ghub = other.ghub;
        return !(this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        GitHub $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        return result;
    }
}

