/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Blob;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.RtJson;
import com.jcabi.http.Request;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtBlob
implements Blob {
    private final transient Request request;
    private final transient String hash;

    RtBlob(Request req, Repo repo, String sha) {
        Coordinates coords = repo.coordinates();
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/git").path("/blobs").path(sha).back();
        this.hash = sha;
    }

    @Override
    public String sha() {
        return this.hash;
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtBlob)) {
            return false;
        }
        RtBlob other = (RtBlob)o;
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        String this$hash = this.hash;
        String other$hash = other.hash;
        return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        String $hash = this.hash;
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        return result;
    }
}

