/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Commit;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Repo;
import com.jcabi.github.SmartJson;
import com.jcabi.github.User;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;

@Immutable
public interface PullRef
extends JsonReadable {
    public Repo repo();

    public String ref() throws IOException;

    public String sha() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements PullRef {
        private final transient PullRef pullref;
        private final transient SmartJson jsn;

        public Smart(PullRef pref) {
            this.pullref = pref;
            this.jsn = new SmartJson(pref);
        }

        @Override
        public Repo repo() {
            return this.pullref.repo();
        }

        @Override
        public String ref() throws IOException {
            return this.pullref.ref();
        }

        @Override
        public String sha() throws IOException {
            return this.pullref.sha();
        }

        public User user() throws IOException {
            return this.pullref.repo().github().users().get(this.jsn.value("user", JsonObject.class).getString("login"));
        }

        public String label() throws IOException {
            return this.jsn.text("label");
        }

        public Commit commit() throws IOException {
            return this.repo().git().commits().get(this.sha());
        }

        @Override
        public JsonObject json() throws IOException {
            return this.pullref.json();
        }

        @Generated
        public String toString() {
            return "PullRef.Smart(pullref=" + this.pullref + ", jsn=" + this.jsn + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            PullRef this$pullref = this.pullref;
            PullRef other$pullref = other.pullref;
            if (this$pullref == null ? other$pullref != null : !this$pullref.equals(other$pullref)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PullRef $pullref = this.pullref;
            result = result * 59 + ($pullref == null ? 43 : $pullref.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

