/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.SmartJson;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

@Immutable
public interface Limit
extends JsonReadable {
    public GitHub github();

    @Immutable
    @Loggable(value=1)
    public static final class Throttled
    implements Limit {
        private final transient Limit origin;
        private final transient SmartJson jsn;
        private final transient int max;

        public Throttled(Limit limit, int allowed) {
            this.origin = limit;
            this.max = allowed;
            this.jsn = new SmartJson(limit);
        }

        @Override
        public JsonObject json() throws IOException {
            int limit = new SmartJson(this.origin).number("limit");
            int remaining = this.max - (limit - new SmartJson(this.origin).number("remaining"));
            return Json.createObjectBuilder().add("limit", limit).add("remaining", remaining).add("reset", new SmartJson(this.origin).number("reset")).build();
        }

        @Override
        public GitHub github() {
            return this.origin.github();
        }

        @Generated
        public String toString() {
            return "Limit.Throttled(origin=" + this.origin + ", jsn=" + this.jsn + ", max=" + this.max + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Throttled)) {
                return false;
            }
            Throttled other = (Throttled)o;
            Limit this$origin = this.origin;
            Limit other$origin = other.origin;
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Limit $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Limit {
        private final transient Limit origin;

        public Smart(Limit limit) {
            this.origin = limit;
        }

        public int limit() throws IOException {
            return new SmartJson(this.origin).number("limit");
        }

        public int remaining() throws IOException {
            return new SmartJson(this.origin).number("remaining");
        }

        public Date reset() throws IOException {
            return new Date(TimeUnit.MILLISECONDS.convert(new SmartJson(this.origin).number("reset"), TimeUnit.SECONDS));
        }

        @Override
        public JsonObject json() throws IOException {
            return this.origin.json();
        }

        @Override
        public GitHub github() {
            return this.origin.github();
        }

        @Generated
        public String toString() {
            return "Limit.Smart(origin=" + this.origin + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Limit this$origin = this.origin;
            Limit other$origin = other.origin;
            return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Limit $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            return result;
        }
    }
}

