/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.SmartJson;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import lombok.Generated;

@Immutable
public interface DeployKey
extends JsonReadable,
JsonPatchable {
    public int number();

    public void remove() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements DeployKey {
        private final transient DeployKey key;
        private final transient SmartJson jsn;

        public Smart(DeployKey dkey) {
            this.key = dkey;
            this.jsn = new SmartJson(dkey);
        }

        public String key() throws IOException {
            return this.jsn.text("key");
        }

        public void key(String value) throws IOException {
            this.key.patch(Json.createObjectBuilder().add("key", value).build());
        }

        public URL url() throws IOException {
            try {
                return new URI(this.jsn.text("url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public String title() throws IOException {
            return this.jsn.text("title");
        }

        public void title(String text) throws IOException {
            this.key.patch(Json.createObjectBuilder().add("title", text).build());
        }

        @Override
        public JsonObject json() throws IOException {
            return this.key.json();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.key.patch(json);
        }

        @Override
        public int number() {
            return this.key.number();
        }

        @Override
        public void remove() throws IOException {
            this.key.remove();
        }

        @Generated
        public String toString() {
            return "DeployKey.Smart(key=" + this.key + ", jsn=" + this.jsn + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            DeployKey this$key = this.key;
            DeployKey other$key = other.key;
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DeployKey $key = this.key;
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

