/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Parallel;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.log.VerboseThreads;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.reflect.Factory;

@Aspect
@Immutable
public final class Parallelizer {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ Parallelizer ajc$perSingletonInstance;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public Parallelizer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    @Around(value="execution(@com.jcabi.aspects.Parallel * * (..))")
    public Object wrap(ProceedingJoinPoint point) throws ParallelException {
        int total = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(Parallel.class).threads();
        ArrayList<Callable> callables = new ArrayList<Callable>(total);
        CountDownLatch start = new CountDownLatch(1);
        int thread = 0;
        while (thread < total) {
            callables.add(Parallelizer.callable(point, start));
            ++thread;
        }
        ExecutorService executor = Executors.newFixedThreadPool(total, (ThreadFactory)new VerboseThreads());
        ArrayList futures = new ArrayList(total);
        for (Callable callable : callables) {
            futures.add(executor.submit(callable));
        }
        start.countDown();
        LinkedList failures = new LinkedList();
        for (Future future : futures) {
            Parallelizer.process(failures, future);
        }
        executor.shutdown();
        if (!failures.isEmpty()) {
            throw Parallelizer.exceptions(failures);
        }
        return null;
    }

    private static void process(Collection<Throwable> failures, Future<Throwable> future) {
        try {
            Throwable exception = future.get();
            if (exception != null) {
                failures.add(exception);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            failures.add(ex);
        }
        catch (ExecutionException ex) {
            failures.add(ex);
        }
    }

    private static ParallelException exceptions(Iterable<Throwable> failures) {
        ParallelException current = null;
        for (Throwable failure : failures) {
            current = new ParallelException(failure, current);
        }
        return current;
    }

    private static Callable<Throwable> callable(ProceedingJoinPoint point, CountDownLatch start) {
        return () -> {
            Throwable result = null;
            try {
                start.await();
                point.proceed();
            }
            catch (Throwable ex) {
                result = ex;
            }
            return result;
        };
    }

    public static Parallelizer aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.Parallelizer", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        Parallelizer.ajc$preClinit();
        try {
            Parallelizer.ajc$perSingletonInstance = new Parallelizer();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Parallelizer.java", Parallelizer.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.aspects.aj.Parallelizer", "", "", ""), 58);
    }

    private static final class ParallelException
    extends Exception {
        private static final long serialVersionUID = -8699847038869978078L;
        private final transient ParallelException next;

        protected ParallelException(Throwable cause, ParallelException nxt) {
            super(cause);
            this.next = nxt;
        }

        public ParallelException getNext() {
            return this.next;
        }
    }
}

