/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import lombok.Generated;
import org.w3c.dom.Node;
import org.xembly.Directive;
import org.xembly.ImpossibleModificationException;

final class StrictDirective
implements Directive {
    private final int number;

    StrictDirective(int nodes) {
        this.number = nodes;
    }

    public String toString() {
        return String.format("STRICT \"%d\"", this.number);
    }

    @Override
    public Directive.Cursor exec(Node dom, Directive.Cursor cursor, Directive.Stack stack) throws ImpossibleModificationException {
        if (cursor.size() != this.number) {
            if (cursor.isEmpty()) {
                throw new ImpossibleModificationException(String.format("No current nodes while %d expected", this.number));
            }
            if (cursor.size() == 1) {
                throw new ImpossibleModificationException(String.format("One current node '%s' while strictly %d expected", ((Node)cursor.iterator().next()).getNodeName(), this.number));
            }
            throw new ImpossibleModificationException(String.format("%d current nodes [%s] while strictly %d expected", cursor.size(), StrictDirective.names(cursor), this.number));
        }
        return cursor;
    }

    private static String names(Iterable<Node> nodes) {
        StringBuilder text = new StringBuilder(0);
        for (Node node : nodes) {
            Node parent;
            if (text.length() > 0) {
                text.append(", ");
            }
            if ((parent = node.getParentNode()) != null) {
                text.append(parent.getNodeName());
            }
            text.append('/').append(node.getNodeName());
        }
        return text.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrictDirective)) {
            return false;
        }
        StrictDirective other = (StrictDirective)o;
        return this.number == other.number;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.number;
        return result;
    }
}

