/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import lombok.Generated;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xembly.Arg;
import org.xembly.Directive;
import org.xembly.XmlContentException;

final class AttrDirective
implements Directive {
    private final Arg name;
    private final Arg value;

    AttrDirective(String attr, String val) throws XmlContentException {
        this.name = new Arg(attr);
        this.value = new Arg(val);
    }

    public String toString() {
        return String.format("ATTR %s, %s", this.name, this.value);
    }

    @Override
    public Directive.Cursor exec(Node dom, Directive.Cursor cursor, Directive.Stack stack) {
        String key = this.name.raw();
        String val = this.value.raw();
        String[] parts = key.split(" ");
        for (Node node : cursor) {
            if (parts.length == 3) {
                ((Element)Element.class.cast(node)).setAttributeNS(parts[2], String.format("%s:%s", parts[1], parts[0]), val);
                continue;
            }
            ((Element)Element.class.cast(node)).setAttribute(key, val);
        }
        return cursor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttrDirective)) {
            return false;
        }
        AttrDirective other = (AttrDirective)o;
        Arg this$name = this.name;
        Arg other$name = other.name;
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Arg this$value = this.value;
        Arg other$value = other.value;
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Arg $name = this.name;
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Arg $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

