/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import java.io.StringWriter;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xembly.Directive;
import org.xembly.DomCursor;
import org.xembly.DomStack;
import org.xembly.ImpossibleModificationException;

public final class Xembler {
    private static final DocumentBuilderFactory BFACTORY = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory TFACTORY = TransformerFactory.newInstance();
    private final transient Iterable<Directive> directives;

    public Xembler(Iterable<Directive> dirs) {
        this.directives = dirs;
    }

    public Node applyQuietly(Node dom) {
        try {
            return this.apply(dom);
        }
        catch (ImpossibleModificationException ex) {
            throw new IllegalArgumentException(String.format("failed to apply to DOM quietly: %s", this.directives), ex);
        }
    }

    public Node apply(Node dom) throws ImpossibleModificationException {
        Directive.Cursor cursor = new DomCursor(Collections.singletonList(dom));
        int pos = 1;
        DomStack stack = new DomStack();
        for (Directive dir : this.directives) {
            try {
                cursor = dir.exec(dom, cursor, stack);
            }
            catch (ImpossibleModificationException ex) {
                throw new ImpossibleModificationException(String.format("directive #%d: %s", pos, dir), ex);
            }
            catch (DOMException ex) {
                throw new ImpossibleModificationException(String.format("DOM exception at dir #%d: %s", pos, dir), ex);
            }
            ++pos;
        }
        return dom;
    }

    public Document domQuietly() {
        try {
            return this.dom();
        }
        catch (ImpossibleModificationException ex) {
            throw new IllegalStateException(String.format("failed to create DOM quietly: %s", this.directives), ex);
        }
    }

    public Document dom() throws ImpossibleModificationException {
        Document dom;
        try {
            dom = BFACTORY.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(String.format("failed to obtain a new DOM document from %s", BFACTORY.getClass().getCanonicalName()), ex);
        }
        this.apply(dom);
        return dom;
    }

    public String xmlQuietly() {
        try {
            return this.xml();
        }
        catch (ImpossibleModificationException ex) {
            throw new IllegalStateException(String.format("failed to build XML quietly: %s", this.directives), ex);
        }
    }

    public String xml() throws ImpossibleModificationException {
        Transformer transformer;
        try {
            transformer = TFACTORY.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new IllegalStateException(String.format("failed to create new Transformer at %s", TFACTORY.getClass().getCanonicalName()), ex);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        StringWriter writer = new StringWriter();
        try {
            transformer.transform(new DOMSource(this.dom()), new StreamResult(writer));
        }
        catch (TransformerException ex) {
            throw new IllegalArgumentException(String.format("failed to transform DOM to text by %s", transformer.getClass().getCanonicalName()), ex);
        }
        return writer.toString();
    }

    public static String escape(String text) {
        char[] chars;
        StringBuilder output = new StringBuilder(text.length());
        for (char chr : chars = text.toCharArray()) {
            boolean illegal;
            boolean bl = illegal = chr >= '\u0000' && chr <= '\b' || chr >= '\u000b' && chr <= '\f' || chr >= '\u000e' && chr <= '\u001f' || chr >= '\u007f' && chr <= '\u0084' || chr >= '\u0086' && chr <= '\u009f';
            if (illegal) {
                output.append(String.format("\\u%04x", chr));
                continue;
            }
            output.append(chr);
        }
        return output.toString();
    }

    public String toString() {
        return "Xembler(directives=" + this.directives + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Xembler)) {
            return false;
        }
        Xembler other = (Xembler)o;
        Iterable<Directive> this$directives = this.directives;
        Iterable<Directive> other$directives = other.directives;
        return !(this$directives == null ? other$directives != null : !this$directives.equals(other$directives));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Iterable<Directive> $directives = this.directives;
        result = result * 59 + ($directives == null ? 43 : $directives.hashCode());
        return result;
    }

    static {
        BFACTORY.setNamespaceAware(true);
        BFACTORY.setValidating(false);
        BFACTORY.setCoalescing(false);
    }
}

