/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.jmx;

import com.jamonapi.MonKeyImp;
import com.jamonapi.MonitorFactory;
import com.jamonapi.jmx.GcMXBean;
import com.jamonapi.jmx.JmxUtils;
import com.jamonapi.jmx.MonitorMXBean;
import com.jamonapi.jmx.MonitorMXBeanFactory;
import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class GcMXBeanImp
implements GcMXBean,
NotificationListener {
    private String gcInfoString = "";
    private long duration;
    private Date when;
    private static final String PREFIX = GcMXBeanImp.class.getPackage().getName();
    private Set<String> gcNames = new HashSet<String>();

    public static ObjectName getObjectName() {
        return JmxUtils.getObjectName(PREFIX + ":type=current,name=Jamon.Gc.MostRecent");
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String notifyType = notification.getType();
        if (notifyType.equals("com.sun.management.gc.notification")) {
            CompositeData cd = (CompositeData)notification.getUserData();
            GarbageCollectionNotificationInfo gcNotifyInfo = GarbageCollectionNotificationInfo.from(cd);
            this.monitor(gcNotifyInfo);
            if (!this.gcNames.contains(gcNotifyInfo.getGcName())) {
                this.registerDependentGcMbeans(gcNotifyInfo.getGcName());
            }
        }
    }

    void monitor(GarbageCollectionNotificationInfo gcNotifyInfo) {
        GcInfo gcInfo = gcNotifyInfo.getGcInfo();
        this.duration = gcInfo.getDuration();
        this.when = new Date();
        String details = this.toString(gcNotifyInfo);
        String labelPrefix = this.getGcPrefix(gcNotifyInfo.getGcName());
        this.monitorDuration(labelPrefix, details);
        this.monitorUsedMemory(labelPrefix, gcInfo, details);
    }

    private String getGcPrefix(String gcName) {
        return PREFIX + ".gc." + gcName;
    }

    private void monitorDuration(String labelPrefix, String details) {
        MonKeyImp key = new MonKeyImp(labelPrefix + ".time", details, "ms.");
        MonitorFactory.add(key, this.duration);
    }

    private void monitorUsedMemory(String labelPrefix, GcInfo gcInfo, String details) {
        for (Map.Entry<String, MemoryUsage> entry : gcInfo.getMemoryUsageAfterGc().entrySet()) {
            MonKeyImp key = new MonKeyImp(labelPrefix + ".usedMemory." + entry.getKey(), details, "bytes");
            MonitorFactory.add(key, entry.getValue().getUsed());
        }
    }

    private String toString(GarbageCollectionNotificationInfo gcNotifyInfo) {
        GcInfo gcInfo = gcNotifyInfo.getGcInfo();
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(gcNotifyInfo.getGcName()).append("\n");
        sb.append("Cause: ").append(gcNotifyInfo.getGcCause()).append("\n");
        sb.append("Action: ").append(gcNotifyInfo.getGcAction()).append("\n");
        sb.append("Duration: ").append(gcInfo.getDuration()).append("\n");
        sb.append("Sequence: ").append(gcInfo.getId()).append("\n");
        sb.append("When: ").append(this.when).append("\n\n");
        sb.append("BeforeGc: ").append(this.formatGcData(gcInfo.getMemoryUsageBeforeGc())).append("\n\n");
        sb.append("AfterGc: ").append(this.formatGcData(gcInfo.getMemoryUsageAfterGc())).append("\n");
        this.gcInfoString = sb.toString();
        return this.gcInfoString;
    }

    private void registerDependentGcMbeans(String gcName) {
        String label = this.getGcPrefix(gcName) + ".time";
        String jmxName = "Jamon.Gc." + gcName;
        try {
            MonitorMXBean mXbean = MonitorMXBeanFactory.create(label, "ms.", jmxName);
            ObjectName current = MonitorMXBeanFactory.getObjectName(mXbean);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mXbean, current);
            MonitorMXBean mXbeanDelta = MonitorMXBeanFactory.createDelta(label, "ms.", jmxName);
            ObjectName delta = MonitorMXBeanFactory.getDeltaObjectName(mXbeanDelta);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mXbeanDelta, delta);
            this.gcNames.add(gcName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String formatGcData(Map map) {
        String str = map.toString();
        return str.replace(",", ",\n").replace("{", "{\n");
    }

    @Override
    public String getGcInfo() {
        return this.gcInfoString;
    }

    @Override
    public Date getWhen() {
        return this.when;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }
}

