/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.utils.Misc;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JamonPropertiesLoader {
    public static final Properties PROPS = new JamonPropertiesLoader().getJamonProperties();
    private String fileName;
    private Properties jamonProps;
    private List<JamonListenerProperty> listenerList;
    private List<String> jamonMxBeanList;

    public JamonPropertiesLoader() {
        this("jamonapi.properties");
    }

    JamonPropertiesLoader(String fileName) {
        this.fileName = fileName;
    }

    public Properties getJamonProperties() {
        if (this.jamonProps == null) {
            this.initialize();
        }
        return this.jamonProps;
    }

    void initialize() {
        Properties defaults = this.getDefaults();
        Properties userProvided = this.propertyLoader(this.fileName);
        this.replaceWithCommandLineProps(userProvided, defaults);
        this.jamonProps = new Properties(defaults);
        this.jamonProps.putAll((Map<?, ?>)userProvided);
    }

    public URL getPropertiesDirectory() {
        return this.getClass().getClassLoader().getResource(".");
    }

    public List<JamonListenerProperty> getListeners() {
        if (this.jamonProps == null) {
            this.initialize();
        }
        if (this.listenerList == null) {
            this.addListeners();
        }
        return this.listenerList;
    }

    public List<String> getMxBeans() {
        if (this.jamonProps == null) {
            this.initialize();
        }
        if (this.jamonMxBeanList == null) {
            this.addJamonMxBeans();
        }
        if (this.jamonMxBeanList.isEmpty()) {
            this.loadDefaultJamonMxBeans();
        }
        return this.jamonMxBeanList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Properties propertyLoader(String fileName) {
        Properties properties = new Properties();
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (input != null) {
                properties.load(input);
            }
            this.close(input);
        }
        catch (Throwable throwable) {
            this.close(input);
            catch (Throwable throwable2) {
                this.close(input);
                throw throwable2;
            }
        }
        return properties;
    }

    void close(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void replaceWithCommandLineProps(Properties properties, Properties defaults) {
        for (Object key : defaults.keySet()) {
            String value = System.getProperty(key.toString());
            if (value == null) continue;
            properties.put(key, value);
        }
    }

    Properties getDefaults() {
        Properties defaults = new Properties();
        defaults.put("distributedDataRefreshRateInMinutes", "5");
        defaults.put("jamonDataPersister", "com.jamonapi.distributed.HazelcastFilePersister");
        defaults.put("jamonDataPersister.label", "");
        defaults.put("jamonDataPersister.label.prefix", "");
        defaults.put("jamonDataPersister.directory", "jamondata");
        defaults.put("jamonListener.type", "value");
        defaults.put("jamonListener.name", "FIFOBuffer");
        defaults.put("jamonListener.size", "50");
        defaults.put("jamonJmxBean.size", "50");
        defaults.put("monitorCompositeCombiner.summaryFifoBufferSize", "100");
        defaults.put("monitorCompositeCombiner.combinedFifoBufferSize", "300");
        return defaults;
    }

    private void loadDefaultJamonMxBeans() {
        this.jamonMxBeanList.add("com.jamonapi.http.JAMonJettyHandlerNew.request.allPages, ms., com.jamonapi.http.JAMonTomcatValve.request.allPages, ms., Jamon.HttpPageRequests");
        this.jamonMxBeanList.add("MonProxy-SQL-Type: All, ms., Jamon.Sql.All");
        this.jamonMxBeanList.add("MonProxy-SQL-Type: select, ms., Jamon.Sql.Select");
        this.jamonMxBeanList.add("MonProxy-SQL-Type: update, ms., Jamon.Sql.Update");
        this.jamonMxBeanList.add("MonProxy-SQL-Type: delete, ms., Jamon.Sql.Delete");
        this.jamonMxBeanList.add("MonProxy-SQL-Type: insert, ms., Jamon.Sql.Insert");
    }

    private void addListeners() {
        this.listenerList = new ArrayList<JamonListenerProperty>();
        int size = Integer.valueOf(this.jamonProps.getProperty("jamonListener.size"));
        for (int i = 0; i <= size; ++i) {
            String keyPrefix = this.getKeyPrefix("jamonListener", i);
            String listener = this.jamonProps.getProperty(keyPrefix + "key");
            if (listener == null) continue;
            this.listenerList.add(new JamonListenerProperty(keyPrefix));
        }
    }

    private void addJamonMxBeans() {
        this.jamonMxBeanList = new ArrayList<String>();
        int size = Integer.valueOf(this.jamonProps.getProperty("jamonJmxBean.size"));
        for (int i = 0; i <= size; ++i) {
            String keyPrefix = this.getKeyPrefix("jamonJmxBean", i);
            String propertyValue = this.jamonProps.getProperty(keyPrefix + "key");
            if (propertyValue == null) continue;
            this.jamonMxBeanList.add(propertyValue);
        }
    }

    private String getKeyPrefix(String key, int i) {
        return key + "[" + i + "].";
    }

    public class JamonListenerProperty {
        protected String keyPrefix;

        protected JamonListenerProperty(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        protected String[] split(String listenerPropertyValue) {
            return Misc.trim(listenerPropertyValue.split(","));
        }

        public String getLabel() {
            return this.split(JamonPropertiesLoader.this.jamonProps.getProperty(this.keyPrefix + "key"))[0];
        }

        public String getUnits() {
            return this.split(JamonPropertiesLoader.this.jamonProps.getProperty(this.keyPrefix + "key"))[1];
        }

        public String getListenerType() {
            String defaultProp = JamonPropertiesLoader.this.jamonProps.getProperty("jamonListener.type");
            return JamonPropertiesLoader.this.jamonProps.getProperty(this.keyPrefix + "type", defaultProp).trim();
        }

        public String getListenerName() {
            String defaultProp = JamonPropertiesLoader.this.jamonProps.getProperty("jamonListener.name");
            return JamonPropertiesLoader.this.jamonProps.getProperty(this.keyPrefix + "name", defaultProp).trim();
        }
    }
}

