/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDeveloperExtension;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNameTree;
import com.itextpdf.kernel.pdf.PdfNumTree;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfOutline;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfPagesTree;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfViewerPreferences;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.collection.PdfCollection;
import com.itextpdf.kernel.pdf.layer.PdfOCProperties;
import com.itextpdf.kernel.pdf.navigation.PdfDestination;
import com.itextpdf.kernel.pdf.navigation.PdfExplicitDestination;
import com.itextpdf.kernel.pdf.navigation.PdfStringDestination;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfCatalog
extends PdfObjectWrapper<PdfDictionary> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfCatalog.class);
    private final PdfPagesTree pageTree;
    protected Map<PdfName, PdfNameTree> nameTrees = new LinkedHashMap<PdfName, PdfNameTree>();
    protected PdfNumTree pageLabels;
    protected PdfOCProperties ocProperties;
    private static final String OutlineRoot = "Outlines";
    private PdfOutline outlines;
    private Map<PdfObject, List<PdfOutline>> pagesWithOutlines = new HashMap<PdfObject, List<PdfOutline>>();
    private boolean outlineMode;
    private static final Set<PdfName> PAGE_MODES = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.UseNone, PdfName.UseOutlines, PdfName.UseThumbs, PdfName.FullScreen, PdfName.UseOC, PdfName.UseAttachments)));
    private static final Set<PdfName> PAGE_LAYOUTS = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.SinglePage, PdfName.OneColumn, PdfName.TwoColumnLeft, PdfName.TwoColumnRight, PdfName.TwoPageLeft, PdfName.TwoPageRight)));

    protected PdfCatalog(PdfDictionary pdfObject) {
        super(pdfObject);
        if (pdfObject == null) {
            throw new PdfException("Document has no PDF Catalog object.");
        }
        PdfCatalog.ensureObjectIsAddedToDocument(pdfObject);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Catalog);
        this.setForbidRelease();
        this.pageTree = new PdfPagesTree(this);
    }

    protected PdfCatalog(PdfDocument pdfDocument) {
        this((PdfDictionary)new PdfDictionary().makeIndirect(pdfDocument));
    }

    public PdfOCProperties getOCProperties(boolean createIfNotExists) {
        if (this.ocProperties != null) {
            return this.ocProperties;
        }
        PdfDictionary ocPropertiesDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.OCProperties);
        if (ocPropertiesDict != null) {
            if (this.getDocument().getWriter() != null) {
                ocPropertiesDict.makeIndirect(this.getDocument());
            }
            this.ocProperties = new PdfOCProperties(ocPropertiesDict);
        } else if (createIfNotExists) {
            this.ocProperties = new PdfOCProperties(this.getDocument());
        }
        return this.ocProperties;
    }

    public PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    @Override
    public void flush() {
        Logger logger = LoggerFactory.getLogger(PdfDocument.class);
        logger.warn("PdfCatalog cannot be flushed manually");
    }

    public PdfCatalog setOpenAction(PdfDestination destination) {
        return this.put(PdfName.OpenAction, (PdfObject)destination.getPdfObject());
    }

    public PdfCatalog setOpenAction(PdfAction action) {
        return this.put(PdfName.OpenAction, (PdfObject)action.getPdfObject());
    }

    public PdfCatalog setAdditionalAction(PdfName key, PdfAction action) {
        PdfAction.setAdditionalAction(this, key, action);
        return this;
    }

    public PdfCatalog setPageMode(PdfName pageMode) {
        if (PAGE_MODES.contains(pageMode)) {
            return this.put(PdfName.PageMode, pageMode);
        }
        return this;
    }

    public PdfName getPageMode() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.PageMode);
    }

    public PdfCatalog setPageLayout(PdfName pageLayout) {
        if (PAGE_LAYOUTS.contains(pageLayout)) {
            return this.put(PdfName.PageLayout, pageLayout);
        }
        return this;
    }

    public PdfName getPageLayout() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.PageLayout);
    }

    public PdfCatalog setViewerPreferences(PdfViewerPreferences preferences) {
        return this.put(PdfName.ViewerPreferences, (PdfObject)preferences.getPdfObject());
    }

    public PdfViewerPreferences getViewerPreferences() {
        PdfDictionary viewerPreferences = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.ViewerPreferences);
        if (viewerPreferences != null) {
            return new PdfViewerPreferences(viewerPreferences);
        }
        return null;
    }

    public PdfNameTree getNameTree(PdfName treeType) {
        PdfNameTree tree = this.nameTrees.get(treeType);
        if (tree == null) {
            tree = new PdfNameTree(this, treeType);
            this.nameTrees.put(treeType, tree);
        }
        return tree;
    }

    public PdfNumTree getPageLabelsTree(boolean createIfNotExists) {
        if (this.pageLabels == null && (((PdfDictionary)this.getPdfObject()).containsKey(PdfName.PageLabels) || createIfNotExists)) {
            this.pageLabels = new PdfNumTree(this, PdfName.PageLabels);
        }
        return this.pageLabels;
    }

    public void setLang(PdfString lang) {
        this.put(PdfName.Lang, lang);
    }

    public PdfString getLang() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Lang);
    }

    public void addDeveloperExtension(PdfDeveloperExtension extension) {
        PdfDictionary extensions = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Extensions);
        if (extensions == null) {
            extensions = new PdfDictionary();
            this.put(PdfName.Extensions, extensions);
        } else {
            PdfDictionary existingExtensionDict = extensions.getAsDictionary(extension.getPrefix());
            if (existingExtensionDict != null) {
                int diff = extension.getBaseVersion().compareTo(existingExtensionDict.getAsName(PdfName.BaseVersion));
                if (diff < 0) {
                    return;
                }
                diff = extension.getExtensionLevel() - existingExtensionDict.getAsNumber(PdfName.ExtensionLevel).intValue();
                if (diff <= 0) {
                    return;
                }
            }
        }
        extensions.put(extension.getPrefix(), extension.getDeveloperExtensions());
    }

    public PdfCollection getCollection() {
        PdfDictionary collectionDictionary = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Collection);
        if (collectionDictionary != null) {
            return new PdfCollection(collectionDictionary);
        }
        return null;
    }

    public PdfCatalog setCollection(PdfCollection collection) {
        this.put(PdfName.Collection, (PdfObject)collection.getPdfObject());
        return this;
    }

    public PdfCatalog put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }

    public PdfCatalog remove(PdfName key) {
        ((PdfDictionary)this.getPdfObject()).remove(key);
        this.setModified();
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected boolean isOCPropertiesMayHaveChanged() {
        return this.ocProperties != null;
    }

    PdfPagesTree getPageTree() {
        return this.pageTree;
    }

    Map<PdfObject, List<PdfOutline>> getPagesWithOutlines() {
        return this.pagesWithOutlines;
    }

    void addNamedDestination(String key, PdfObject value) {
        this.addNameToNameTree(key, value, PdfName.Dests);
    }

    void addNameToNameTree(String key, PdfObject value, PdfName treeType) {
        this.getNameTree(treeType).addEntry(key, value);
    }

    PdfOutline getOutlines(boolean updateOutlines) {
        if (this.outlines != null && !updateOutlines) {
            return this.outlines;
        }
        if (this.outlines != null) {
            this.outlines.clear();
            this.pagesWithOutlines.clear();
        }
        this.outlineMode = true;
        PdfNameTree destsTree = this.getNameTree(PdfName.Dests);
        PdfDictionary outlineRoot = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Outlines);
        if (outlineRoot == null) {
            if (null == this.getDocument().getWriter()) {
                return null;
            }
            this.outlines = new PdfOutline(this.getDocument());
        } else {
            this.constructOutlines(outlineRoot, destsTree.getNames());
        }
        return this.outlines;
    }

    boolean hasOutlines() {
        return ((PdfDictionary)this.getPdfObject()).containsKey(PdfName.Outlines);
    }

    boolean isOutlineMode() {
        return this.outlineMode;
    }

    void removeOutlines(PdfPage page) {
        if (this.getDocument().getWriter() == null) {
            return;
        }
        if (this.hasOutlines()) {
            this.getOutlines(false);
            if (this.pagesWithOutlines.size() > 0 && this.pagesWithOutlines.get(page.getPdfObject()) != null) {
                for (PdfOutline outline : this.pagesWithOutlines.get(page.getPdfObject())) {
                    outline.removeOutline();
                }
            }
        }
    }

    void addRootOutline(PdfOutline outline) {
        if (!this.outlineMode) {
            return;
        }
        if (this.pagesWithOutlines.size() == 0) {
            this.put(PdfName.Outlines, outline.getContent());
        }
    }

    PdfDestination copyDestination(PdfObject dest, Map<PdfPage, PdfPage> page2page, PdfDocument toDocument) {
        PdfDestination d;
        block4: {
            String srcDestName;
            PdfNameTree destsTree;
            Map<String, PdfObject> dests;
            PdfArray srcDestArray;
            block5: {
                if (null == dest) {
                    return null;
                }
                d = null;
                if (!dest.isArray()) break block5;
                PdfObject pageObject = ((PdfArray)dest).get(0);
                for (PdfPage oldPage : page2page.keySet()) {
                    if (oldPage.getPdfObject() != pageObject) continue;
                    PdfArray copiedArray = (PdfArray)dest.copyTo(toDocument, false);
                    d = new PdfExplicitDestination(copiedArray);
                    break block4;
                }
                break block4;
            }
            if (!dest.isString() && !dest.isName() || (srcDestArray = (PdfArray)(dests = (destsTree = this.getNameTree(PdfName.Dests)).getNames()).get(srcDestName = dest.isString() ? ((PdfString)dest).toUnicodeString() : ((PdfName)dest).getValue())) == null) break block4;
            PdfObject pageObject = srcDestArray.get(0);
            if (pageObject instanceof PdfNumber) {
                pageObject = this.getDocument().getPage(((PdfNumber)pageObject).intValue() + 1).getPdfObject();
            }
            for (PdfPage oldPage : page2page.keySet()) {
                if (oldPage.getPdfObject() != pageObject) continue;
                d = new PdfStringDestination(srcDestName);
                if (this.isEqualSameNameDestExist(page2page, toDocument, srcDestName, srcDestArray, oldPage)) break;
                PdfArray copiedArray = (PdfArray)srcDestArray.copyTo(toDocument, false);
                copiedArray.set(0, (PdfObject)page2page.get(oldPage).getPdfObject());
                toDocument.addNamedDestination(srcDestName, copiedArray);
                break;
            }
        }
        return d;
    }

    PdfDictionary fillAndGetOcPropertiesDictionary() {
        if (this.ocProperties != null) {
            this.ocProperties.fillDictionary(false);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.OCProperties, (PdfObject)this.ocProperties.getPdfObject());
            this.ocProperties = null;
        }
        if (((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.OCProperties) == null) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.makeIndirect(this.getDocument());
            ((PdfDictionary)this.getDocument().getCatalog().getPdfObject()).put(PdfName.OCProperties, pdfDictionary);
        }
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.OCProperties);
    }

    private boolean isEqualSameNameDestExist(Map<PdfPage, PdfPage> page2page, PdfDocument toDocument, String srcDestName, PdfArray srcDestArray, PdfPage oldPage) {
        PdfIndirectReference newDestPageRef;
        PdfIndirectReference existingDestPageRef;
        PdfArray sameNameDest = (PdfArray)toDocument.getCatalog().getNameTree(PdfName.Dests).getNames().get(srcDestName);
        boolean equalSameNameDestExists = false;
        if (sameNameDest != null && sameNameDest.getAsDictionary(0) != null && (equalSameNameDestExists = (existingDestPageRef = sameNameDest.getAsDictionary(0).getIndirectReference()).equals(newDestPageRef = ((PdfDictionary)page2page.get(oldPage).getPdfObject()).getIndirectReference()) && sameNameDest.size() == srcDestArray.size())) {
            for (int i = 1; i < sameNameDest.size(); ++i) {
                equalSameNameDestExists = equalSameNameDestExists && sameNameDest.get(i).equals(srcDestArray.get(i));
            }
        }
        return equalSameNameDestExists;
    }

    private void addOutlineToPage(PdfOutline outline, Map<String, PdfObject> names) {
        PdfObject pageObj = outline.getDestination().getDestinationPage(names);
        if (pageObj instanceof PdfNumber) {
            int pageNumber = ((PdfNumber)pageObj).intValue() + 1;
            try {
                pageObj = this.getDocument().getPage(pageNumber).getPdfObject();
            }
            catch (IndexOutOfBoundsException ex) {
                pageObj = null;
                LOGGER.warn(MessageFormatUtil.format((String)"Outline destination page number {0} is out of bounds", (Object[])new Object[]{pageNumber}));
            }
        }
        if (pageObj != null) {
            List<PdfOutline> outs = this.pagesWithOutlines.get(pageObj);
            if (outs == null) {
                outs = new ArrayList<PdfOutline>();
                this.pagesWithOutlines.put(pageObj, outs);
            }
            outs.add(outline);
        }
    }

    private PdfDictionary getNextOutline(PdfDictionary first, PdfDictionary next, PdfDictionary parent) {
        if (first != null) {
            return first;
        }
        if (next != null) {
            return next;
        }
        return this.getParentNextOutline(parent);
    }

    private PdfDictionary getParentNextOutline(PdfDictionary parent) {
        if (parent == null) {
            return null;
        }
        PdfDictionary current = null;
        while (current == null) {
            current = parent.getAsDictionary(PdfName.Next);
            if (current != null || (parent = parent.getAsDictionary(PdfName.Parent)) != null) continue;
            return null;
        }
        return current;
    }

    private void addOutlineToPage(PdfOutline outline, PdfDictionary item, Map<String, PdfObject> names) {
        PdfObject dest = item.get(PdfName.Dest);
        if (dest != null) {
            PdfDestination destination = PdfDestination.makeDestination(dest);
            outline.setDestination(destination);
            this.addOutlineToPage(outline, names);
        } else {
            PdfObject destObject;
            PdfName actionType;
            PdfDictionary action = item.getAsDictionary(PdfName.A);
            if (action != null && PdfName.GoTo.equals(actionType = action.getAsName(PdfName.S)) && (destObject = action.get(PdfName.D)) != null) {
                PdfDestination destination = PdfDestination.makeDestination(destObject);
                outline.setDestination(destination);
                this.addOutlineToPage(outline, names);
            }
        }
    }

    void constructOutlines(PdfDictionary outlineRoot, Map<String, PdfObject> names) {
        PdfDictionary first;
        if (outlineRoot == null) {
            return;
        }
        PdfDictionary current = first = outlineRoot.getAsDictionary(PdfName.First);
        HashMap<PdfDictionary, PdfOutline> parentOutlineMap = new HashMap<PdfDictionary, PdfOutline>();
        PdfOutline parentOutline = this.outlines = new PdfOutline(OutlineRoot, outlineRoot, this.getDocument());
        parentOutlineMap.put(outlineRoot, parentOutline);
        while (current != null) {
            first = current.getAsDictionary(PdfName.First);
            PdfDictionary next = current.getAsDictionary(PdfName.Next);
            PdfDictionary parent = current.getAsDictionary(PdfName.Parent);
            if (null == parent) {
                throw new PdfException(MessageFormatUtil.format((String)"Document outline is corrupted: some outline (PDF object: \"{0}\") lacks the required parent entry.", (Object[])new Object[]{current.indirectReference}));
            }
            PdfString title = current.getAsString(PdfName.Title);
            if (null == title) {
                throw new PdfException(MessageFormatUtil.format((String)"Document outline is corrupted: some outline (PDF object: \"{0}\") lacks the required title entry.", (Object[])new Object[]{current.indirectReference}));
            }
            parentOutline = (PdfOutline)parentOutlineMap.get(parent);
            PdfOutline currentOutline = new PdfOutline(title.toUnicodeString(), current, parentOutline);
            this.addOutlineToPage(currentOutline, current, names);
            parentOutline.getAllChildren().add(currentOutline);
            if (first != null) {
                parentOutlineMap.put(current, currentOutline);
            }
            current = this.getNextOutline(first, next, parent);
        }
    }
}

