/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.itemis.maven.plugins.unleash.util.Version;
import com.itemis.maven.plugins.unleash.util.VersionUpgradeStrategy;

public final class MavenVersionUtil {
    public static final String VERSION_QUALIFIER_SNAPSHOT = "-SNAPSHOT";
    public static final String VERSION_LATEST = "LATEST";

    private MavenVersionUtil() {
    }

    public static boolean isSnapshot(String version) {
        return version.toUpperCase().endsWith(VERSION_QUALIFIER_SNAPSHOT) || version.toUpperCase().equals(VERSION_LATEST);
    }

    public static String calculateNextSnapshotVersion(String version, VersionUpgradeStrategy upgradeStrategy) {
        VersionUpgradeStrategy strategy = upgradeStrategy != null ? upgradeStrategy : VersionUpgradeStrategy.DEFAULT;
        Version v = Version.parse(version);
        v.increase(strategy);
        String snapshotVersion = v.toString();
        if (!snapshotVersion.endsWith(VERSION_QUALIFIER_SNAPSHOT)) {
            snapshotVersion = snapshotVersion + VERSION_QUALIFIER_SNAPSHOT;
        }
        return snapshotVersion;
    }

    public static String calculateNextSnapshotVersion(String version) {
        return MavenVersionUtil.calculateNextSnapshotVersion(version, VersionUpgradeStrategy.DEFAULT);
    }

    public static String calculateReleaseVersion(String version) {
        if (version.toUpperCase().endsWith(VERSION_QUALIFIER_SNAPSHOT)) {
            return version.substring(0, version.length() - VERSION_QUALIFIER_SNAPSHOT.length());
        }
        return version;
    }

    public static boolean isNewerVersion(String version1, String version2) {
        String v2;
        String v1 = Strings.emptyToNull((String)version1);
        if (Objects.equal((Object)v1, (Object)(v2 = Strings.emptyToNull((String)version2)))) {
            return false;
        }
        if (v1 == null) {
            return false;
        }
        if (v2 == null) {
            return true;
        }
        if (Objects.equal((Object)VERSION_LATEST, (Object)v1)) {
            return true;
        }
        if (Objects.equal((Object)VERSION_LATEST, (Object)v2)) {
            return false;
        }
        String commonPrefix = Strings.commonPrefix((CharSequence)v1, (CharSequence)v2);
        v1 = v1.substring(commonPrefix.length());
        v2 = v2.substring(commonPrefix.length());
        String commonSuffix = Strings.commonSuffix((CharSequence)v1, (CharSequence)v2);
        v1 = v1.substring(0, v1.length() - commonSuffix.length());
        v2 = v2.substring(0, v2.length() - commonSuffix.length());
        if (v1.isEmpty()) {
            return Objects.equal((Object)VERSION_QUALIFIER_SNAPSHOT, (Object)v2.toUpperCase());
        }
        if (Objects.equal((Object)VERSION_QUALIFIER_SNAPSHOT, (Object)v1.toUpperCase())) {
            return false;
        }
        if (Objects.equal((Object)VERSION_QUALIFIER_SNAPSHOT, (Object)v2.toUpperCase())) {
            return true;
        }
        return v1.compareTo(v2) > 0;
    }
}

