/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.providers.util;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;

public class InMemoryIdentity
implements Identity {
    private JSch jsch;
    private KeyPair keyPair;
    private String identity;

    public static InMemoryIdentity newInstance(String name, String privateKey, JSch jsch) throws JSchException {
        KeyPair kpair = KeyPair.load((JSch)jsch, (byte[])privateKey.getBytes(), null);
        return new InMemoryIdentity(jsch, name, kpair);
    }

    private InMemoryIdentity(JSch jsch, String name, KeyPair keyPair) throws JSchException {
        this.jsch = jsch;
        this.identity = name;
        this.keyPair = keyPair;
    }

    public boolean setPassphrase(byte[] passphrase) throws JSchException {
        return this.keyPair.decrypt(passphrase);
    }

    public byte[] getPublicKeyBlob() {
        return this.keyPair.getPublicKeyBlob();
    }

    public byte[] getSignature(byte[] data) {
        return this.keyPair.getSignature(data);
    }

    public boolean decrypt() {
        throw new RuntimeException("not implemented");
    }

    public String getAlgName() {
        String algName;
        switch (this.keyPair.getKeyType()) {
            case 1: {
                algName = "ssh-dss";
                break;
            }
            case 2: {
                algName = "ssh-rsa";
                break;
            }
            default: {
                algName = "unknown";
            }
        }
        return algName;
    }

    public String getName() {
        return this.identity;
    }

    public boolean isEncrypted() {
        return this.keyPair.isEncrypted();
    }

    public void clear() {
        this.keyPair.dispose();
        this.keyPair = null;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }
}

