/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.providers.util;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.itemis.maven.plugins.unleash.scm.ScmException;
import com.itemis.maven.plugins.unleash.scm.ScmOperation;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class GitUtil {
    public static final String TAG_NAME_PREFIX = "refs/tags/";
    public static final String HEADS_NAME_PREFIX = "refs/heads/";
    private Git git;

    public GitUtil(Git git) {
        this.git = git;
    }

    public boolean isDirty(Set<String> paths) throws ScmException {
        try {
            StatusCommand status = this.git.status();
            for (String path : paths) {
                status.addPath(path);
            }
            return !status.call().isClean();
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.INFO, "Could not evaluate the status of the local repository.", (Throwable)e);
        }
    }

    public Set<String> getUncommittedChangedPaths() throws ScmException {
        try {
            StatusCommand status = this.git.status();
            return status.call().getUncommittedChanges();
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.INFO, "Could not evaluate the status of the local repository.", (Throwable)e);
        }
    }

    public String getCurrentConnectionUrl() throws ScmException {
        String localBranchName = this.getCurrentBranchName();
        String remoteName = this.getRemoteName(localBranchName);
        return this.getConnectionUrlOfRemote(remoteName);
    }

    public String getCurrentBranchName() throws ScmException {
        try {
            String branch = this.git.getRepository().getBranch();
            if (branch == null) {
                throw new ScmException(ScmOperation.INFO, "Unable to determine name of currently checked out local branch. The repository must be corrupt.");
            }
            return branch;
        }
        catch (IOException e) {
            throw new ScmException(ScmOperation.INFO, "Unable to determine name of currently checked out local branch.", (Throwable)e);
        }
    }

    public String getRemoteBranchName(String localBranch) {
        String remoteBranchName = this.git.getRepository().getConfig().getString("branch", localBranch, "merge");
        if (Strings.isNullOrEmpty((String)remoteBranchName)) {
            remoteBranchName = HEADS_NAME_PREFIX + localBranch;
        }
        return remoteBranchName;
    }

    public String getRemoteName(String localBranch) {
        String remote = this.git.getRepository().getConfig().getString("branch", localBranch, "remote");
        if (Strings.isNullOrEmpty((String)remote)) {
            try {
                List remotes = this.git.remoteList().call();
                if (remotes.size() > 0) {
                    remote = ((RemoteConfig)remotes.get(0)).getName();
                }
            }
            catch (GitAPIException e) {
                throw new ScmException(ScmOperation.INFO, "Unable to retrieve a list of remotes of the current local repository.", (Throwable)e);
            }
        }
        return remote;
    }

    public String getConnectionUrlOfRemote(String remoteName) {
        if (!Strings.isNullOrEmpty((String)remoteName)) {
            try {
                List remotes = this.git.remoteList().call();
                for (RemoteConfig remoteConfig : remotes) {
                    if (!Objects.equal((Object)remoteName, (Object)remoteConfig.getName())) continue;
                    List uris = remoteConfig.getURIs();
                    if (uris.size() > 0) {
                        return ((URIish)uris.get(0)).toString();
                    }
                    return null;
                }
            }
            catch (GitAPIException e) {
                throw new ScmException(ScmOperation.INFO, "Unable to retrieve a list of remotes of the current local repository.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasLocalTag(String tagName) {
        try {
            List tags = this.git.tagList().call();
            for (Ref tag : tags) {
                if (!Objects.equal((Object)tag.getName(), (Object)(TAG_NAME_PREFIX + tagName))) continue;
                return true;
            }
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.INFO, "An error occurred while querying the local git repository for tag '" + tagName + "'.", (Throwable)e);
        }
        return false;
    }

    public boolean hasLocalBranch(String branchName) {
        try {
            List branches = this.git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            for (Ref branch : branches) {
                if (!Objects.equal((Object)branch.getName(), (Object)(HEADS_NAME_PREFIX + branchName))) continue;
                return true;
            }
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.INFO, "An error occurred while querying the local git repository for branch '" + branchName + "'.", (Throwable)e);
        }
        return false;
    }

    public RevCommit resolveCommit(Optional<String> commitId, Optional<String> branchName) throws ScmException {
        try {
            LogCommand log = this.git.log();
            if (branchName.isPresent()) {
                String localBranchName = this.getCurrentBranchName();
                String remoteName = this.getRemoteName(localBranchName);
                log.add((AnyObjectId)this.git.getRepository().resolve(remoteName + "/" + (String)branchName.get()));
            }
            if (!commitId.isPresent()) {
                log.setMaxCount(1);
            }
            Iterable commits = log.call();
            if (commitId.isPresent()) {
                for (RevCommit commit : commits) {
                    if (!Objects.equal((Object)commitId.get(), (Object)commit.getId().getName())) continue;
                    return commit;
                }
                throw new ScmException(ScmOperation.INFO, "Could not resolve commit with id '" + (String)commitId.get() + (branchName.isPresent() ? "' for branch '" + (String)branchName.get() + "'." : "'."));
            }
            return (RevCommit)commits.iterator().next();
        }
        catch (Exception e) {
            throw new ScmException(ScmOperation.INFO, "Could not resolve commit with id '" + (String)commitId.or((Object)"HEAD") + (branchName.isPresent() ? "' for branch '" + (String)branchName.get() + "'." : "'."), (Throwable)e);
        }
    }

    public List<RevCommit> resolveCommitRange(String from, String to) throws Exception {
        ObjectId fromId = this.git.getRepository().resolve(from);
        ObjectId toId = this.git.getRepository().resolve(to);
        Iterable commits = this.git.log().addRange((AnyObjectId)fromId, (AnyObjectId)toId).call();
        return Lists.newArrayList((Iterable)commits);
    }
}

