/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.providers.merge;

import com.google.common.io.Closeables;
import com.itemis.maven.plugins.unleash.scm.merge.MergeClient;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeAlgorithm;
import org.eclipse.jgit.merge.MergeChunk;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.TemporaryBuffer;

public class UnleashGitMerger
extends ResolveMerger {
    protected NameConflictTreeWalk tw;
    protected String[] commitNames;
    protected static final int T_BASE = 0;
    protected static final int T_OURS = 1;
    protected static final int T_THEIRS = 2;
    protected static final int T_INDEX = 3;
    protected static final int T_FILE = 4;
    protected DirCacheBuilder builder;
    protected ObjectId resultTree;
    protected List<String> unmergedPaths = new ArrayList<String>();
    protected List<String> modifiedFiles = new LinkedList<String>();
    protected Map<String, DirCacheEntry> toBeCheckedOut = new HashMap<String, DirCacheEntry>();
    protected List<String> toBeDeleted = new ArrayList<String>();
    protected Map<String, MergeResult<? extends Sequence>> mergeResults = new HashMap<String, MergeResult<? extends Sequence>>();
    protected Map<String, ResolveMerger.MergeFailureReason> failingPaths = new HashMap<String, ResolveMerger.MergeFailureReason>();
    protected boolean enterSubtree;
    protected boolean inCore;
    protected boolean implicitDirCache;
    protected DirCache dircache;
    protected WorkingTreeIterator workingTreeIterator;
    protected MergeAlgorithm mergeAlgorithm;
    private MergeClient mergeClient;

    protected UnleashGitMerger(Repository local, boolean inCore, MergeClient mergeClient) {
        super(local);
        this.mergeClient = mergeClient;
        DiffAlgorithm.SupportedAlgorithm diffAlg = (DiffAlgorithm.SupportedAlgorithm)local.getConfig().getEnum("diff", null, "algorithm", (Enum)DiffAlgorithm.SupportedAlgorithm.HISTOGRAM);
        this.mergeAlgorithm = new MergeAlgorithm(DiffAlgorithm.getAlgorithm((DiffAlgorithm.SupportedAlgorithm)diffAlg));
        this.commitNames = new String[]{"BASE", "OURS", "THEIRS"};
        this.inCore = inCore;
        if (inCore) {
            this.implicitDirCache = false;
            this.dircache = DirCache.newInCore();
        } else {
            this.implicitDirCache = true;
        }
    }

    protected UnleashGitMerger(Repository local, MergeClient mergeClient) {
        this(local, false, mergeClient);
    }

    protected boolean mergeImpl() throws IOException {
        if (this.implicitDirCache) {
            this.dircache = this.getRepository().lockDirCache();
        }
        try {
            boolean bl = this.mergeTrees(this.mergeBase(), this.sourceTrees[0], this.sourceTrees[1], false);
            return bl;
        }
        finally {
            if (this.implicitDirCache) {
                this.dircache.unlock();
            }
        }
    }

    private void checkout() throws NoWorkTreeException, IOException {
        for (int i = this.toBeDeleted.size() - 1; i >= 0; --i) {
            String fileName = this.toBeDeleted.get(i);
            File f = new File(this.db.getWorkTree(), fileName);
            if (!f.delete() && !f.isDirectory()) {
                this.failingPaths.put(fileName, ResolveMerger.MergeFailureReason.COULD_NOT_DELETE);
            }
            this.modifiedFiles.add(fileName);
        }
        for (Map.Entry<String, DirCacheEntry> entry : this.toBeCheckedOut.entrySet()) {
            DirCacheCheckout.checkoutEntry((Repository)this.db, (DirCacheEntry)entry.getValue(), (ObjectReader)this.reader);
            this.modifiedFiles.add(entry.getKey());
        }
    }

    protected void cleanUp() throws NoWorkTreeException, CorruptObjectException, IOException {
        if (this.inCore) {
            this.modifiedFiles.clear();
            return;
        }
        DirCache dc = this.db.readDirCache();
        Iterator<String> mpathsIt = this.modifiedFiles.iterator();
        while (mpathsIt.hasNext()) {
            String mpath = mpathsIt.next();
            DirCacheEntry entry = dc.getEntry(mpath);
            if (entry != null) {
                DirCacheCheckout.checkoutEntry((Repository)this.db, (DirCacheEntry)entry, (ObjectReader)this.reader);
            }
            mpathsIt.remove();
        }
    }

    private DirCacheEntry add(byte[] path, CanonicalTreeParser p, int stage, long lastMod, long len) {
        if (p != null && !p.getEntryFileMode().equals(FileMode.TREE)) {
            DirCacheEntry e = new DirCacheEntry(path, stage);
            e.setFileMode(p.getEntryFileMode());
            e.setObjectId((AnyObjectId)p.getEntryObjectId());
            e.setLastModified(lastMod);
            e.setLength(len);
            this.builder.add(e);
            return e;
        }
        return null;
    }

    private DirCacheEntry keep(DirCacheEntry e) {
        DirCacheEntry newEntry = new DirCacheEntry(e.getPathString(), e.getStage());
        newEntry.setFileMode(e.getFileMode());
        newEntry.setObjectId((AnyObjectId)e.getObjectId());
        newEntry.setLastModified(e.getLastModified());
        newEntry.setLength(e.getLength());
        this.builder.add(newEntry);
        return newEntry;
    }

    protected boolean processEntry(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, DirCacheBuildIterator index, WorkingTreeIterator work, boolean ignoreConflicts) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        this.enterSubtree = true;
        int modeO = this.tw.getRawMode(1);
        int modeT = this.tw.getRawMode(2);
        int modeB = this.tw.getRawMode(0);
        if (modeO == 0 && modeT == 0 && modeB == 0) {
            return true;
        }
        if (this.isIndexDirty()) {
            return false;
        }
        DirCacheEntry ourDce = null;
        if (index == null || index.getDirCacheEntry() == null) {
            if (UnleashGitMerger.nonTree(modeO)) {
                ourDce = new DirCacheEntry(this.tw.getRawPath());
                ourDce.setObjectId((AnyObjectId)this.tw.getObjectId(1));
                ourDce.setFileMode(this.tw.getFileMode(1));
            }
        } else {
            ourDce = index.getDirCacheEntry();
        }
        if (UnleashGitMerger.nonTree(modeO) && UnleashGitMerger.nonTree(modeT) && this.tw.idEqual(1, 2)) {
            if (modeO == modeT) {
                this.keep(ourDce);
                return true;
            }
            int newMode = this.mergeFileModes(modeB, modeO, modeT);
            if (newMode != FileMode.MISSING.getBits()) {
                if (newMode == modeO) {
                    this.keep(ourDce);
                } else {
                    if (this.isWorktreeDirty(work, ourDce)) {
                        return false;
                    }
                    DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, 0L, 0L);
                    this.toBeCheckedOut.put(this.tw.getPathString(), e);
                }
                return true;
            }
            this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
            this.add(this.tw.getRawPath(), ours, 2, 0L, 0L);
            this.add(this.tw.getRawPath(), theirs, 3, 0L, 0L);
            this.unmergedPaths.add(this.tw.getPathString());
            this.mergeResults.put(this.tw.getPathString(), (MergeResult<? extends Sequence>)new MergeResult(Collections.emptyList()));
            return true;
        }
        if (modeB == modeT && this.tw.idEqual(0, 2)) {
            if (ourDce != null) {
                this.keep(ourDce);
            }
            return true;
        }
        if (modeB == modeO && this.tw.idEqual(0, 1)) {
            if (this.isWorktreeDirty(work, ourDce)) {
                return false;
            }
            if (UnleashGitMerger.nonTree(modeT)) {
                DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, 0L, 0L);
                if (e != null) {
                    this.toBeCheckedOut.put(this.tw.getPathString(), e);
                }
                return true;
            }
            if (this.tw.getTreeCount() > 4 && this.tw.getRawMode(4) == 0) {
                return true;
            }
            this.toBeDeleted.add(this.tw.getPathString());
            return true;
        }
        if (this.tw.isSubtree()) {
            if (UnleashGitMerger.nonTree(modeO) && !UnleashGitMerger.nonTree(modeT)) {
                if (UnleashGitMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
                }
                this.add(this.tw.getRawPath(), ours, 2, 0L, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (UnleashGitMerger.nonTree(modeT) && !UnleashGitMerger.nonTree(modeO)) {
                if (UnleashGitMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
                }
                this.add(this.tw.getRawPath(), theirs, 3, 0L, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (!UnleashGitMerger.nonTree(modeO)) {
                return true;
            }
        }
        if (UnleashGitMerger.nonTree(modeO) && UnleashGitMerger.nonTree(modeT)) {
            if (this.isWorktreeDirty(work, ourDce)) {
                return false;
            }
            if (UnleashGitMerger.isGitLink(modeO) || UnleashGitMerger.isGitLink(modeT)) {
                this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
                this.add(this.tw.getRawPath(), ours, 2, 0L, 0L);
                this.add(this.tw.getRawPath(), theirs, 3, 0L, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            MergeResult<RawText> result = this.contentMerge(base, ours, theirs);
            this.updateIndex(base, ours, theirs, result);
            if (result.containsConflicts() && !ignoreConflicts) {
                this.unmergedPaths.add(this.tw.getPathString());
            }
            this.modifiedFiles.add(this.tw.getPathString());
        } else if (modeO != modeT && (modeO != 0 && !this.tw.idEqual(0, 1) || modeT != 0 && !this.tw.idEqual(0, 2))) {
            this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
            this.add(this.tw.getRawPath(), ours, 2, 0L, 0L);
            DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 3, 0L, 0L);
            if (modeO == 0) {
                if (this.isWorktreeDirty(work, ourDce)) {
                    return false;
                }
                if (UnleashGitMerger.nonTree(modeT) && e != null) {
                    this.toBeCheckedOut.put(this.tw.getPathString(), e);
                }
            }
            this.unmergedPaths.add(this.tw.getPathString());
            this.mergeResults.put(this.tw.getPathString(), this.contentMerge(base, ours, theirs));
        }
        return true;
    }

    private MergeResult<RawText> contentMerge(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs) throws IOException {
        InputStream localIn = this.getInputStream(ours.getEntryObjectId());
        InputStream remoteIn = this.getInputStream(theirs.getEntryObjectId());
        InputStream baseIn = this.getInputStream(base.getEntryObjectId());
        ByteArrayOutputStream resultOut = new ByteArrayOutputStream();
        this.mergeClient.merge(localIn, remoteIn, baseIn, (OutputStream)resultOut);
        RawText resultText = new RawText(resultOut.toByteArray());
        ArrayList<RawText> sequences = new ArrayList<RawText>(1);
        sequences.add(resultText);
        MergeResult result = new MergeResult(sequences);
        result.add(0, 0, resultText.size(), MergeChunk.ConflictState.NO_CONFLICT);
        return result;
    }

    private InputStream getInputStream(ObjectId id) throws IOException {
        if (id.equals((AnyObjectId)ObjectId.zeroId())) {
            return null;
        }
        return this.reader.open((AnyObjectId)id, 3).openStream();
    }

    private boolean isIndexDirty() {
        boolean isDirty;
        if (this.inCore) {
            return false;
        }
        int modeI = this.tw.getRawMode(3);
        int modeO = this.tw.getRawMode(1);
        boolean bl = isDirty = UnleashGitMerger.nonTree(modeI) && (modeO != modeI || !this.tw.idEqual(3, 1));
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), ResolveMerger.MergeFailureReason.DIRTY_INDEX);
        }
        return isDirty;
    }

    private boolean isWorktreeDirty(WorkingTreeIterator work, DirCacheEntry ourDce) throws IOException {
        boolean isDirty;
        if (work == null) {
            return false;
        }
        int modeF = this.tw.getRawMode(4);
        int modeO = this.tw.getRawMode(1);
        if (ourDce != null) {
            isDirty = work.isModified(ourDce, true, this.reader);
        } else {
            isDirty = work.isModeDifferent(modeO);
            if (!isDirty && UnleashGitMerger.nonTree(modeF)) {
                boolean bl = isDirty = !this.tw.idEqual(4, 1);
            }
        }
        if (isDirty && modeF == 16384 && modeO == 0) {
            isDirty = false;
        }
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), ResolveMerger.MergeFailureReason.DIRTY_WORKTREE);
        }
        return isDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndex(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, MergeResult<RawText> result) throws FileNotFoundException, IOException {
        File mergedFile;
        File file = mergedFile = !this.inCore ? this.writeMergedFile(result) : null;
        if (result.containsConflicts()) {
            this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
            this.add(this.tw.getRawPath(), ours, 2, 0L, 0L);
            this.add(this.tw.getRawPath(), theirs, 3, 0L, 0L);
            this.mergeResults.put(this.tw.getPathString(), result);
            return;
        }
        DirCacheEntry dce = new DirCacheEntry(this.tw.getPathString());
        int newMode = this.mergeFileModes(this.tw.getRawMode(0), this.tw.getRawMode(1), this.tw.getRawMode(2));
        dce.setFileMode(newMode == FileMode.MISSING.getBits() ? FileMode.REGULAR_FILE : FileMode.fromBits((int)newMode));
        if (mergedFile != null) {
            long len = mergedFile.length();
            dce.setLastModified(mergedFile.lastModified());
            dce.setLength((int)len);
            FileInputStream is = new FileInputStream(mergedFile);
            try {
                dce.setObjectId((AnyObjectId)this.getObjectInserter().insert(3, len, (InputStream)is));
            }
            finally {
                ((InputStream)is).close();
            }
        } else {
            dce.setObjectId((AnyObjectId)this.insertMergeResult(result));
        }
        this.builder.add(dce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeMergedFile(MergeResult<RawText> result) throws FileNotFoundException, IOException {
        File of;
        File parentFolder;
        File workTree = this.db.getWorkTree();
        FS fs = this.db.getFS();
        if (!fs.exists(parentFolder = (of = new File(workTree, this.tw.getPathString())).getParentFile())) {
            parentFolder.mkdirs();
        }
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(of));
            new MergeFormatter().formatMerge((OutputStream)os, result, Arrays.asList(this.commitNames), "UTF-8");
        }
        catch (Throwable throwable) {
            Closeables.close(os, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)os, (boolean)true);
        return of;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectId insertMergeResult(MergeResult<RawText> result) throws IOException {
        TemporaryBuffer.LocalFile buf = new TemporaryBuffer.LocalFile(this.db.getDirectory(), 0xA00000);
        try {
            ObjectId objectId;
            new MergeFormatter().formatMerge((OutputStream)buf, result, Arrays.asList(this.commitNames), "UTF-8");
            buf.close();
            InputStream in = null;
            try {
                in = buf.openInputStream();
                objectId = this.getObjectInserter().insert(3, buf.length(), in);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly((InputStream)in);
                throw throwable;
            }
            Closeables.closeQuietly((InputStream)in);
            return objectId;
        }
        finally {
            buf.destroy();
        }
    }

    private int mergeFileModes(int modeB, int modeO, int modeT) {
        if (modeO == modeT) {
            return modeO;
        }
        if (modeB == modeO) {
            return modeT == FileMode.MISSING.getBits() ? modeO : modeT;
        }
        if (modeB == modeT) {
            return modeO == FileMode.MISSING.getBits() ? modeT : modeO;
        }
        return FileMode.MISSING.getBits();
    }

    private static RawText getRawText(ObjectId id, ObjectReader reader) throws IOException {
        if (id.equals((AnyObjectId)ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        return new RawText(reader.open((AnyObjectId)id, 3).getCachedBytes());
    }

    private static boolean nonTree(int mode) {
        return mode != 0 && !FileMode.TREE.equals(mode);
    }

    private static boolean isGitLink(int mode) {
        return FileMode.GITLINK.equals(mode);
    }

    public ObjectId getResultTreeId() {
        return this.resultTree == null ? null : this.resultTree.toObjectId();
    }

    public void setCommitNames(String[] commitNames) {
        this.commitNames = commitNames;
    }

    public String[] getCommitNames() {
        return this.commitNames;
    }

    public List<String> getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public List<String> getModifiedFiles() {
        return this.modifiedFiles;
    }

    public Map<String, DirCacheEntry> getToBeCheckedOut() {
        return this.toBeCheckedOut;
    }

    public Map<String, MergeResult<? extends Sequence>> getMergeResults() {
        return this.mergeResults;
    }

    public Map<String, ResolveMerger.MergeFailureReason> getFailingPaths() {
        return this.failingPaths.size() == 0 ? null : this.failingPaths;
    }

    public boolean failed() {
        return this.failingPaths.size() > 0;
    }

    public void setDirCache(DirCache dc) {
        this.dircache = dc;
        this.implicitDirCache = false;
    }

    public void setWorkingTreeIterator(WorkingTreeIterator workingTreeIterator) {
        this.workingTreeIterator = workingTreeIterator;
    }

    protected boolean mergeTrees(AbstractTreeIterator baseTree, RevTree headTree, RevTree mergeTree, boolean ignoreConflicts) throws IOException {
        this.builder = this.dircache.builder();
        DirCacheBuildIterator buildIt = new DirCacheBuildIterator(this.builder);
        this.tw = new NameConflictTreeWalk(this.reader);
        this.tw.addTree(baseTree);
        this.tw.addTree((AnyObjectId)headTree);
        this.tw.addTree((AnyObjectId)mergeTree);
        this.tw.addTree((AbstractTreeIterator)buildIt);
        if (this.workingTreeIterator != null) {
            this.tw.addTree((AbstractTreeIterator)this.workingTreeIterator);
        } else {
            this.tw.setFilter(TreeFilter.ANY_DIFF);
        }
        if (!this.mergeTreeWalk((TreeWalk)this.tw, ignoreConflicts)) {
            return false;
        }
        if (!this.inCore) {
            this.checkout();
            if (!this.builder.commit()) {
                this.cleanUp();
                throw new IndexWriteException();
            }
            this.builder = null;
        } else {
            this.builder.finish();
            this.builder = null;
        }
        if (this.getUnmergedPaths().isEmpty() && !this.failed()) {
            this.resultTree = this.dircache.writeTree(this.getObjectInserter());
            return true;
        }
        this.resultTree = null;
        return false;
    }

    protected boolean mergeTreeWalk(TreeWalk treeWalk, boolean ignoreConflicts) throws IOException {
        boolean hasWorkingTreeIterator;
        boolean bl = hasWorkingTreeIterator = this.tw.getTreeCount() > 4;
        while (treeWalk.next()) {
            if (!this.processEntry((CanonicalTreeParser)treeWalk.getTree(0, CanonicalTreeParser.class), (CanonicalTreeParser)treeWalk.getTree(1, CanonicalTreeParser.class), (CanonicalTreeParser)treeWalk.getTree(2, CanonicalTreeParser.class), (DirCacheBuildIterator)treeWalk.getTree(3, DirCacheBuildIterator.class), hasWorkingTreeIterator ? (WorkingTreeIterator)treeWalk.getTree(4, WorkingTreeIterator.class) : null, ignoreConflicts)) {
                this.cleanUp();
                return false;
            }
            if (!treeWalk.isSubtree() || !this.enterSubtree) continue;
            treeWalk.enterSubtree();
        }
        return true;
    }
}

