/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.providers;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.itemis.maven.plugins.unleash.scm.ScmException;
import com.itemis.maven.plugins.unleash.scm.ScmOperation;
import com.itemis.maven.plugins.unleash.scm.ScmProvider;
import com.itemis.maven.plugins.unleash.scm.ScmProviderInitialization;
import com.itemis.maven.plugins.unleash.scm.annotations.ScmProviderType;
import com.itemis.maven.plugins.unleash.scm.merge.MergeClient;
import com.itemis.maven.plugins.unleash.scm.providers.GitSshSessionFactory;
import com.itemis.maven.plugins.unleash.scm.providers.merge.UnleashGitFullMergeStrategy;
import com.itemis.maven.plugins.unleash.scm.providers.util.GitUtil;
import com.itemis.maven.plugins.unleash.scm.requests.BranchRequest;
import com.itemis.maven.plugins.unleash.scm.requests.CheckoutRequest;
import com.itemis.maven.plugins.unleash.scm.requests.CommitRequest;
import com.itemis.maven.plugins.unleash.scm.requests.DeleteBranchRequest;
import com.itemis.maven.plugins.unleash.scm.requests.DeleteTagRequest;
import com.itemis.maven.plugins.unleash.scm.requests.DiffRequest;
import com.itemis.maven.plugins.unleash.scm.requests.HistoryRequest;
import com.itemis.maven.plugins.unleash.scm.requests.PushRequest;
import com.itemis.maven.plugins.unleash.scm.requests.RevertCommitsRequest;
import com.itemis.maven.plugins.unleash.scm.requests.TagRequest;
import com.itemis.maven.plugins.unleash.scm.requests.UpdateRequest;
import com.itemis.maven.plugins.unleash.scm.results.DiffObject;
import com.itemis.maven.plugins.unleash.scm.results.DiffResult;
import com.itemis.maven.plugins.unleash.scm.results.HistoryCommit;
import com.itemis.maven.plugins.unleash.scm.results.HistoryResult;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteTagCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RevertCommand;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

@ScmProviderType(value="git")
public class ScmProviderGit
implements ScmProvider {
    private static final String LOG_PREFIX = "Git - ";
    private Logger log;
    private Git git;
    private PersonIdent personIdent;
    private CredentialsProvider credentialsProvider;
    private SshSessionFactory sshSessionFactory;
    private File workingDir;
    private List<String> additionalThingsToPush;
    private GitUtil util;

    public void initialize(ScmProviderInitialization initialization) {
        this.log = (Logger)initialization.getLogger().or((Object)Logger.getLogger(ScmProvider.class.getName()));
        this.workingDir = initialization.getWorkingDirectory();
        this.additionalThingsToPush = Lists.newArrayList();
        if (this.workingDir.exists() && this.workingDir.isDirectory() && this.workingDir.list().length > 0) {
            try {
                FileRepositoryBuilder builder = new FileRepositoryBuilder();
                Repository repo = ((FileRepositoryBuilder)builder.findGitDir(this.workingDir)).build();
                this.git = Git.wrap((Repository)repo);
                this.personIdent = new PersonIdent(repo);
                this.util = new GitUtil(this.git);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (initialization.getUsername().isPresent()) {
            this.credentialsProvider = new UsernamePasswordCredentialsProvider((String)initialization.getUsername().get(), (String)initialization.getPassword().or((Object)""));
        }
        this.sshSessionFactory = new GitSshSessionFactory(initialization, this.log);
    }

    public void close() {
        if (this.git != null) {
            this.git.close();
        }
    }

    public void testConnection(String repositoryUrl) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Testing repository connection (URL: " + repositoryUrl + ").");
        }
        try {
            LsRemoteCommand lsRemote = Git.lsRemoteRepository().setHeads(true).setRemote(repositoryUrl);
            this.setAuthenticationDetails((TransportCommand<?, ?>)lsRemote);
            Collection result = lsRemote.call();
            if (result.isEmpty()) {
                throw new ScmException(ScmOperation.INFO, "No connection could be established to repository: " + repositoryUrl);
            }
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.INFO, "No connection could be established to repository: " + repositoryUrl, (Throwable)e);
        }
    }

    public void checkout(CheckoutRequest request) throws ScmException {
        CheckoutCommand checkout;
        StringBuilder message;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Checking out from remote repository.");
        }
        if (this.workingDir.exists() && this.workingDir.list().length > 0) {
            throw new ScmException(ScmOperation.CHECKOUT, "Unable to checkout remote repository '" + request.getRemoteRepositoryUrl() + "'. Local working directory '" + this.workingDir.getAbsolutePath() + "' is not empty!");
        }
        try {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Git - Cloning remote repository.");
                message = new StringBuilder(LOG_PREFIX).append("Clone info:\n");
                message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
                message.append("\t- REMOTE_URL: ").append(request.getRemoteRepositoryUrl());
                this.log.fine(message.toString());
            }
            CloneCommand clone = Git.cloneRepository().setDirectory(this.workingDir).setURI(request.getRemoteRepositoryUrl());
            this.setAuthenticationDetails((TransportCommand<?, ?>)clone);
            if (!request.checkoutWholeRepository()) {
                clone.setNoCheckout(true);
            }
            this.git = clone.call();
            this.util = new GitUtil(this.git);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Git - Cloning remote repository finished successfully.\n");
            }
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.CHECKOUT, "Unable to clone remote git repository '" + request.getRemoteRepositoryUrl() + "' into local working directory '" + this.workingDir.getAbsolutePath() + "'.", (Throwable)e);
        }
        if (!request.checkoutWholeRepository()) {
            String revision = (String)request.getRevision().or((Object)"HEAD");
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Git - Checking out single files only.");
                StringBuilder message2 = new StringBuilder(LOG_PREFIX).append("Checkout info:\n");
                message2.append("\t- FILES: ").append(Joiner.on((char)',').join((Iterable)request.getPathsToCheckout())).append('\n');
                message2.append("\t- REVISION: ").append(revision);
                this.log.fine(message2.toString());
            }
            try {
                CheckoutCommand checkout2 = this.git.checkout().setStartPoint(revision).setAllPaths(false);
                for (String path : request.getPathsToCheckout()) {
                    checkout2.addPath(path);
                }
                checkout2.call();
            }
            catch (GitAPIException e) {
                throw new ScmException(ScmOperation.CHECKOUT, "Unable to checkout commit with id '" + (String)request.getRevision().get() + "' into local working directory '" + this.workingDir.getAbsolutePath() + "'.", (Throwable)e);
            }
        }
        if (request.checkoutBranch()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Git - Checking out branch" + (String)request.getBranch().get() + ".");
            }
            if (this.hasBranch((String)request.getBranch().get())) {
                RevCommit startPoint = this.util.resolveCommit((Optional<String>)request.getRevision(), (Optional<String>)request.getBranch());
                if (this.log.isLoggable(Level.FINE)) {
                    StringBuilder message3 = new StringBuilder(LOG_PREFIX).append("Checkout info:\n");
                    message3.append("\t- BRANCH: ").append((String)request.getBranch().get()).append('\n');
                    message3.append("\t- REVISION: ").append(startPoint.getName());
                    this.log.fine(message3.toString());
                }
                try {
                    CheckoutCommand checkout3 = this.git.checkout().setName((String)request.getBranch().get()).setCreateBranch(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint(startPoint);
                    checkout3.call();
                }
                catch (GitAPIException e) {
                    throw new ScmException(ScmOperation.CHECKOUT, "Unable to checkout '" + (String)request.getBranch().get() + "' into local working directory '" + this.workingDir.getAbsolutePath() + "'.", (Throwable)e);
                }
            } else if (this.log.isLoggable(Level.WARNING)) {
                message = new StringBuilder(LOG_PREFIX).append("The remote repository contains no branch with name '").append((String)request.getBranch().get()).append("'. Staying on current branch '").append(this.util.getCurrentBranchName()).append("'.");
                this.log.warning(message.toString());
            }
        } else if (request.checkoutTag()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Git - Checking out tag" + (String)request.getTag().get() + ".");
            }
            if (this.hasTag((String)request.getTag().get())) {
                try {
                    checkout = this.git.checkout().setName((String)request.getTag().get());
                    checkout.call();
                }
                catch (GitAPIException e) {
                    throw new ScmException(ScmOperation.CHECKOUT, "Unable to checkout tag '" + (String)request.getTag().get() + "' into local working directory '" + this.workingDir.getAbsolutePath() + "'.", (Throwable)e);
                }
            } else if (this.log.isLoggable(Level.WARNING)) {
                message = new StringBuilder(LOG_PREFIX).append("The remote repository contains no tag with name '").append((String)request.getTag().get()).append("'. Staying on current branch '").append(this.util.getCurrentBranchName()).append("'.");
                this.log.warning(message.toString());
            }
        } else if (request.getRevision().isPresent()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Git - Checking out a specific revision from current branch.");
                message = new StringBuilder(LOG_PREFIX).append("Checkout info:\n");
                message.append("\t- BRANCH: ").append(this.util.getCurrentBranchName()).append('\n');
                message.append("\t- REVISION: ").append((String)request.getRevision().get());
                this.log.fine(message.toString());
            }
            try {
                checkout = this.git.checkout().setName((String)request.getRevision().get());
                checkout.call();
            }
            catch (GitAPIException e) {
                throw new ScmException(ScmOperation.CHECKOUT, "Unable to checkout commit with id '" + (String)request.getRevision().get() + "' into local working directory '" + this.workingDir.getAbsolutePath() + "'.", (Throwable)e);
            }
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Checkout finished successfully!");
        }
    }

    /*
     * WARNING - void declaration
     */
    public String commit(CommitRequest request) throws ScmException {
        void var4_13;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Committing local changes.");
        }
        if (!this.util.isDirty(request.getPathsToCommit())) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Git - Nothing to commit here.");
            }
            return request.push() ? this.getLatestRemoteRevision() : this.getLocalRevision();
        }
        if (this.log.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder("Git - Commit info:\n");
            message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
            message.append("\t- MERGE_STRATEGY: ").append(request.getMergeStrategy()).append('\n');
            message.append("\t- PUSH: ").append(request.push()).append('\n');
            message.append("\t- COMMIT_ALL_CHANGES: ").append(request.commitAllChanges());
            if (!request.commitAllChanges()) {
                message.append("\n\t- FILES: ").append(Joiner.on((char)',').join((Iterable)request.getPathsToCommit()));
            }
            this.log.fine(message.toString());
        }
        AddCommand add = this.git.add();
        if (request.commitAllChanges()) {
            if (request.includeUntrackedFiles()) {
                add.addFilepattern(".");
            } else {
                for (String string : this.util.getUncommittedChangedPaths()) {
                    add.addFilepattern(string);
                }
            }
        } else {
            for (String string : request.getPathsToCommit()) {
                add.addFilepattern(string);
            }
        }
        try {
            add.call();
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.COMMIT, "Unable to add local changes to the index.", (Throwable)e);
        }
        CommitCommand commit = this.git.commit().setMessage(request.getMessage()).setCommitter(this.personIdent);
        if (request.commitAllChanges()) {
            commit.setAll(true);
        } else {
            for (String path : request.getPathsToCommit()) {
                commit.setOnly(path);
            }
        }
        Object var4_10 = null;
        try {
            RevCommit result = commit.call();
            String string = result.getName();
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.DELETE_TAG, "Could not commit chanhes of local repository.", (Throwable)e);
        }
        if (request.push()) {
            PushRequest pr = PushRequest.builder().mergeStrategy(request.getMergeStrategy()).mergeClient((MergeClient)request.getMergeClient().orNull()).build();
            this.push(pr);
            String string = this.getLatestRemoteRevision();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Commit finished successfully. New revision is: " + (String)var4_13);
        }
        return var4_13;
    }

    public String push(PushRequest request) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Pushing local changes to remote repository.");
        }
        String localBranchName = this.util.getCurrentBranchName();
        String remoteBranchName = this.util.getRemoteBranchName(localBranchName);
        String remoteName = this.util.getRemoteName(localBranchName);
        String remoteUrl = this.util.getConnectionUrlOfRemote(remoteName);
        if (this.log.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder("Git - Push info:\n");
            message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
            message.append("\t- LOCAL_BRANCH: ").append(localBranchName).append('\n');
            message.append("\t- REMOTE_BRANCH: ").append(remoteBranchName).append('\n');
            message.append("\t- REMOTE: ").append(remoteName).append('\n');
            message.append("\t- REMOTE_URL: ").append(remoteUrl).append('\n');
            message.append("\t- MERGE_STRATEGY: ").append(request.getMergeStrategy()).append('\n');
            this.log.fine(message.toString());
        }
        UpdateRequest ur = UpdateRequest.builder().mergeStrategy(request.getMergeStrategy()).mergeClient((MergeClient)request.getMergeClient().orNull()).build();
        this.update(ur);
        try {
            PushCommand push = this.git.push().setRemote(remoteName).setPushAll().setPushTags();
            this.setAuthenticationDetails((TransportCommand<?, ?>)push);
            for (String additional : this.additionalThingsToPush) {
                push.add(additional);
            }
            Iterable results = push.call();
            RemoteRefUpdate.Status failureStatus = null;
            String reason = null;
            block3: for (PushResult result : results) {
                Collection updates = result.getRemoteUpdates();
                for (RemoteRefUpdate update : updates) {
                    if (update.getStatus() == RemoteRefUpdate.Status.OK || update.getStatus() == RemoteRefUpdate.Status.UP_TO_DATE) continue;
                    failureStatus = update.getStatus();
                    reason = update.getMessage();
                    break block3;
                }
            }
            if (failureStatus != null) {
                StringBuilder message = new StringBuilder("Could not push local changes to the remote repository due to the following error: [").append(failureStatus).append("] ");
                if (reason != null) {
                    message.append(reason);
                }
                throw new ScmException(ScmOperation.PUSH, message.toString());
            }
            this.additionalThingsToPush.clear();
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.PUSH, "Could not push local commits to remote repository", (Throwable)e);
        }
        String newRemoteRevision = this.getLatestRemoteRevision();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Push finished successfully. New remote revision is: " + newRemoteRevision);
        }
        return newRemoteRevision;
    }

    public String update(UpdateRequest request) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Updating local repository with remote changes.");
        }
        String localBranchName = this.util.getCurrentBranchName();
        String remoteBranchName = this.util.getRemoteBranchName(localBranchName);
        String remoteName = this.util.getRemoteName(localBranchName);
        String connectionUrl = this.util.getConnectionUrlOfRemote(remoteName);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Git - Fetching remote updates.");
            StringBuilder message = new StringBuilder(LOG_PREFIX).append("Fetch info:\n");
            message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
            message.append("\t- REMOTE: ").append(remoteName).append('\n');
            message.append("\t- REMOTE_URL: ").append(connectionUrl);
            this.log.fine(message.toString());
        }
        try {
            FetchCommand fetch = this.git.fetch().setRemote(remoteName).setTagOpt(TagOpt.AUTO_FOLLOW).setRemoveDeletedRefs(true);
            this.setAuthenticationDetails((TransportCommand<?, ?>)fetch);
            fetch.call();
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.UPDATE, "Could not fetch changes from Git remote '" + remoteName + " [" + connectionUrl + "]'.", (Throwable)e);
        }
        MergeCommand merge = this.git.merge().setFastForward(MergeCommand.FastForwardMode.FF).setCommit(true).setMessage("Merge");
        switch (request.getMergeStrategy()) {
            case USE_LOCAL: {
                merge.setStrategy(MergeStrategy.OURS);
                break;
            }
            case USE_REMOTE: {
                merge.setStrategy(MergeStrategy.THEIRS);
                break;
            }
            case FULL_MERGE: {
                merge.setStrategy((MergeStrategy)new UnleashGitFullMergeStrategy((MergeClient)request.getMergeClient().get()));
                break;
            }
            case DO_NOT_MERGE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown merge strategy! API and implementation versions are incompatible!");
            }
        }
        String requestedRevision = (String)request.getTargetRevision().or((Object)this.getLatestRemoteRevision());
        try {
            ObjectId revision = this.git.getRepository().resolve(requestedRevision);
            merge.include((AnyObjectId)revision);
        }
        catch (Exception e) {
            throw new ScmException(ScmOperation.MERGE, "No Git commit id found for String '" + requestedRevision + "'.", (Throwable)e);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Git - Merging remote updates into local working copy.");
            StringBuilder message = new StringBuilder(LOG_PREFIX).append("Merge info:\n");
            message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
            message.append("\t- REMOTE: ").append(remoteName).append('\n');
            message.append("\t- REMOTE_BRANCH: ").append(remoteBranchName).append('\n');
            message.append("\t- REMOTE_REVISION: ").append(requestedRevision).append('\n');
            message.append("\t- LOCAL_BRANCH: ").append(localBranchName).append('\n');
            message.append("\t- LOCAL_REVISION: ").append(this.getLocalRevision()).append('\n');
            message.append("\t- MERGE_STRATEGY: ").append(request.getMergeStrategy());
            this.log.fine(message.toString());
        }
        try {
            merge.call();
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.MERGE, "Could not merge changes fetched from Git remote '" + remoteName + " [" + connectionUrl + "]' into local working copy '" + this.workingDir.getAbsolutePath() + "'.", (Throwable)e);
        }
        String newRevision = this.getLocalRevision();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Update finished successfully. New revision is: " + newRevision);
        }
        return newRevision;
    }

    public String tag(TagRequest request) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Tagging local repository with '" + request.getTagName() + "'");
        }
        if (this.log.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder(LOG_PREFIX).append("Tag info:\n");
            message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
            message.append("\t- TAG_NAME: ").append(request.getTagName()).append('\n');
            message.append("\t- USE_WORKING_COPY: ").append(request.tagFromWorkingCopy()).append('\n');
            if (request.tagFromWorkingCopy()) {
                message.append("\t- COMMIT_BEFORE_TAGGING: ").append(request.commitBeforeTagging()).append('\n');
                message.append("\t- MERGE_STRATEGY: ").append(request.getMergeStrategy());
            } else {
                message.append("\t- REMOTE_URL: ").append(request.getRemoteRepositoryUrl()).append('\n');
                message.append("\t- REVISION: ").append(request.getRevision());
            }
            this.log.fine(message.toString());
        }
        if (request.tagFromWorkingCopy()) {
            String newRevision;
            String preTagCommitMessage = (String)request.getPreTagCommitMessage().or((Object)("Preparation for tag creation (Tag name: '" + request.getTagName() + "')."));
            CommitRequest.Builder builder = CommitRequest.builder().message(preTagCommitMessage);
            if (request.includeUntrackedFiles()) {
                builder.includeUntrackedFiles();
            }
            this.commit(builder.build());
            try {
                TagCommand tag = this.git.tag().setName(request.getTagName()).setMessage(request.getMessage()).setAnnotated(true).setTagger(this.personIdent);
                tag.call();
            }
            catch (GitAPIException e) {
                throw new ScmException(ScmOperation.TAG, "An error occurred during local Git tag creation.", (Throwable)e);
            }
            if (!request.commitBeforeTagging()) {
                try {
                    this.git.reset().setMode(ResetCommand.ResetType.MIXED).setRef("HEAD~1").call();
                }
                catch (GitAPIException e) {
                    throw new ScmException(ScmOperation.TAG, "An error occurred during local commit resetting (no pre-tag commit was requested).", (Throwable)e);
                }
            }
            String tagPushName = "refs/tags/" + request.getTagName();
            if (request.push()) {
                if (request.commitBeforeTagging()) {
                    PushRequest pr = PushRequest.builder().mergeStrategy(request.getMergeStrategy()).mergeClient((MergeClient)request.getMergeClient().orNull()).build();
                    newRevision = this.push(pr);
                } else {
                    String localBranchName = this.util.getCurrentBranchName();
                    String remoteName = this.util.getRemoteName(localBranchName);
                    String connectionUrl = this.util.getConnectionUrlOfRemote(remoteName);
                    try {
                        PushCommand push = this.git.push().setRemote(remoteName).add(tagPushName);
                        this.setAuthenticationDetails((TransportCommand<?, ?>)push);
                        push.call();
                        newRevision = this.getLatestRemoteRevision();
                    }
                    catch (GitAPIException e) {
                        throw new ScmException(ScmOperation.PUSH, "Unable to push locally created tag '" + request.getTagName() + "' to remote '" + remoteName + "[" + connectionUrl + "]+'.", (Throwable)e);
                    }
                }
            } else {
                newRevision = this.getLocalRevision();
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Git - Tag creation finished successfully. New revision is: " + newRevision);
            }
            return newRevision;
        }
        throw new UnsupportedOperationException("This SCM provider doesn't support tagging from remote URLs only. This feature needs some workarounds and is scheduled for a later version.");
    }

    public boolean hasTag(String tagName) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Searching for Git tag '" + tagName + "'");
        }
        String localBranchName = this.util.getCurrentBranchName();
        String remoteName = this.util.getRemoteName(localBranchName);
        String remoteUrl = this.util.getConnectionUrlOfRemote(remoteName);
        if (this.log.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder(LOG_PREFIX).append("Query info:\n");
            message.append("\t- TAG_NAME: ").append(tagName).append('\n');
            message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
            message.append("\t- REMOTE: ").append(remoteName).append('\n');
            message.append("\t- REMOTE_URL: ").append(remoteUrl);
            this.log.fine(message.toString());
        }
        try {
            LsRemoteCommand lsRemote = this.git.lsRemote().setRemote(remoteName).setTags(true);
            this.setAuthenticationDetails((TransportCommand<?, ?>)lsRemote);
            String tagRefName = "refs/tags/" + tagName;
            for (Ref tag : lsRemote.call()) {
                if (!Objects.equal((Object)tag.getName(), (Object)tagRefName)) continue;
                return true;
            }
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.INFO, "An error occurred while querying the remote git repository for tag '" + tagName + "'.", (Throwable)e);
        }
        return false;
    }

    public String deleteTag(DeleteTagRequest request) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Deleting Git tag");
        }
        String localBranchName = this.util.getCurrentBranchName();
        String remoteName = this.util.getRemoteName(localBranchName);
        String remoteUrl = this.util.getConnectionUrlOfRemote(remoteName);
        boolean hasRemoteTag = this.hasTag(request.getTagName());
        if (!this.util.hasLocalTag(request.getTagName()) && hasRemoteTag) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Git - Fetching remote tag");
            }
            try {
                FetchCommand fetch = this.git.fetch().setRemote(remoteName).setTagOpt(TagOpt.FETCH_TAGS);
                this.setAuthenticationDetails((TransportCommand<?, ?>)fetch);
                fetch.call();
            }
            catch (GitAPIException e) {
                throw new ScmException(ScmOperation.DELETE_TAG, "Unable to fetch tags for deletion of tag '" + request.getTagName() + "' from remote '" + remoteName + "[" + remoteUrl + "]'.", (Throwable)e);
            }
        }
        if (this.util.hasLocalTag(request.getTagName())) {
            if (this.log.isLoggable(Level.FINE)) {
                StringBuilder message = new StringBuilder(LOG_PREFIX).append("Tag info:\n");
                message.append("\t- TAG_NAME: ").append(request.getTagName()).append('\n');
                message.append("\t- REMOTE: ").append(remoteName).append('\n');
                message.append("\t- REMOTE_URL: ").append(remoteUrl);
                this.log.fine(message.toString());
            }
            try {
                DeleteTagCommand deleteTag = this.git.tagDelete().setTags(new String[]{"refs/tags/" + request.getTagName()});
                deleteTag.call();
            }
            catch (GitAPIException e) {
                throw new ScmException(ScmOperation.DELETE_TAG, "An error occurred during the local deletion of tag '" + request.getTagName() + "'.", (Throwable)e);
            }
            try {
                if (hasRemoteTag) {
                    String tagPushName = ":refs/tags/" + request.getTagName();
                    if (request.push()) {
                        PushCommand push = this.git.push().setRemote(remoteName).add(tagPushName);
                        this.setAuthenticationDetails((TransportCommand<?, ?>)push);
                        push.call();
                    } else {
                        this.additionalThingsToPush.add(tagPushName);
                    }
                }
            }
            catch (GitAPIException e) {
                throw new ScmException(ScmOperation.DELETE_TAG, "An error occurred during the deletion of tag '" + request.getTagName() + "' from remote '" + remoteName + "[" + remoteUrl + "]'.", (Throwable)e);
            }
        }
        return this.getLatestRemoteRevision();
    }

    public String branch(BranchRequest request) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Branching local repository.");
        }
        if (this.log.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder(LOG_PREFIX).append("Branch info:\n");
            message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
            message.append("\t- BRANCH_NAME: ").append(request.getBranchName()).append('\n');
            message.append("\t- USE_WORKING_COPY: ").append(request.branchFromWorkingCopy()).append('\n');
            if (request.branchFromWorkingCopy()) {
                message.append("\t- COMMIT_BEFORE_BRANCHING: ").append(request.commitBeforeBranching()).append('\n');
                message.append("\t- MERGE_STRATEGY: ").append(request.getMergeStrategy());
            } else {
                message.append("\t- REMOTE_URL: ").append(request.getRemoteRepositoryUrl()).append('\n');
                message.append("\t- REVISION: ").append(request.getRevision());
            }
            this.log.fine(message.toString());
        }
        if (request.branchFromWorkingCopy()) {
            String newRevision;
            if (this.util.hasLocalBranch(request.getBranchName())) {
                throw new ScmException(ScmOperation.BRANCH, "A local branch with this name already exists!");
            }
            if (this.hasBranch(request.getBranchName())) {
                throw new ScmException(ScmOperation.BRANCH, "A remote branch with this name already exists!");
            }
            if (!request.getRevision().isPresent()) {
                String preBranchCommitMessage = request.getPreBranchCommitMessage() != null ? request.getPreBranchCommitMessage() : request.getMessage();
                CommitRequest cr = CommitRequest.builder().message(preBranchCommitMessage).noMerge().build();
                this.commit(cr);
            }
            try {
                CreateBranchCommand branch = this.git.branchCreate().setName(request.getBranchName()).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint((String)request.getRevision().or((Object)"HEAD"));
                branch.call();
            }
            catch (GitAPIException e) {
                throw new ScmException(ScmOperation.BRANCH, "Could not create local branch '" + request.getBranchName() + "' in working copy '" + this.workingDir.getAbsolutePath() + "'", (Throwable)e);
            }
            if (!request.commitBeforeBranching()) {
                try {
                    this.git.reset().setMode(ResetCommand.ResetType.MIXED).setRef("HEAD~1").call();
                }
                catch (GitAPIException e) {
                    throw new ScmException(ScmOperation.BRANCH, "An error occurred during local commit resetting (no pre-branch commit was requested).", (Throwable)e);
                }
            }
            String branchPushName = "refs/heads/" + request.getBranchName();
            if (request.push()) {
                if (request.commitBeforeBranching()) {
                    PushRequest pr = PushRequest.builder().mergeStrategy(request.getMergeStrategy()).mergeClient((MergeClient)request.getMergeClient().orNull()).build();
                    newRevision = this.push(pr);
                } else {
                    String localBranchName = this.util.getCurrentBranchName();
                    String remoteName = this.util.getRemoteName(localBranchName);
                    String connectionUrl = this.util.getConnectionUrlOfRemote(remoteName);
                    try {
                        PushCommand push = this.git.push().setRemote(remoteName).add(branchPushName);
                        this.setAuthenticationDetails((TransportCommand<?, ?>)push);
                        push.call();
                        newRevision = this.getLatestRemoteRevision();
                    }
                    catch (GitAPIException e) {
                        throw new ScmException(ScmOperation.PUSH, "Unable to push locally created branch '" + request.getBranchName() + "' to remote '" + remoteName + "[" + connectionUrl + "]+'.", (Throwable)e);
                    }
                }
            } else {
                newRevision = this.getLocalRevision();
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Git - Branch creation finished successfully. New revision is: " + newRevision);
            }
            return newRevision;
        }
        throw new UnsupportedOperationException("This SCM provider doesn't support tagging from remote URLs only. This feature needs some workarounds and is scheduled for a later version.");
    }

    public boolean hasBranch(String branchName) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Searching for Git branch");
        }
        String localBranchName = this.util.getCurrentBranchName();
        String remoteName = this.util.getRemoteName(localBranchName);
        String remoteUrl = this.util.getConnectionUrlOfRemote(remoteName);
        if (this.log.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder(LOG_PREFIX).append("Query info:\n");
            message.append("\t- BRANCH_NAME: ").append(branchName).append('\n');
            message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
            message.append("\t- REMOTE: ").append(remoteName).append('\n');
            message.append("\t- REMOTE_URL: ").append(remoteUrl);
            this.log.fine(message.toString());
        }
        try {
            LsRemoteCommand lsRemote = this.git.lsRemote().setRemote(remoteName).setHeads(true);
            this.setAuthenticationDetails((TransportCommand<?, ?>)lsRemote);
            Collection branches = lsRemote.call();
            for (Ref branch : branches) {
                if (!Objects.equal((Object)branch.getName(), (Object)("refs/heads/" + branchName))) continue;
                return true;
            }
        }
        catch (GitAPIException e) {
            throw new ScmException(ScmOperation.INFO, "An error occurred while querying the remote git repository for branch '" + branchName + "'.", (Throwable)e);
        }
        return false;
    }

    public String deleteBranch(DeleteBranchRequest request) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Deleting Git branch");
        }
        String localBranchName = this.util.getCurrentBranchName();
        String remoteName = this.util.getRemoteName(localBranchName);
        String remoteUrl = this.util.getConnectionUrlOfRemote(remoteName);
        if (this.log.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder(LOG_PREFIX).append("Branch info:\n");
            message.append("\t- TAG_NAME: ").append(request.getBranchName()).append('\n');
            message.append("\t- REMOTE: ").append(remoteName).append('\n');
            message.append("\t- REMOTE_URL: ").append(remoteUrl);
            this.log.fine(message.toString());
        }
        if (this.util.hasLocalBranch(request.getBranchName())) {
            try {
                this.git.branchDelete().setBranchNames(new String[]{"refs/heads/" + request.getBranchName()}).setForce(true).call();
            }
            catch (GitAPIException e) {
                e.printStackTrace();
            }
        }
        if (this.hasBranch(request.getBranchName())) {
            if (request.push()) {
                try {
                    PushCommand push = this.git.push().setRemote(remoteName).add(":refs/heads/" + request.getBranchName());
                    this.setAuthenticationDetails((TransportCommand<?, ?>)push);
                    push.call();
                }
                catch (GitAPIException e) {
                    e.printStackTrace();
                }
            } else {
                this.additionalThingsToPush.add(":refs/heads/" + request.getBranchName());
            }
        }
        return this.getLatestRemoteRevision();
    }

    public String revertCommits(RevertCommitsRequest request) throws ScmException {
        String newRevision;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Reverting Git commits");
        }
        if (this.log.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder(LOG_PREFIX).append("Commit info:\n");
            message.append("\t- FROM: ").append(request.getFromRevision()).append('\n');
            message.append("\t- TO: ").append(request.getToRevision()).append('\n');
            message.append("\t- MERGE_STRATEGY: ").append(request.getMergeStrategy()).append('\n');
            this.log.fine(message.toString());
        }
        UpdateRequest updateRequest = UpdateRequest.builder().mergeStrategy(request.getMergeStrategy()).mergeClient((MergeClient)request.getMergeClient().orNull()).build();
        this.update(updateRequest);
        RevCommit from = this.util.resolveCommit((Optional<String>)Optional.of((Object)request.getFromRevision()), (Optional<String>)Optional.absent());
        RevCommit to = this.util.resolveCommit((Optional<String>)Optional.of((Object)request.getToRevision()), (Optional<String>)Optional.absent());
        int diff = from.getCommitTime() - to.getCommitTime();
        if (diff == 0) {
            return this.getLatestRemoteRevision();
        }
        if (diff < 0) {
            throw new ScmException(ScmOperation.REVERT_COMMITS, "Error reverting commits in remote repository. \"FROM\" revision (" + request.getFromRevision() + ") is older than \"TO\" revision (" + request.getToRevision() + ")");
        }
        try {
            RevertCommand revert = this.git.revert();
            List<RevCommit> commitsToRevert = this.util.resolveCommitRange(request.getToRevision(), request.getFromRevision());
            for (RevCommit commit : commitsToRevert) {
                revert.include((AnyObjectId)commit);
            }
            switch (request.getMergeStrategy()) {
                case USE_LOCAL: {
                    revert.setStrategy(MergeStrategy.OURS);
                    break;
                }
                case USE_REMOTE: {
                    revert.setStrategy(MergeStrategy.THEIRS);
                    break;
                }
                case FULL_MERGE: {
                    revert.setStrategy((MergeStrategy)new UnleashGitFullMergeStrategy((MergeClient)request.getMergeClient().get()));
                    break;
                }
                case DO_NOT_MERGE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown merge strategy! API and implementation versions are incompatible!");
                }
            }
            revert.call();
        }
        catch (Exception e) {
            throw new ScmException(ScmOperation.REVERT_COMMITS, "An error occurred during the reversion of commits.", (Throwable)e);
        }
        if (request.push()) {
            PushRequest pr = PushRequest.builder().mergeStrategy(request.getMergeStrategy()).mergeClient((MergeClient)request.getMergeClient().orNull()).build();
            newRevision = this.push(pr);
        } else {
            newRevision = this.getLocalRevision();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Git - Revert finished successfully. New revision is: " + newRevision);
        }
        return newRevision;
    }

    public String getLocalRevision() {
        try {
            RevCommit revCommit = (RevCommit)this.git.log().call().iterator().next();
            return revCommit.getName();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException("Could not determine the last revision commit of the local repository.", e);
        }
    }

    public String getLatestRemoteRevision() {
        try {
            String localBranchName = this.util.getCurrentBranchName();
            String remoteName = this.util.getRemoteName(localBranchName);
            String remoteNameBranch = this.util.getRemoteBranchName(localBranchName);
            LsRemoteCommand lsRemote = this.git.lsRemote().setHeads(true).setRemote(remoteName);
            this.setAuthenticationDetails((TransportCommand<?, ?>)lsRemote);
            Collection branches = lsRemote.call();
            for (Ref branch : branches) {
                if (!Objects.equal((Object)branch.getTarget().getName(), (Object)remoteNameBranch)) continue;
                return branch.getObjectId().getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String calculateTagConnectionString(String currentConnectionString, String tagName) {
        return currentConnectionString;
    }

    public String calculateBranchConnectionString(String currentConnectionString, String branchName) {
        return currentConnectionString;
    }

    public boolean isTagInfoIncludedInConnection() {
        return false;
    }

    public HistoryResult getHistory(HistoryRequest request) throws ScmException {
        HistoryResult.Builder historyBuilder = HistoryResult.builder();
        if (request.getRemoteRepositoryUrl().isPresent()) {
            throw new ScmException(ScmOperation.INFO, "Remote history retrieval is not supported by Git!");
        }
        try {
            LogCommand logCommand = this.git.log();
            if (request.getMessageFilters().isEmpty()) {
                logCommand.setMaxCount((int)request.getMaxResults());
            }
            AnyObjectId startId = this.getTagRevisionOrDefault((Optional<String>)request.getStartTag(), (String)request.getStartRevision().orNull());
            AnyObjectId endId = this.getTagRevisionOrDefault((Optional<String>)request.getEndTag(), (String)request.getEndRevision().or((Object)this.git.getRepository().resolve("HEAD").name()));
            if (startId != null && endId != null) {
                logCommand.addRange(startId, endId);
            } else if (startId != null) {
                logCommand.add(startId);
            } else if (endId != null) {
                logCommand.add(endId);
            }
            Set messageFilterPatterns = request.getMessageFilters();
            int commitsAdded = 0;
            for (RevCommit revCommit : logCommand.call()) {
                if ((long)commitsAdded != request.getMaxResults()) {
                    if (this.isFilteredMessage(revCommit.getShortMessage(), messageFilterPatterns)) continue;
                    HistoryCommit.Builder b = HistoryCommit.builder();
                    b.setRevision(revCommit.getId().name());
                    b.setMessage(revCommit.getShortMessage());
                    PersonIdent authorIdent = revCommit.getAuthorIdent();
                    b.setAuthor(authorIdent.getName());
                    b.setDate(authorIdent.getWhen());
                    historyBuilder.addCommit(b.build());
                    ++commitsAdded;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new ScmException(ScmOperation.INFO, "Unable to retrieve the Git log history.", (Throwable)e);
        }
        return historyBuilder.build();
    }

    private boolean isFilteredMessage(String message, Set<String> messageFilterPatterns) {
        for (String filter : messageFilterPatterns) {
            if (!message.matches(filter)) continue;
            return true;
        }
        return false;
    }

    private AnyObjectId getTagRevisionOrDefault(Optional<String> tag, String defaultRevision) {
        if (tag.isPresent()) {
            try {
                String tagName = "refs/tags/" + (String)tag.get();
                for (Ref ref : this.git.tagList().call()) {
                    if (!Objects.equal((Object)tagName, (Object)ref.getName())) continue;
                    Ref peeledRef = this.git.getRepository().peel(ref);
                    return (AnyObjectId)MoreObjects.firstNonNull((Object)peeledRef.getPeeledObjectId(), (Object)peeledRef.getObjectId());
                }
                throw new ScmException(ScmOperation.INFO, "Could not find a tag with name " + (String)tag.get());
            }
            catch (Exception e) {
                throw new ScmException(ScmOperation.INFO, "Unable to get the revision of the following tag: " + (String)tag.get(), (Throwable)e);
            }
        }
        return defaultRevision != null ? ObjectId.fromString((String)defaultRevision) : null;
    }

    public DiffResult getDiff(DiffRequest request) throws ScmException {
        if (request.getSourceRemoteRepositoryUrl().isPresent() || request.getTargetRemoteRepositoryUrl().isPresent()) {
            throw new ScmException(ScmOperation.DIFF, "Diff creation has been requested from remote repositories. This feature is currently not supported by the Git SCM provider.");
        }
        String sourceRevision = (String)request.getSourceRevision().or((Object)"HEAD");
        ObjectId sourceId = null;
        try {
            sourceId = this.git.getRepository().resolve(sourceRevision);
        }
        catch (Exception e) {
            throw new ScmException(ScmOperation.DIFF, "Unable to resolve source object id using the current repository: " + sourceRevision, (Throwable)e);
        }
        String targetRevision = (String)request.getTargetRevision().or((Object)"HEAD");
        ObjectId targetId = null;
        try {
            targetId = this.git.getRepository().resolve(targetRevision);
        }
        catch (Exception e) {
            throw new ScmException(ScmOperation.DIFF, "Unable to resolve target object id using the current repository: " + sourceRevision, (Throwable)e);
        }
        DiffResult.Builder resultBuilder = DiffResult.builder();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DiffFormatter df = new DiffFormatter((OutputStream)os);
        df.setRepository(this.git.getRepository());
        try {
            List entries = df.scan((AnyObjectId)sourceId, (AnyObjectId)targetId);
            for (DiffEntry entry : entries) {
                String textualDiff;
                DiffObject.Builder b = DiffObject.builder();
                switch (entry.getChangeType()) {
                    case ADD: {
                        b.addition(entry.getNewPath());
                        break;
                    }
                    case DELETE: {
                        b.deletion(entry.getOldPath());
                        break;
                    }
                    case MODIFY: {
                        b.changed(entry.getOldPath());
                        if (request.getType() != DiffRequest.DiffType.CHANGES_ONLY) break;
                        df.format(entry);
                        df.flush();
                        textualDiff = new String(os.toByteArray());
                        b.addTextualDiff(textualDiff);
                        os.reset();
                        break;
                    }
                    case RENAME: {
                        b.moved(entry.getOldPath(), entry.getNewPath());
                        break;
                    }
                    case COPY: {
                        b.copied(entry.getOldPath(), entry.getNewPath());
                    }
                }
                if (request.getType() == DiffRequest.DiffType.FULL) {
                    df.format(entry);
                    df.flush();
                    textualDiff = new String(os.toByteArray());
                    b.addTextualDiff(textualDiff);
                    os.reset();
                }
                resultBuilder.addDiff(b.build());
            }
        }
        catch (Exception e) {
            throw new ScmException(ScmOperation.DIFF, "Unable to calculate diff.", (Throwable)e);
        }
        finally {
            df.close();
            try {
                Closeables.close((Closeable)os, (boolean)true);
            }
            catch (IOException iOException) {}
        }
        return resultBuilder.build();
    }

    private void setAuthenticationDetails(TransportCommand<?, ?> command) {
        command.setCredentialsProvider(this.credentialsProvider);
        command.setTransportConfigCallback(new TransportConfigCallback(){

            public void configure(Transport transport) {
                if (this.isSshTransport(transport)) {
                    SshTransport sshTransport = (SshTransport)transport;
                    sshTransport.setSshSessionFactory(ScmProviderGit.this.sshSessionFactory);
                }
            }

            private boolean isSshTransport(Transport transport) {
                return transport instanceof SshTransport;
            }
        });
    }
}

