/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.requests;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.itemis.maven.plugins.unleash.scm.merge.MergeClient;
import com.itemis.maven.plugins.unleash.scm.merge.MergeStrategy;

public class RevertCommitsRequest {
    private String fromRevision;
    private String toRevision;
    private String message;
    private boolean push;
    private MergeStrategy mergeStrategy = MergeStrategy.DO_NOT_MERGE;
    private MergeClient mergeClient;

    private RevertCommitsRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getFromRevision() {
        return this.fromRevision;
    }

    public String getToRevision() {
        return this.toRevision;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean push() {
        return this.push;
    }

    public MergeStrategy getMergeStrategy() {
        return this.mergeStrategy;
    }

    public Optional<MergeClient> getMergeClient() {
        return Optional.fromNullable((Object)this.mergeClient);
    }

    public static class Builder {
        private RevertCommitsRequest request = new RevertCommitsRequest();

        public Builder toRevision(String revision) {
            this.request.toRevision = revision;
            return this;
        }

        public Builder fromRevision(String revision) {
            this.request.fromRevision = revision;
            return this;
        }

        public Builder message(String message) {
            this.request.message = message;
            return this;
        }

        public Builder push() {
            this.request.push = true;
            return this;
        }

        public Builder mergeUseLocal() {
            this.request.mergeStrategy = MergeStrategy.USE_LOCAL;
            return this;
        }

        public Builder mergeUseRemote() {
            this.request.mergeStrategy = MergeStrategy.USE_REMOTE;
            return this;
        }

        public Builder merge() {
            this.request.mergeStrategy = MergeStrategy.FULL_MERGE;
            return this;
        }

        public Builder noMerge() {
            this.request.mergeStrategy = MergeStrategy.DO_NOT_MERGE;
            return this;
        }

        public Builder mergeStrategy(MergeStrategy mergeStrategy) {
            if (mergeStrategy != null) {
                this.request.mergeStrategy = mergeStrategy;
            } else {
                this.noMerge();
            }
            return this;
        }

        public Builder mergeClient(MergeClient mergeClient) {
            this.request.mergeClient = mergeClient;
            return this;
        }

        public RevertCommitsRequest build() {
            Preconditions.checkState((this.request.fromRevision != null ? 1 : 0) != 0, (Object)"No from revision set (start revision of the reversion)!");
            Preconditions.checkState((this.request.toRevision != null ? 1 : 0) != 0, (Object)"No to revision set (end revision of the reversion that will be kept)!");
            Preconditions.checkState((this.request.message != null ? 1 : 0) != 0, (Object)"No log message specified!");
            if (MergeStrategy.FULL_MERGE == this.request.mergeStrategy) {
                Preconditions.checkState((this.request.mergeClient != null ? 1 : 0) != 0, (Object)("Merge strategy " + (Object)((Object)this.request.mergeStrategy) + " has been requested but no merge client is set!"));
            }
            return this.request;
        }
    }
}

