/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.requests;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class HistoryRequest {
    private String remoteRepositoryUrl;
    private String startRevision;
    private String endRevision;
    private long maxResults = -1L;
    private String startTag;
    private String endTag;
    private Set<String> messageFilters = Sets.newHashSet();

    private HistoryRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getRemoteRepositoryUrl() {
        return Optional.fromNullable((Object)this.remoteRepositoryUrl);
    }

    public Optional<String> getStartRevision() {
        return Optional.fromNullable((Object)this.startRevision);
    }

    public Optional<String> getEndRevision() {
        return Optional.fromNullable((Object)this.endRevision);
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public Optional<String> getStartTag() {
        return Optional.fromNullable((Object)this.startTag);
    }

    public Optional<String> getEndTag() {
        return Optional.fromNullable((Object)this.endTag);
    }

    public Set<String> getMessageFilters() {
        return Collections.unmodifiableSet(this.messageFilters);
    }

    public static class Builder {
        private HistoryRequest request = new HistoryRequest();

        public Builder fromRemote(String remoteRepositoryUrl) {
            this.request.remoteRepositoryUrl = remoteRepositoryUrl;
            return this;
        }

        public Builder startRevision(String startRevision) {
            this.request.startRevision = startRevision;
            this.request.startTag = null;
            return this;
        }

        public Builder endRevision(String endRevision) {
            this.request.endRevision = endRevision;
            this.request.endTag = null;
            return this;
        }

        public Builder startTag(String startTag) {
            this.request.startTag = startTag;
            this.request.startRevision = null;
            return this;
        }

        public Builder endTag(String endTag) {
            this.request.endTag = endTag;
            this.request.endRevision = null;
            return this;
        }

        public Builder maxResults(long maxResults) {
            this.request.maxResults = maxResults;
            return this;
        }

        public Builder addMessageFilter(String filterExpression) {
            if (StringUtils.isNotEmpty((CharSequence)filterExpression)) {
                this.request.messageFilters.add(filterExpression);
            }
            return this;
        }

        public HistoryRequest build() {
            return this.request;
        }
    }
}

