/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.requests;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;

public class CheckoutRequest {
    private String remoteRepositoryUrl;
    private String revision;
    private String branch;
    private String tag;
    private Set<String> pathsToCheckout = Sets.newHashSet();

    private CheckoutRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRemoteRepositoryUrl() {
        return this.remoteRepositoryUrl;
    }

    public Optional<String> getRevision() {
        return Optional.fromNullable((Object)this.revision);
    }

    public Optional<String> getBranch() {
        return Optional.fromNullable((Object)this.branch);
    }

    public Optional<String> getTag() {
        return Optional.fromNullable((Object)this.tag);
    }

    public Set<String> getPathsToCheckout() {
        return this.pathsToCheckout;
    }

    public boolean checkoutWholeRepository() {
        return this.pathsToCheckout.isEmpty();
    }

    public boolean checkoutBranch() {
        return this.branch != null;
    }

    public boolean checkoutTag() {
        return this.tag != null;
    }

    public static class Builder {
        private CheckoutRequest request = new CheckoutRequest();

        public Builder from(String remoteRepositoryUrl) {
            this.request.remoteRepositoryUrl = remoteRepositoryUrl;
            return this;
        }

        public Builder revision(String revision) {
            this.request.revision = revision;
            return this;
        }

        public Builder branch(String branchName) {
            this.request.branch = branchName;
            this.request.tag = null;
            return this;
        }

        public Builder tag(String tagName) {
            this.request.tag = tagName;
            this.request.branch = null;
            return this;
        }

        public Builder addPaths(String ... paths) {
            for (String path : paths) {
                this.request.pathsToCheckout.add(path);
            }
            return this;
        }

        public Builder paths(Set<String> paths) {
            if (paths != null) {
                this.request.pathsToCheckout = paths;
            } else {
                this.request.pathsToCheckout = Sets.newHashSet();
            }
            return this;
        }

        public CheckoutRequest build() {
            Preconditions.checkState((this.request.getRemoteRepositoryUrl() != null ? 1 : 0) != 0, (Object)"No remote repository URL specified!");
            return this.request;
        }
    }
}

