/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.cdi.logging;

import com.google.common.base.Preconditions;
import com.itemis.maven.plugins.cdi.logging.Logger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.enterprise.inject.Typed;
import org.apache.maven.plugin.logging.Log;

@Typed(value={Logger.class, Log.class})
public class MavenLogWrapper
implements Logger {
    private static final DateFormat FORMAT_TIMESTAMP = new SimpleDateFormat("HH:mm:ss,SSS ");
    private Log log;
    private String context;
    private boolean timestampsEnabled;

    public MavenLogWrapper(Log log) {
        this.log = log;
    }

    @Override
    public void setContextClass(Class<?> contextClass) {
        Preconditions.checkNotNull(contextClass, (Object)"The context class for the logger must not be null!");
        this.context = contextClass.getSimpleName();
    }

    @Override
    public void unsetContext() {
        this.context = null;
    }

    public boolean hasContext() {
        return this.context != null;
    }

    @Override
    public void enableLogTimestamps() {
        this.timestampsEnabled = true;
    }

    @Override
    public void disableLogTimestamps() {
        this.timestampsEnabled = false;
    }

    @Override
    public boolean isTimestampedLoggingEnabled() {
        return this.timestampsEnabled;
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(CharSequence content) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.wrapContent(content));
        }
    }

    public void debug(CharSequence content, Throwable error) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.wrapContent(content), error);
        }
    }

    public void debug(Throwable error) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(error);
        }
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public void info(CharSequence content) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.wrapContent(content));
        }
    }

    public void info(CharSequence content, Throwable error) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.wrapContent(content), error);
        }
    }

    public void info(Throwable error) {
        if (this.log.isInfoEnabled()) {
            this.log.info(error);
        }
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void warn(CharSequence content) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(this.wrapContent(content));
        }
    }

    public void warn(CharSequence content, Throwable error) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(this.wrapContent(content), error);
        }
    }

    public void warn(Throwable error) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(error);
        }
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public void error(CharSequence content) {
        if (this.log.isErrorEnabled()) {
            this.log.error(this.wrapContent(content));
        }
    }

    public void error(CharSequence content, Throwable error) {
        if (this.log.isErrorEnabled()) {
            this.log.error(this.wrapContent(content), error);
        }
    }

    public void error(Throwable error) {
        if (this.log.isErrorEnabled()) {
            this.log.error(error);
        }
    }

    private CharSequence wrapContent(CharSequence content) {
        StringBuilder sb = new StringBuilder(content);
        this.wrapContentWithContext(sb);
        this.wrapContentWithTimestamp(sb);
        return sb;
    }

    private void wrapContentWithContext(StringBuilder content) {
        if (this.context != null) {
            content.insert(0, "[" + this.context + "] ");
        }
    }

    private void wrapContentWithTimestamp(StringBuilder content) {
        if (this.timestampsEnabled) {
            String date = FORMAT_TIMESTAMP.format(new Date());
            content.insert(0, date + " ");
        }
    }
}

