/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.cdi.internal.util.workflow;

import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class WorkflowValidator {
    public static void validateSyntactically(InputStream is) {
        BufferedReader br = null;
        try {
            String line;
            boolean isTryBlockOpen = false;
            boolean isFinallyBlockOpen = true;
            boolean isParallelBlockOpen = false;
            boolean isDataAssignmentBlockOpen = false;
            br = new BufferedReader(new InputStreamReader(is));
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.isEmpty() || !(isFinallyBlockOpen = WorkflowValidator.validateFinallyBlockOpening(line, isTryBlockOpen = WorkflowValidator.validateTryBlockOpening(line, ++lineNumber)))) continue;
                isTryBlockOpen = false;
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to read the workflow descriptor from the provided input stream.", e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(br);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Reader)br);
    }

    private static boolean validateTryBlockOpening(String line, int lineNumber) {
        if (line.contains("try")) {
            if (!line.startsWith("try")) {
                throw new RuntimeException("Opening the try-block requires the keyword 'try' to be the first token of the line. Processed line was: '" + line + "'");
            }
            if (lineNumber != 1) {
                throw new RuntimeException("The try-block opening must be the first statement. Only comments are allowed to occur before opening the try-block. Processed line was: '" + line + "'");
            }
            String remainingContent = line.substring("try".length()).trim();
            if (!remainingContent.equals("{")) {
                throw new RuntimeException("The try block opening must end with the block opening character '{'. Processed line was: '" + line + "'");
            }
            return true;
        }
        return false;
    }

    private static boolean validateFinallyBlockOpening(String line, boolean isTryBlockOpen) {
        if (line.startsWith("}")) {
            String remainingContent = line.substring(1).trim();
            if (line.startsWith("finally")) {
                remainingContent = line.substring("finally".length()).trim();
                if (!remainingContent.equals("{")) {
                    throw new RuntimeException("The finally block opening must end with the block opening character '{'. Processed line was: '" + line + "'");
                }
                return true;
            }
        }
        return false;
    }
}

