/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.cdi.internal.util.workflow;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.annotations.RollbackOnError;
import com.itemis.maven.plugins.cdi.internal.util.workflow.ParallelWorkflowStep;
import com.itemis.maven.plugins.cdi.internal.util.workflow.ProcessingWorkflow;
import com.itemis.maven.plugins.cdi.internal.util.workflow.SimpleWorkflowStep;
import com.itemis.maven.plugins.cdi.internal.util.workflow.WorkflowStep;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.logging.Log;

public class WorkflowExecutor {
    private Log log;
    private ProcessingWorkflow workflow;
    private Map<String, CDIMojoProcessingStep> processingSteps;
    private Stack<Pair<CDIMojoProcessingStep, ExecutionContext>> executedSteps;
    private PluginParameterExpressionEvaluator expressionEvaluator;

    public WorkflowExecutor(ProcessingWorkflow workflow, Map<String, CDIMojoProcessingStep> processingSteps, Log log, PluginParameterExpressionEvaluator expressionEvaluator) {
        this.workflow = workflow;
        this.processingSteps = processingSteps;
        this.log = log;
        this.expressionEvaluator = expressionEvaluator;
    }

    public void validate(boolean isOnlineExecution) throws MojoExecutionException {
        HashSet unknownIds = Sets.newHashSet();
        Iterable stepsToCheck = Iterables.unmodifiableIterable((Iterable)Iterables.concat(this.workflow.getProcessingSteps(), this.workflow.getFinallySteps()));
        for (WorkflowStep workflowStep : stepsToCheck) {
            if (workflowStep.isParallel()) {
                ParallelWorkflowStep parallelWorkflowStep = (ParallelWorkflowStep)workflowStep;
                for (SimpleWorkflowStep simpleWorkflowStep : parallelWorkflowStep.getSteps()) {
                    CDIMojoProcessingStep step = this.processingSteps.get(simpleWorkflowStep.getStepId());
                    if (step == null) {
                        unknownIds.add(simpleWorkflowStep.getStepId());
                        continue;
                    }
                    this.verifyOnlineStatus(step, isOnlineExecution);
                }
                continue;
            }
            SimpleWorkflowStep simpleWorkflowStep = (SimpleWorkflowStep)workflowStep;
            CDIMojoProcessingStep step = this.processingSteps.get(simpleWorkflowStep.getStepId());
            if (step == null) {
                unknownIds.add(simpleWorkflowStep.getStepId());
                continue;
            }
            this.verifyOnlineStatus(step, isOnlineExecution);
        }
        if (!unknownIds.isEmpty()) {
            throw new MojoExecutionException("There are no implementations for the following processing step ids specified in the workflow: " + Joiner.on((char)',').join((Iterable)unknownIds));
        }
    }

    private void verifyOnlineStatus(CDIMojoProcessingStep step, boolean isOnlineExecution) throws MojoExecutionException {
        ProcessingStep stepAnnotation = step.getClass().getAnnotation(ProcessingStep.class);
        if (stepAnnotation.requiresOnline() && !isOnlineExecution) {
            throw new MojoExecutionException("The execution of this Mojo requires Maven to operate in online mode but Maven has been started using the offline option.");
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Executing the standard workflow of the goal");
        this.executedSteps = new Stack();
        try {
            for (WorkflowStep workflowStep : this.workflow.getProcessingSteps()) {
                this.executeSequentialWorkflowStep(workflowStep);
                this.executeParallelWorkflowSteps(workflowStep);
            }
        }
        catch (MojoExecutionException e) {
            this.executeFinallySteps();
            throw e;
        }
        catch (MojoFailureException e) {
            this.executeFinallySteps();
            throw e;
        }
        catch (RuntimeException e) {
            this.executeFinallySteps();
            throw e;
        }
    }

    private void executeFinallySteps() throws MojoExecutionException, MojoFailureException {
        if (!this.workflow.getFinallySteps().isEmpty()) {
            this.log.info((CharSequence)"Executing the finally workflow of the goal");
            this.executedSteps.clear();
            for (SimpleWorkflowStep step : this.workflow.getFinallySteps()) {
                this.executeSequentialWorkflowStep(step);
            }
        }
    }

    private void executeSequentialWorkflowStep(WorkflowStep workflowStep) throws MojoExecutionException, MojoFailureException {
        if (workflowStep.isParallel()) {
            return;
        }
        SimpleWorkflowStep simpleWorkflowStep = (SimpleWorkflowStep)workflowStep;
        ExecutionContext executionContext = this.workflow.getExecutionContext(simpleWorkflowStep.getCompositeStepId());
        CDIMojoProcessingStep step = this.processingSteps.get(simpleWorkflowStep.getStepId());
        try {
            this.executedSteps.push((Pair<CDIMojoProcessingStep, ExecutionContext>)Pair.of((Object)step, (Object)executionContext));
            executionContext.expandProjectVariables(this.expressionEvaluator);
            step.execute(executionContext);
        }
        catch (Throwable t) {
            this.log.error((CharSequence)("An exception was caught while processing the workflow step with id '" + simpleWorkflowStep.getCompositeStepId() + "'."), t);
            this.rollback(t);
            if (t instanceof MojoExecutionException) {
                throw (MojoExecutionException)t;
            }
            if (t instanceof MojoFailureException) {
                throw (MojoFailureException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private void executeParallelWorkflowSteps(WorkflowStep workflowStep) throws MojoExecutionException, MojoFailureException {
        if (!workflowStep.isParallel()) {
            return;
        }
        LinkedList<Future> results = new LinkedList<Future>();
        final ArrayList thrownExceptions = Lists.newArrayList();
        ParallelWorkflowStep parallelWorkflowStep = (ParallelWorkflowStep)workflowStep;
        ExecutorService executorService = Executors.newFixedThreadPool(parallelWorkflowStep.getSteps().size());
        for (final SimpleWorkflowStep simpleWorkflowStep : parallelWorkflowStep.getSteps()) {
            results.offer(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    CDIMojoProcessingStep step = (CDIMojoProcessingStep)WorkflowExecutor.this.processingSteps.get(simpleWorkflowStep.getStepId());
                    try {
                        ExecutionContext executionContext = WorkflowExecutor.this.workflow.getExecutionContext(simpleWorkflowStep.getCompositeStepId());
                        WorkflowExecutor.this.executedSteps.push(Pair.of((Object)step, (Object)executionContext));
                        executionContext.expandProjectVariables(WorkflowExecutor.this.expressionEvaluator);
                        step.execute(executionContext);
                    }
                    catch (Throwable t) {
                        WorkflowExecutor.this.log.error((CharSequence)("An exception was caught while processing the workflow step with id '" + simpleWorkflowStep.getCompositeStepId() + "'."), t);
                        thrownExceptions.add(t);
                    }
                }
            }));
        }
        while (!results.isEmpty()) {
            Future result = (Future)results.poll();
            try {
                result.get();
            }
            catch (InterruptedException e) {
                results.offer(result);
            }
            catch (ExecutionException executionException) {}
        }
        Throwable firstError = (Throwable)Iterables.getFirst((Iterable)thrownExceptions, null);
        if (firstError != null) {
            this.rollback(firstError);
            if (firstError instanceof MojoExecutionException) {
                throw (MojoExecutionException)firstError;
            }
            if (firstError instanceof MojoFailureException) {
                throw (MojoFailureException)firstError;
            }
            if (firstError instanceof RuntimeException) {
                throw (RuntimeException)firstError;
            }
            throw new RuntimeException(firstError);
        }
    }

    private void rollback(Throwable t) {
        this.log.info((CharSequence)"Rolling back after execution errors - please find the error messages and stack traces above.");
        while (!this.executedSteps.empty()) {
            Pair<CDIMojoProcessingStep, ExecutionContext> pair = this.executedSteps.pop();
            this.rollback((CDIMojoProcessingStep)pair.getLeft(), (ExecutionContext)pair.getRight(), t);
        }
    }

    private void rollback(CDIMojoProcessingStep step, ExecutionContext executionContext, Throwable t) {
        List<Method> rollbackMethods = this.getRollbackMethods(step, t.getClass());
        Collections.sort(rollbackMethods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return m1.getName().compareTo(m2.getName());
            }
        });
        for (Method rollbackMethod : rollbackMethods) {
            rollbackMethod.setAccessible(true);
            try {
                Class<?>[] parameterTypes = rollbackMethod.getParameterTypes();
                switch (parameterTypes.length) {
                    case 0: {
                        rollbackMethod.invoke((Object)step, new Object[0]);
                        break;
                    }
                    case 1: {
                        if (ExecutionContext.class == parameterTypes[0]) {
                            rollbackMethod.invoke((Object)step, executionContext);
                            break;
                        }
                        rollbackMethod.invoke((Object)step, t);
                        break;
                    }
                    case 2: {
                        if (ExecutionContext.class == parameterTypes[0]) {
                            rollbackMethod.invoke((Object)step, executionContext, t);
                            break;
                        }
                        rollbackMethod.invoke((Object)step, t, executionContext);
                    }
                }
            }
            catch (ReflectiveOperationException e) {
                this.log.error((CharSequence)("An exception was caught while rolling back the workflow step with id '" + executionContext.getCompositeStepId() + "'. Proceeding with the rollback of the next steps."), (Throwable)e);
            }
        }
    }

    private <T extends Throwable> List<Method> getRollbackMethods(CDIMojoProcessingStep mojo, Class<T> causeType) {
        ArrayList rollbackMethods = Lists.newArrayList();
        block5: for (Method m : mojo.getClass().getDeclaredMethods()) {
            RollbackOnError rollbackAnnotation = m.getAnnotation(RollbackOnError.class);
            if (rollbackAnnotation == null) continue;
            boolean considerMethod = false;
            Class<? extends Throwable>[] errorTypes = rollbackAnnotation.value();
            if (errorTypes.length == 0) {
                considerMethod = true;
            } else {
                for (Class<? extends Throwable> errorType : errorTypes) {
                    if (!errorType.isAssignableFrom(causeType)) continue;
                    considerMethod = true;
                    break;
                }
            }
            if (!considerMethod) continue;
            Class<?>[] parameterTypes = m.getParameterTypes();
            switch (parameterTypes.length) {
                case 0: {
                    rollbackMethods.add(m);
                    continue block5;
                }
                case 1: {
                    if (parameterTypes[0].isAssignableFrom(causeType)) {
                        rollbackMethods.add(m);
                        continue block5;
                    }
                    if (parameterTypes[0] != ExecutionContext.class) continue block5;
                    rollbackMethods.add(m);
                    continue block5;
                }
                case 2: {
                    if (parameterTypes[0] == ExecutionContext.class && parameterTypes[1].isAssignableFrom(causeType)) {
                        rollbackMethods.add(m);
                        continue block5;
                    }
                    if (!parameterTypes[0].isAssignableFrom(causeType) || parameterTypes[1] != ExecutionContext.class) continue block5;
                    rollbackMethods.add(m);
                    continue block5;
                }
                default: {
                    this.log.warn((CharSequence)"Found rollback method with more than two parameters! Only zero, one or two parameters of type <T extends Throwable> and ExecutionContext are allowed!");
                }
            }
        }
        return rollbackMethods;
    }
}

