/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.cdi.internal.util.workflow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.itemis.maven.plugins.cdi.internal.util.workflow.SimpleWorkflowStep;
import com.itemis.maven.plugins.cdi.internal.util.workflow.WorkflowStep;
import java.util.Collections;
import java.util.Set;

public class ParallelWorkflowStep
implements WorkflowStep {
    private Set<SimpleWorkflowStep> steps = Sets.newHashSet();

    private ParallelWorkflowStep() {
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    public Set<SimpleWorkflowStep> getSteps() {
        return Collections.unmodifiableSet(this.steps);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        toStringHelper.add("#steps", this.steps.size());
        int i = 1;
        for (SimpleWorkflowStep step : this.steps) {
            toStringHelper.add("step " + i++, (Object)(step.getStepId() + (step.getQualifier().isPresent() ? "[" + (String)step.getQualifier().get() + "]" : "")));
        }
        return toStringHelper.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])this.steps.toArray());
    }

    public boolean equals(Object other) {
        if (other instanceof ParallelWorkflowStep) {
            ParallelWorkflowStep otherStep = (ParallelWorkflowStep)other;
            Sets.SetView intersection = Sets.intersection(this.steps, otherStep.steps);
            return intersection.size() == this.steps.size();
        }
        return false;
    }

    @Override
    public boolean containsId(String id) {
        for (SimpleWorkflowStep step : this.steps) {
            if (!step.containsId(id)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private ParallelWorkflowStep parallelStep = new ParallelWorkflowStep();

        private Builder() {
        }

        public Builder addSteps(SimpleWorkflowStep ... steps) {
            for (SimpleWorkflowStep step : steps) {
                this.parallelStep.steps.add(step);
            }
            return this;
        }

        public ParallelWorkflowStep build() {
            return this.parallelStep;
        }
    }
}

