/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.cdi.internal.util;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Qualifier;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;

public class CDIUtil {
    private static final String FILE_EXTENSION_CLASS = "class";

    public static Set<Annotation> getCdiQualifiers(AccessibleObject x) {
        HashSet qualifiers = Sets.newHashSet();
        for (Annotation annotation : x.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            qualifiers.add(annotation);
        }
        if (qualifiers.isEmpty()) {
            qualifiers.add(DefaultLiteral.INSTANCE);
        }
        return qualifiers;
    }

    public static <T> Collection<T> getAllBeansOfType(WeldContainer weldContainer, Class<T> type) {
        ArrayList beans = Lists.newArrayList();
        Set cdiBeans = weldContainer.getBeanManager().getBeans(type, new Annotation[]{AnyLiteral.INSTANCE});
        Iterator iterator = cdiBeans.iterator();
        while (iterator.hasNext()) {
            Bean b;
            Bean b2 = b = (Bean)iterator.next();
            CreationalContext creationalContext = weldContainer.getBeanManager().createCreationalContext((Contextual)b2);
            Object bean = b2.create(creationalContext);
            beans.add(bean);
        }
        return beans;
    }

    public static void addAllClasses(Weld weld, ClassLoader classLoader, File container, Log log) throws MojoExecutionException {
        Set<String> classNames = null;
        if (container.isFile() && container.getAbsolutePath().endsWith(".jar")) {
            try {
                JarFile jarFile = new JarFile(container);
                classNames = CDIUtil.getAllClassNames(jarFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not load the following JAR file: " + container.getAbsolutePath(), (Exception)e);
            }
        } else if (container.isDirectory()) {
            classNames = CDIUtil.getAllClassNames(container);
        }
        for (String className : classNames) {
            try {
                Class<?> cls = classLoader.loadClass(className);
                weld.addBeanClass(cls);
            }
            catch (ClassNotFoundException e) {
                log.error((CharSequence)("Could not load the following class which might cause later issues: " + className));
                if (!log.isDebugEnabled()) continue;
                log.debug((Throwable)e);
            }
        }
    }

    private static Set<String> getAllClassNames(JarFile f) {
        HashSet classNames = Sets.newHashSet();
        Enumeration<JarEntry> e = f.entries();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            String extension = Files.getFileExtension((String)je.getName());
            if (!Objects.equal((Object)FILE_EXTENSION_CLASS, (Object)extension)) continue;
            String className = je.getName().substring(0, je.getName().length() - 6);
            className = className.replace('/', '.');
            classNames.add(className);
        }
        return classNames;
    }

    private static Set<String> getAllClassNames(File folder) {
        HashSet classNames = Sets.newHashSet();
        for (File f : Files.fileTreeTraverser().preOrderTraversal((Object)folder)) {
            String extension = Files.getFileExtension((String)f.getName());
            if (!Objects.equal((Object)FILE_EXTENSION_CLASS, (Object)extension)) continue;
            String basePath = f.getAbsolutePath().replace(folder.getAbsolutePath(), "");
            String className = basePath.substring(0, basePath.length() - 6);
            if ((className = className.replace('/', '.').replace('\\', '.')).startsWith(".")) {
                className = className.substring(1);
            }
            classNames.add(className);
        }
        return classNames;
    }
}

