/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.cdi.internal.beans;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Qualifier;
import org.jboss.weld.literal.DefaultLiteral;

public class CdiProducerBean<T>
implements Bean<T> {
    private Method method;
    private Object hostInstance;
    private BeanManager beanManager;
    private Set<Annotation> qualifiers;
    private Set<Type> types;
    private Class<?> instanceClass;

    public CdiProducerBean(Method method, Object hostInstance, BeanManager beanManager, Type type, Class<?> instanceClass, Set<Annotation> qualifiers) {
        this.method = method;
        this.hostInstance = hostInstance;
        this.beanManager = beanManager;
        this.instanceClass = instanceClass;
        this.qualifiers = qualifiers;
        this.types = this.calcBeanTypes(type);
    }

    private Set<Type> calcBeanTypes(Type implTpye) {
        HashSet beanTypes = Sets.newHashSet();
        if (implTpye instanceof ParameterizedType) {
            beanTypes.add((ParameterizedType)implTpye);
        } else {
            Typed typedAnnotation = ((Class)implTpye).getAnnotation(Typed.class);
            if (typedAnnotation != null) {
                for (Class cls : typedAnnotation.value()) {
                    beanTypes.add(cls);
                }
            } else {
                beanTypes.addAll(this.getTypeClasses((Class)implTpye));
            }
        }
        return beanTypes;
    }

    private Set<Class<?>> getTypeClasses(Class<?> cls) {
        if (cls == null) {
            return Collections.emptySet();
        }
        HashSet classes = Sets.newHashSet();
        classes.add(cls);
        classes.addAll(this.getTypeClasses(cls.getSuperclass()));
        for (Class<?> iface : cls.getInterfaces()) {
            classes.addAll(this.getTypeClasses(iface));
        }
        return classes;
    }

    public T create(CreationalContext<T> creationalContext) {
        Object[] params = new Object[]{};
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        params = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object reference;
            Class<?> paramType = parameterTypes[i];
            Set<Annotation> qualifiers = this.getCdiQualifiers(parameterAnnotations[i]);
            Set beans = this.beanManager.getBeans(paramType, qualifiers.toArray(new Annotation[qualifiers.size()]));
            if (beans.size() != 1) continue;
            Bean bean = (Bean)Iterables.get((Iterable)beans, (int)0);
            params[i] = reference = this.beanManager.getReference(bean, paramType, this.beanManager.createCreationalContext((Contextual)bean));
        }
        Object instance = null;
        try {
            this.method.setAccessible(true);
            instance = this.method.invoke(this.hostInstance, params);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return (T)instance;
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public Class<?> getBeanClass() {
        return this.instanceClass;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return true;
    }

    private Set<Annotation> getCdiQualifiers(Annotation[] annotattions) {
        HashSet qualifiers = Sets.newHashSet();
        for (Annotation annotation : annotattions) {
            if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            qualifiers.add(annotation);
        }
        if (qualifiers.isEmpty()) {
            qualifiers.add(DefaultLiteral.INSTANCE);
        }
        return qualifiers;
    }
}

