/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.artifact.spy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.DefaultArtifact;

@Mojo(name="spy", defaultPhase=LifecyclePhase.VERIFY)
public class ArtifactSpyMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.directory}/artifact-spy/artifacts.properties")
    private File outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties props = new Properties();
        this.addPomArtifact(props);
        this.addProjectArtifact(props);
        this.addAttachedArtifacts(props);
        FileOutputStream fos = null;
        try {
            this.outputFile.getParentFile().mkdirs();
            fos = new FileOutputStream(this.outputFile);
            props.store(fos, "");
        }
        catch (IOException e) {
            throw new MojoFailureException("Error serializing the project artifacts to file: " + this.outputFile.getAbsolutePath(), (Throwable)e);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not close output stream after writing project artifacts to file: " + this.outputFile.getAbsolutePath(), (Exception)e);
            }
        }
    }

    private void addPomArtifact(Properties props) {
        props.setProperty(new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), "pom", this.project.getVersion()).toString(), this.getProjectRelativePath(this.project.getFile()));
    }

    private void addProjectArtifact(Properties props) {
        Artifact projectArtifact = this.project.getArtifact();
        if (projectArtifact.getFile() != null && projectArtifact.getFile().isFile()) {
            props.setProperty(RepositoryUtils.toArtifact((Artifact)projectArtifact).toString(), this.getProjectRelativePath(projectArtifact.getFile()));
        }
    }

    private void addAttachedArtifacts(Properties props) {
        for (Artifact a : this.project.getAttachedArtifacts()) {
            props.setProperty(RepositoryUtils.toArtifact((Artifact)a).toString(), this.getProjectRelativePath(a.getFile()));
        }
    }

    private String getProjectRelativePath(File f) {
        return this.project.getBasedir().toURI().relativize(f.toURI()).getPath();
    }
}

