/*
 * Decompiled with CFR 0.152.
 */
package ioinformarics.oss.jackson.module.jsonld.internal;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldProperty;
import java.util.Optional;

public class JsonldPropertyNamingStrategy
extends PropertyNamingStrategy {
    public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
        String name = config instanceof DeserializationConfig ? this.jsonldName((AnnotatedMember)field) : null;
        return Optional.ofNullable(name).orElse(super.nameForField(config, field, defaultName));
    }

    public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
        String name = config instanceof DeserializationConfig ? this.jsonldName((AnnotatedMember)method) : null;
        return Optional.ofNullable(name).orElse(super.nameForGetterMethod(config, method, defaultName));
    }

    public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
        String name = config instanceof DeserializationConfig ? this.jsonldName((AnnotatedMember)method) : null;
        return Optional.ofNullable(name).orElse(super.nameForSetterMethod(config, method, defaultName));
    }

    public String nameForConstructorParameter(MapperConfig<?> config, AnnotatedParameter ctorParam, String defaultName) {
        String name = config instanceof DeserializationConfig ? this.jsonldName((AnnotatedMember)ctorParam) : null;
        return Optional.ofNullable(name).orElse(super.nameForConstructorParameter(config, ctorParam, defaultName));
    }

    private String jsonldName(AnnotatedMember member) {
        JsonldProperty jsonldProperty = (JsonldProperty)member.getAnnotation(JsonldProperty.class);
        return jsonldProperty != null ? jsonldProperty.value() : null;
    }
}

