/*
 * Decompiled with CFR 0.152.
 */
package ioinformarics.oss.jackson.module.jsonld;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import ioinformarics.oss.jackson.module.jsonld.JsonldGraph;
import ioinformarics.oss.jackson.module.jsonld.JsonldResource;
import ioinformarics.oss.jackson.module.jsonld.JsonldResourceBuilder;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;

public class JsonldGraphBuilder<T> {
    protected String context;
    protected String graphType;
    protected String graphId;
    protected JsonldResourceBuilder<T> resourceBuilder = new JsonldResourceBuilder();
    protected Function<T, String> typeSupplier;

    JsonldGraphBuilder() {
    }

    public JsonldGraphBuilder<T> context(String context) {
        this.context = context;
        return this;
    }

    public JsonldGraphBuilder<T> type(String type) {
        this.graphType = type;
        return this;
    }

    public JsonldGraphBuilder<T> id(String id) {
        this.graphId = id;
        return this;
    }

    public JsonldGraphBuilder<T> elementId(Function<T, String> idSupplier) {
        this.resourceBuilder.id(idSupplier);
        return this;
    }

    public JsonldGraphBuilder<T> elementType(Function<T, String> typeSupplier) {
        this.typeSupplier = typeSupplier;
        return this;
    }

    public JsonldResource build(T ... elements) {
        return this.build((Iterable<T>)Arrays.asList(elements));
    }

    public JsonldResource build(Iterable<T> elements) {
        return new JsonldGraph(elements, (JsonNode)Optional.ofNullable(this.context).map(c -> TextNode.valueOf((String)c)).orElse(null), this.graphType, this.graphId);
    }

    protected String getType(T e) {
        return this.typeSupplier.apply(e);
    }
}

