/*
 * Decompiled with CFR 0.152.
 */
package ioinformarics.oss.jackson.module.jsonld;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldId;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldLink;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldNamespace;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldProperty;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldResource;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldTypeFromJavaClass;
import ioinformarics.oss.jackson.module.jsonld.util.AnnotationsUtils;
import ioinformarics.oss.jackson.module.jsonld.util.JsonUtils;
import ioinformarics.oss.jackson.module.jsonld.util.JsonldResourceUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;

public class JsonldContextFactory {
    public static ObjectNode fromPackage(String packageName) {
        ObjectNode generatedContext = JsonNodeFactory.withExactBigDecimals((boolean)true).objectNode();
        FastClasspathScanner scanner = new FastClasspathScanner(new String[]{packageName});
        scanner.matchAllStandardClasses(clazz -> {
            if (!Modifier.isAbstract(clazz.getModifiers()) && AnnotationsUtils.isAnnotationPresent(clazz, JsonldTypeFromJavaClass.class)) {
                Optional<String> type = JsonldResourceUtils.dynamicTypeLookup(clazz);
                type.ifPresent(t -> generatedContext.set(clazz.getSimpleName(), (JsonNode)TextNode.valueOf((String)t)));
            }
            if (AnnotationsUtils.isAnnotationPresent(clazz, JsonldResource.class)) {
                Optional<ObjectNode> resourceContext = JsonldContextFactory.fromAnnotations(clazz);
                resourceContext.ifPresent(context -> JsonUtils.merge((JsonNode)generatedContext, (JsonNode)context));
            }
        });
        scanner.scan();
        return (ObjectNode)JsonNodeFactory.withExactBigDecimals((boolean)true).objectNode().set("@context", (JsonNode)generatedContext);
    }

    public static Optional<ObjectNode> fromAnnotations(Object instance) {
        return JsonldContextFactory.fromAnnotations(instance.getClass());
    }

    public static Optional<ObjectNode> fromAnnotations(Iterable<?> instances) {
        ObjectNode mergedContext = JsonNodeFactory.withExactBigDecimals((boolean)true).objectNode();
        instances.forEach(e -> JsonldContextFactory.fromAnnotations(e).map(arg_0 -> ((ObjectNode)mergedContext).setAll(arg_0)));
        return mergedContext.size() != 0 ? Optional.of(mergedContext) : Optional.empty();
    }

    public static Optional<ObjectNode> fromAnnotations(Class<?> objType) {
        ObjectNode generatedContext = JsonNodeFactory.withExactBigDecimals((boolean)true).objectNode();
        JsonldContextFactory.generateNamespaces(objType).forEach((name, uri) -> generatedContext.set(name, (JsonNode)new TextNode(uri)));
        Map<String, JsonNode> fieldContexts = JsonldContextFactory.generateContextsForFields(objType);
        fieldContexts.forEach((arg_0, arg_1) -> ((ObjectNode)generatedContext).set(arg_0, arg_1));
        JsonldLink[] links = (JsonldLink[])objType.getAnnotationsByType(JsonldLink.class);
        if (links != null) {
            for (int i = 0; i < links.length; ++i) {
                ObjectNode linkNode = JsonNodeFactory.withExactBigDecimals((boolean)true).objectNode();
                linkNode.set("@id", (JsonNode)new TextNode(links[i].rel()));
                linkNode.set("@type", (JsonNode)new TextNode("@id"));
                generatedContext.set(links[i].name(), (JsonNode)linkNode);
            }
        }
        return generatedContext.size() != 0 ? Optional.of(generatedContext) : Optional.empty();
    }

    private static Map<String, JsonNode> generateContextsForFields(Class<?> objType) {
        return JsonldContextFactory.generateContextsForFields(objType, new ArrayList());
    }

    private static Map<String, JsonNode> generateContextsForFields(Class<?> objType, List<Class<?>> ignoreTypes) {
        Class<?> currentClass;
        HashMap<String, JsonNode> contexts = new HashMap<String, JsonNode>();
        Optional<JsonldNamespace> namespace = Optional.ofNullable(currentClass.getAnnotation(JsonldNamespace.class));
        for (currentClass = objType; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = currentClass.getDeclaredFields()) {
                if (f.isAnnotationPresent(JsonldId.class) || f.getName().equals("this$0")) continue;
                JsonldProperty jsonldProperty = f.getAnnotation(JsonldProperty.class);
                Optional<String> propertyId = Optional.empty();
                if (jsonldProperty != null && !contexts.containsKey(f.getName())) {
                    propertyId = Optional.of(jsonldProperty.value());
                } else if (jsonldProperty == null && namespace.map(JsonldNamespace::applyToProperties).orElse(false).booleanValue()) {
                    propertyId = Optional.of(namespace.get().name() + ":" + f.getName());
                }
                propertyId.ifPresent(id -> {
                    if (JsonldContextFactory.isRelation(f)) {
                        ObjectNode node = JsonNodeFactory.withExactBigDecimals((boolean)true).objectNode();
                        node.set("@id", (JsonNode)TextNode.valueOf((String)id));
                        node.set("@type", (JsonNode)TextNode.valueOf((String)"@id"));
                        contexts.put(f.getName(), (JsonNode)node);
                    } else {
                        contexts.put(f.getName(), (JsonNode)TextNode.valueOf((String)id));
                    }
                });
            }
            if (namespace.isPresent()) continue;
            namespace = Optional.ofNullable(currentClass.getAnnotation(JsonldNamespace.class));
        }
        return contexts;
    }

    private static Class<?> relationType(Field field) {
        Class type = field.getType();
        if (Collection.class.isAssignableFrom(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type t = parameterizedType.getActualTypeArguments()[0];
            if (Class.class.isAssignableFrom(t.getClass())) {
                type = (Class)t;
            } else if (ParameterizedType.class.isAssignableFrom(t.getClass())) {
                type = (Class)((ParameterizedType)t).getRawType();
            }
        }
        if (type.isArray()) {
            type = type.getComponentType();
        }
        return type;
    }

    private static boolean isRelation(Field field) {
        Class<?> type = JsonldContextFactory.relationType(field);
        return Stream.concat(Stream.of(type), Stream.concat(ClassUtils.getAllSuperclasses(type).stream(), ClassUtils.getAllInterfaces(type).stream())).flatMap(currentClass -> Stream.concat(Stream.of(currentClass.getDeclaredFields()), Stream.of(currentClass.getDeclaredMethods()))).anyMatch(p -> p.getAnnotation(JsonldId.class) != null);
    }

    private static Map<String, String> generateNamespaces(Class<?> objType) {
        JsonldNamespace[] namespaceAnnotations = (JsonldNamespace[])objType.getAnnotationsByType(JsonldNamespace.class);
        HashMap<String, String> namespaces = new HashMap<String, String>(namespaceAnnotations.length);
        Arrays.asList(namespaceAnnotations).forEach(ns -> namespaces.put(ns.name(), ns.uri()));
        return namespaces;
    }

    public static Optional<JsonNode> multiContext(Optional<String> externalContext, Optional<ObjectNode> internalContext) {
        if (internalContext.isPresent()) {
            return externalContext.isPresent() ? Optional.of(JsonldContextFactory.buildMultiContext(externalContext.get(), (JsonNode)internalContext.get())) : internalContext.map(it -> it);
        }
        return externalContext.map(TextNode::valueOf);
    }

    private static ArrayNode buildMultiContext(String context, JsonNode generatedContext) {
        return JsonNodeFactory.withExactBigDecimals((boolean)true).arrayNode().add(context).add(generatedContext);
    }
}

