/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.JdbcConn;
import com.ingres.gcf.jdbc.TraceDS;
import com.ingres.gcf.util.Config;
import com.ingres.gcf.util.ConfigKey;
import com.ingres.gcf.util.ConfigProp;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlExType;
import com.ingres.gcf.util.TraceLog;
import com.ingres.gcf.util.XaXid;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.BinaryRefAddr;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public abstract class JdbcDS
implements DataSource,
Serializable,
DrvConst,
GcfErr {
    public static final String driverVendor = "Actian Corporation";
    public static final String driverJdbcVersion = "JDBC 4.1";
    public static final int driverMajorVersion = 4;
    public static final int driverMinorVersion = 1;
    public static final int driverPatchVersion = 10;
    protected transient TraceDS trace = null;
    protected transient String title = "JDBC-DataSource";
    protected transient String tr_id = "DSrc";
    protected transient int inst_id = 0;
    private transient TraceDS conn_trace = null;
    private static int inst_count = 0;
    private static final String DFLT_PWD_KEY = "password";
    private String description = null;
    private String serverName = null;
    private int portNumber = 0;
    private String portName = null;
    private String databaseName = null;
    private String user = null;
    private byte[] password = null;
    private String roleName = null;
    private String groupName = null;
    private String dbmsUser = null;
    private byte[] dbmsPassword = null;
    private String connectionPool = null;
    private String autocommitMode = null;
    private String selectLoops = null;
    private String cursorMode = null;
    private String vnodeUsage = null;
    private String charEncode = null;
    private String timeZone = null;
    private char decimalChar = '\u0000';
    private String dateFormat = null;
    private String moneyFormat = null;
    private int moneyPrecision = -1;
    private String dateAlias = null;
    private String sendIngresDates = null;
    private String sendIntegerBooleans = null;
    private String identityQuery = null;
    private String encryption = null;
    private int timeout = 0;

    protected abstract Config loadConfig();

    protected abstract String loadDriverName();

    protected abstract String loadProtocolID();

    protected abstract String loadTraceName();

    protected abstract TraceLog loadTraceLog();

    protected JdbcDS() {
        this.initialize();
    }

    private void initialize() {
        this.trace = new TraceDS(this.loadTraceLog(), this.loadTraceName(), "ds");
        this.conn_trace = new TraceDS(this.loadTraceLog(), this.loadTraceName(), "drv");
        this.inst_id = inst_count++;
        this.title = this.loadTraceName() + "-DataSource[" + this.inst_id + "]";
        this.tr_id = this.tr_id + "[" + this.inst_id + "]";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ": " + string);
        }
        this.description = string;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int n) {
        this.portNumber = n;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String string) {
        this.portName = string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        String string2 = this.decode(this.password, this.user);
        this.password = this.encode(string2, string);
        this.user = string;
    }

    public String getPassword() {
        return "*****";
    }

    public void setPassword(String string) {
        this.password = this.encode(string, this.user);
    }

    public String getDbmsUser() {
        return this.dbmsUser;
    }

    public void setDbmsUser(String string) {
        String string2 = this.decode(this.dbmsPassword, this.dbmsUser);
        this.dbmsPassword = this.encode(string2, string);
        this.dbmsUser = string;
    }

    public String getDbmsPassword() {
        return "*****";
    }

    public void setDbmsPassword(String string) {
        this.dbmsPassword = this.encode(string, this.dbmsUser);
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String string) {
        this.roleName = string;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public String getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(String string) {
        this.connectionPool = string;
    }

    public String getAutocommitMode() {
        return this.autocommitMode;
    }

    public void setAutocommitMode(String string) {
        this.autocommitMode = string;
    }

    public String getSelectLoops() {
        return this.selectLoops;
    }

    public void setSelectLoops(String string) {
        this.selectLoops = string;
    }

    public String getCursorMode() {
        return this.cursorMode;
    }

    public void setCursorMode(String string) {
        this.cursorMode = string;
    }

    public String getVnodeUsage() {
        return this.vnodeUsage;
    }

    public void setVnodeUsage(String string) {
        this.vnodeUsage = string;
    }

    public String getCharEncode() {
        return this.charEncode;
    }

    public void setCharEncode(String string) {
        this.charEncode = string;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String string) {
        this.timeZone = string;
    }

    public String getDecimalChar() {
        return this.decimalChar == '\u0000' ? null : String.valueOf(this.decimalChar);
    }

    public void setDecimalChar(String string) {
        this.decimalChar = string == null || string.length() == 0 ? (char)'\u0000' : string.charAt(0);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
    }

    public String getMoneyFormat() {
        return this.moneyFormat;
    }

    public void setMoneyFormat(String string) {
        this.moneyFormat = string;
    }

    public int getMoneyPrecision() {
        return this.moneyPrecision;
    }

    public void setMoneyPrecision(int n) {
        this.moneyPrecision = n;
    }

    public String getDateAlias() {
        return this.dateAlias;
    }

    public void setDateAlias(String string) {
        this.dateAlias = string;
    }

    public String getSendIngresDates() {
        return this.sendIngresDates;
    }

    public void setSendIngresDates(String string) {
        this.sendIngresDates = string;
    }

    public String getSendIntegerBooleans() {
        return this.sendIntegerBooleans;
    }

    public void setSendIntegerBooleans(String string) {
        this.sendIntegerBooleans = string;
    }

    public String getIdentityQuery() {
        return this.identityQuery;
    }

    public void setIdentityQuery(String string) {
        this.identityQuery = string;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String string) {
        this.encryption = string;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection()");
        }
        JdbcConn jdbcConn = this.connect(null, null);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection(): " + jdbcConn);
        }
        return jdbcConn;
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection('" + string + "','*****')");
        }
        JdbcConn jdbcConn = this.connect(string, string2);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection(): " + jdbcConn);
        }
        return jdbcConn;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.timeout;
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.timeout = n;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.trace.getWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.trace.setWriter(printWriter);
        if (this.conn_trace.getWriter() != printWriter) {
            this.conn_trace = new TraceDS(this.loadTraceLog(), this.loadTraceName(), "drv");
            this.conn_trace.setWriter(printWriter);
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)SqlExFactory.get(ERR_GC4019_UNSUPPORTED, SqlExType.UNSUPPORTED_FEATURE);
    }

    protected JdbcConn connect(String string, String string2) throws SQLException {
        Config config = this.loadConfig();
        String string3 = this.getHost();
        int n = 0;
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": connect to " + string3);
        }
        Config config2 = new ConfigKey("property", config);
        config2 = new ConfigProp(this.getProperties(string, string2), config2);
        String string4 = config.get("encryption");
        if (string4 != null && string4.length() > 0) {
            if (string4.equalsIgnoreCase("on")) {
                n |= 2;
            } else if (string4.equalsIgnoreCase("off")) {
                n &= 0xFFFFFFFD;
            } else {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": encryption '" + string4 + "'");
                }
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        DrvConn drvConn = new DrvConn(string3, config, this.conn_trace, n);
        drvConn.driverName = this.loadDriverName();
        drvConn.protocol = this.loadProtocolID();
        return new JdbcConn(drvConn, config2, this.timeout);
    }

    protected JdbcConn connect(String string, String string2, XaXid xaXid) throws SQLException {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": connecting (DTMC) to " + string);
        }
        Properties properties = new Properties();
        properties.setProperty("database", string2);
        if (this.trace.enabled(3)) {
            this.trace.write("     database: " + string2);
            if (xaXid != null) {
                this.trace.write("     xid: " + xaXid);
            }
        }
        DrvConn drvConn = new DrvConn(string, this.loadConfig(), this.conn_trace, 1);
        drvConn.driverName = this.loadDriverName();
        drvConn.protocol = this.loadProtocolID();
        return new JdbcConn(drvConn, (Config)new ConfigProp(properties), xaXid);
    }

    protected String getHost() {
        String string = this.portName != null ? this.serverName + ':' + this.portName : (this.portNumber > 0 ? this.serverName + ':' + this.portNumber : this.serverName);
        return string;
    }

    protected void initReference(Reference reference) {
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.portName != null) {
            reference.add(new StringRefAddr("portName", this.portName));
        }
        if (this.portNumber > 0) {
            this.encodeIntRef(reference, "portNumber", this.portNumber);
        }
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.user != null) {
            reference.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            reference.add(new BinaryRefAddr("password.v1", this.password));
        }
        if (this.dbmsUser != null) {
            reference.add(new StringRefAddr("dbmsUser", this.dbmsUser));
        }
        if (this.dbmsPassword != null) {
            reference.add(new BinaryRefAddr("dbmsPassword.v1", this.dbmsPassword));
        }
        if (this.roleName != null) {
            reference.add(new StringRefAddr("roleName", this.roleName));
        }
        if (this.groupName != null) {
            reference.add(new StringRefAddr("groupName", this.groupName));
        }
        if (this.connectionPool != null) {
            reference.add(new StringRefAddr("connectionPool", this.connectionPool));
        }
        if (this.autocommitMode != null) {
            reference.add(new StringRefAddr("autocommitMode", this.autocommitMode));
        }
        if (this.selectLoops != null) {
            reference.add(new StringRefAddr("selectLoops", this.selectLoops));
        }
        if (this.cursorMode != null) {
            reference.add(new StringRefAddr("cursorMode", this.cursorMode));
        }
        if (this.vnodeUsage != null) {
            reference.add(new StringRefAddr("vnodeUsage", this.vnodeUsage));
        }
        if (this.charEncode != null) {
            reference.add(new StringRefAddr("charEncode", this.charEncode));
        }
        if (this.timeZone != null) {
            reference.add(new StringRefAddr("timeZone", this.timeZone));
        }
        if (this.decimalChar != '\u0000') {
            reference.add(new StringRefAddr("decimalChar", String.valueOf(this.decimalChar)));
        }
        if (this.dateFormat != null) {
            reference.add(new StringRefAddr("dateFormat", this.dateFormat));
        }
        if (this.moneyFormat != null) {
            reference.add(new StringRefAddr("moneyFormat", this.moneyFormat));
        }
        if (this.moneyPrecision >= 0) {
            this.encodeIntRef(reference, "moneyPrecision", this.moneyPrecision);
        }
        if (this.dateAlias != null) {
            reference.add(new StringRefAddr("dateAlias", this.dateAlias));
        }
        if (this.sendIngresDates != null) {
            reference.add(new StringRefAddr("sendIngresDates", this.sendIngresDates));
        }
        if (this.sendIntegerBooleans != null) {
            reference.add(new StringRefAddr("sendIntegerBooleans", this.sendIntegerBooleans));
        }
        if (this.identityQuery != null) {
            reference.add(new StringRefAddr("identityQuery", this.identityQuery));
        }
        if (this.encryption != null) {
            reference.add(new StringRefAddr("encryption", this.encryption));
        }
    }

    protected void initInstance(Reference reference) {
        RefAddr refAddr = reference.get("description");
        if (refAddr != null) {
            this.description = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("serverName")) != null) {
            this.serverName = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("portName")) != null) {
            this.portName = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("portNumber")) != null) {
            this.portNumber = this.decodeIntRef(refAddr);
        }
        if ((refAddr = reference.get("databaseName")) != null) {
            this.databaseName = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("user")) != null) {
            this.user = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("password.v1")) != null) {
            this.password = (byte[])((BinaryRefAddr)refAddr).getContent();
        } else {
            refAddr = reference.get(DFLT_PWD_KEY);
            if (refAddr != null) {
                this.password = this.encode((String)((StringRefAddr)refAddr).getContent(), this.user);
            }
        }
        refAddr = reference.get("dbmsUser");
        if (refAddr != null) {
            this.dbmsUser = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("dbmsPassword.v1")) != null) {
            this.dbmsPassword = (byte[])((BinaryRefAddr)refAddr).getContent();
        } else {
            refAddr = reference.get("dbmsPassword");
            if (refAddr != null) {
                this.dbmsPassword = this.encode((String)((StringRefAddr)refAddr).getContent(), this.dbmsUser);
            }
        }
        refAddr = reference.get("roleName");
        if (refAddr != null) {
            this.roleName = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("groupName")) != null) {
            this.groupName = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("connectionPool")) != null) {
            this.connectionPool = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("autocommitMode")) != null) {
            this.autocommitMode = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("selectLoops")) != null) {
            this.selectLoops = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("cursorMode")) != null) {
            this.cursorMode = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("vnodeUsage")) != null) {
            this.vnodeUsage = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("charEncode")) != null) {
            this.charEncode = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("timeZone")) != null) {
            this.timeZone = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("decimalChar")) != null) {
            this.decimalChar = ((String)((StringRefAddr)refAddr).getContent()).charAt(0);
        }
        if ((refAddr = reference.get("dateFormat")) != null) {
            this.dateFormat = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("moneyFormat")) != null) {
            this.moneyFormat = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("moneyPrecision")) != null) {
            this.moneyPrecision = this.decodeIntRef(refAddr);
        }
        if ((refAddr = reference.get("dateAlias")) != null) {
            this.dateAlias = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("sendIngresDates")) != null) {
            this.sendIngresDates = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("sendIntegerBooleans")) != null) {
            this.sendIntegerBooleans = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("identityQuery")) != null) {
            this.identityQuery = (String)((StringRefAddr)refAddr).getContent();
        }
        if ((refAddr = reference.get("encryption")) != null) {
            this.encryption = (String)((StringRefAddr)refAddr).getContent();
        }
    }

    protected void encodeIntRef(Reference reference, String string, int n) {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        reference.add(new BinaryRefAddr(string, byArray));
    }

    protected int decodeIntRef(RefAddr refAddr) {
        byte[] byArray = (byte[])((BinaryRefAddr)refAddr).getContent();
        return byArray[3] << 24 & 0xFF000000 | byArray[2] << 16 & 0xFF0000 | byArray[1] << 8 & 0xFF00 | byArray[0] & 0xFF;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize();
    }

    private byte[] encode(String string, String string2) {
        byte[] byArray = null;
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = DFLT_PWD_KEY;
        }
        try {
            byte[] byArray2 = string2.getBytes("UTF-8");
            byArray = string.getBytes("UTF-8");
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] ^ byArray2[n]);
                if (++n < byArray2.length) continue;
                n = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private String decode(byte[] byArray, String string) {
        String string2 = null;
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (string == null || string.length() == 0) {
            string = DFLT_PWD_KEY;
        }
        try {
            byte[] byArray2 = string.getBytes("UTF-8");
            byte[] byArray3 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            int n = 0;
            for (int i = 0; i < byArray3.length; ++i) {
                int n2 = i;
                byArray3[n2] = (byte)(byArray3[n2] ^ byArray2[n]);
                if (++n < byArray2.length) continue;
                n = 0;
            }
            string2 = new String(byArray3, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private Properties getProperties(String string, String string2) {
        boolean bl = this.trace.enabled(3);
        Properties properties = new Properties();
        if (string == null) {
            string = this.user;
            string2 = this.decode(this.password, this.user);
        }
        if (this.databaseName != null) {
            if (bl) {
                this.trace.write("     database: " + this.databaseName);
            }
            properties.setProperty("database", this.databaseName);
        }
        if (string != null) {
            if (bl) {
                this.trace.write("     user: " + string);
            }
            properties.setProperty("user", string);
        }
        if (string2 != null) {
            if (bl) {
                this.trace.write("     password: *****");
            }
            properties.setProperty(DFLT_PWD_KEY, string2);
        }
        if (this.roleName != null) {
            if (bl) {
                this.trace.write("     role: " + this.roleName);
            }
            properties.setProperty("role", this.roleName);
        }
        if (this.groupName != null) {
            if (bl) {
                this.trace.write("     group: " + this.groupName);
            }
            properties.setProperty("group", this.groupName);
        }
        if (this.dbmsUser != null) {
            if (bl) {
                this.trace.write("     dbms_user: " + this.dbmsUser);
            }
            properties.setProperty("dbms_user", this.dbmsUser);
        }
        if (this.dbmsPassword != null) {
            if (bl) {
                this.trace.write("     dbms_password: *****");
            }
            properties.setProperty("dbms_password", this.decode(this.dbmsPassword, this.dbmsUser));
        }
        if (this.connectionPool != null) {
            if (bl) {
                this.trace.write("     connect_pool: " + this.connectionPool);
            }
            properties.setProperty("connect_pool", this.connectionPool);
        }
        if (this.autocommitMode != null) {
            if (bl) {
                this.trace.write("     autocommit_mode: " + this.autocommitMode);
            }
            properties.setProperty("autocommit_mode", this.autocommitMode);
        }
        if (this.selectLoops != null) {
            if (bl) {
                this.trace.write("     select_loop: " + this.selectLoops);
            }
            properties.setProperty("select_loop", this.selectLoops);
        }
        if (this.cursorMode != null) {
            if (bl) {
                this.trace.write("     cursor_mode: " + this.cursorMode);
            }
            properties.setProperty("cursor_mode", this.cursorMode);
        }
        if (this.vnodeUsage != null) {
            if (bl) {
                this.trace.write("     vnode_usage: " + this.vnodeUsage);
            }
            properties.setProperty("vnode_usage", this.vnodeUsage);
        }
        if (this.charEncode != null) {
            if (bl) {
                this.trace.write("     char_encode: " + this.charEncode);
            }
            properties.setProperty("char_encode", this.charEncode);
        }
        if (this.timeZone != null) {
            if (bl) {
                this.trace.write("     timezone: " + this.timeZone);
            }
            properties.setProperty("timezone", this.timeZone);
        }
        if (this.decimalChar != '\u0000') {
            if (bl) {
                this.trace.write("     decimal_char: " + this.decimalChar);
            }
            properties.setProperty("decimal_char", String.valueOf(this.decimalChar));
        }
        if (this.dateFormat != null) {
            if (bl) {
                this.trace.write("     date_format: " + this.dateFormat);
            }
            properties.setProperty("date_format", this.dateFormat);
        }
        if (this.moneyFormat != null) {
            if (bl) {
                this.trace.write("     money_format: " + this.moneyFormat);
            }
            properties.setProperty("money_format", this.moneyFormat);
        }
        if (this.moneyPrecision > 0) {
            String string3 = Integer.toString(this.moneyPrecision);
            if (bl) {
                this.trace.write("     money_precision: " + string3);
            }
            properties.setProperty("money_precision", string3);
        }
        if (this.dateAlias != null) {
            if (bl) {
                this.trace.write("     date_alias: " + this.dateAlias);
            }
            properties.setProperty("date_alias", this.dateAlias);
        }
        if (this.sendIngresDates != null) {
            if (bl) {
                this.trace.write("     send_ingres_dates: " + this.sendIngresDates);
            }
            properties.setProperty("send_ingres_dates", this.sendIngresDates);
        }
        if (this.sendIntegerBooleans != null) {
            if (bl) {
                this.trace.write("     send_integer_booleans: " + this.sendIntegerBooleans);
            }
            properties.setProperty("send_integer_booleans", this.sendIntegerBooleans);
        }
        if (this.identityQuery != null) {
            if (bl) {
                this.trace.write("    identity_query: " + this.identityQuery);
            }
            properties.setProperty("identity_query", this.identityQuery);
        }
        if (this.encryption != null) {
            if (bl) {
                this.trace.write("    encryption: " + this.encryption);
            }
            properties.setProperty("encryption", this.encryption);
        }
        return properties;
    }
}

