/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.TlConst;
import com.ingres.gcf.util.Crypto;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlExType;
import com.ingres.gcf.util.Trace;
import com.ingres.gcf.util.TraceLog;
import com.ingres.gcf.util.Tracing;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.concurrent.Executor;

class IoBuff
implements TlConst,
GcfErr {
    public static final String DAM_TL_TRACE_ID = "msg.tl";
    public static final String DAM_NL_TRACE_ID = "msg.nl";
    protected byte[] buffer;
    protected int data_beg;
    protected int data_ptr;
    protected int data_end;
    protected byte proto_lvl = 1;
    protected Crypto.AESSession aesSession = null;
    protected String title = "IoBuff";
    protected Trace trace;
    protected Executor timeoutExecutor = null;
    protected Runnable timeoutAction = null;
    private InputStream in = null;
    private OutputStream out = null;
    private boolean closed = false;
    private int buf_max;
    private int buf_end;
    private int buf_len;
    private int seg_beg;
    private int seg_end;
    private int encryptOVHD = 0;

    protected IoBuff(InputStream inputStream, TraceLog traceLog) {
        this(traceLog);
        this.in = inputStream;
    }

    protected IoBuff(OutputStream outputStream, TraceLog traceLog) {
        this(traceLog);
        this.out = outputStream;
    }

    private IoBuff(TraceLog traceLog) {
        this.trace = new Tracing(traceLog, DAM_NL_TRACE_ID);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.endSegment();
                    this.flushBuffer(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.clearBuffer();
            this.in = null;
            this.out = null;
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": closed");
            }
        }
    }

    public synchronized void clear() {
        this.clearBuffer();
    }

    public synchronized void setBuffSize(int n) {
        this.buf_max = n + 2;
        this.buf_end = this.buf_max - this.encryptOVHD;
        this.buffer = new byte[this.buf_max];
        this.clearBuffer();
        if (this.trace.enabled(4)) {
            this.trace.write(this.title + ": set buffer size " + n);
        }
    }

    public byte setProtoLvl(byte by) {
        byte by2 = this.proto_lvl;
        this.proto_lvl = by;
        return by2;
    }

    public void setEncryption(Crypto.AESSession aESSession) {
        this.aesSession = aESSession;
        this.encryptOVHD = aESSession.getBlockSize();
        this.buf_end = this.buf_max - this.encryptOVHD;
    }

    protected synchronized void begin(int n) throws SQLException {
        if (this.closed || this.out == null) {
            throw SqlExFactory.get(ERR_GC4004_CONNECTION_CLOSED);
        }
        this.endSegment();
        if (this.buf_len + n + 2 > this.buf_end) {
            this.flushBuffer(false);
        }
        this.data_beg = this.data_ptr = this.seg_beg + 2;
        this.data_end = this.buf_end;
    }

    protected synchronized void flush(boolean bl) throws SQLException {
        if (this.closed || this.out == null) {
            throw SqlExFactory.get(ERR_GC4004_CONNECTION_CLOSED);
        }
        this.endSegment();
        this.flushBuffer(bl);
    }

    protected synchronized void next() throws SQLException {
        if (this.closed || this.in == null) {
            throw SqlExFactory.get(ERR_GC4004_CONNECTION_CLOSED);
        }
        if (this.seg_beg < this.seg_end) {
            this.seg_beg = this.seg_end;
        }
        if (this.seg_beg >= this.buf_len) {
            this.clearBuffer();
        }
        this.fillBuffer(2);
        int n = this.getSegSize();
        if (this.trace.enabled(4)) {
            this.trace.write(this.title + ": get segment length " + n);
        }
        this.fillBuffer(n);
        this.seg_end = this.seg_beg + n;
        this.data_beg = this.data_ptr = this.seg_beg + 2;
        this.data_end = this.seg_end;
        int n2 = this.data_end - this.data_beg;
        if (this.aesSession != null) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": decrypting " + n2 + " bytes.");
            }
            if (this.trace.enabled(4)) {
                this.trace.hexdump(this.buffer, this.data_beg, n2);
            }
            n2 = this.aesSession.decrypt(this.buffer, this.data_beg, n2);
            this.data_end = this.data_beg + n2;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": received " + n2 + " bytes.");
        }
        if (this.trace.enabled(3)) {
            this.trace.hexdump(this.buffer, this.data_beg, n2);
        }
    }

    private void endSegment() throws SQLException {
        int n = this.data_ptr - this.data_beg;
        if (n > 0) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": sending " + n + " bytes.");
            }
            if (this.trace.enabled(3)) {
                this.trace.hexdump(this.buffer, this.data_beg, n);
            }
            if (this.aesSession != null) {
                n = this.aesSession.encrypt(this.buffer, this.data_beg, n);
                this.data_ptr = this.data_beg + n;
                if (this.trace.enabled(2)) {
                    this.trace.write(this.title + ": encrypted " + n + " bytes.");
                }
                if (this.trace.enabled(4)) {
                    this.trace.hexdump(this.buffer, this.data_beg, n);
                }
            }
        }
        this.setSegSize();
        this.data_ptr = this.data_end = (this.seg_beg = this.seg_end);
        this.data_beg = this.data_end;
    }

    private void clearBuffer() {
        this.buf_len = 0;
        this.seg_end = 0;
        this.seg_beg = 0;
        this.data_end = 0;
        this.data_ptr = 0;
        this.data_beg = 0;
    }

    private void flushBuffer(boolean bl) throws SQLException {
        if (this.buf_len <= 0) {
            return;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": sending " + this.buf_len + " bytes.");
        }
        if (this.trace.enabled(5)) {
            this.trace.hexdump(this.buffer, 0, this.buf_len);
        }
        try {
            this.out.write(this.buffer, 0, this.buf_len);
        }
        catch (Exception exception) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": write error: " + exception.getMessage());
            }
            this.clearBuffer();
            this.close();
            throw SqlExFactory.get(ERR_GC4003_CONNECT_FAIL, exception);
        }
        this.clearBuffer();
        if (bl) {
            try {
                this.out.flush();
            }
            catch (Exception exception) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": flush error: " + exception.getMessage());
                }
                this.close();
                throw SqlExFactory.get(ERR_GC4003_CONNECT_FAIL, exception);
            }
        }
    }

    private void fillBuffer(int n) throws SQLException {
        int n2;
        if (this.seg_beg + n <= this.buf_len) {
            return;
        }
        if (n > this.buf_max) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": buffer overflow (" + n + "," + this.buf_max + ")");
            }
            this.close();
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        if (this.seg_beg > 0) {
            n2 = 0;
            while (this.seg_beg + n2 < this.buf_len) {
                this.buffer[n2] = this.buffer[this.seg_beg + n2];
                ++n2;
            }
            this.buf_len -= this.seg_beg;
            this.seg_end -= this.seg_beg;
            this.seg_beg = 0;
        }
        while (this.buf_len < n) {
            n2 = this.buf_max - this.buf_len;
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ": reading " + n2 + " bytes (" + n + " requested, " + this.buf_len + " buffered)");
            }
            try {
                n2 = this.in.read(this.buffer, this.buf_len, n2);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": read timeout");
                }
                if (this.timeoutAction == null) {
                    this.close();
                } else if (this.timeoutExecutor == null) {
                    this.timeoutAction.run();
                } else {
                    this.timeoutExecutor.execute(this.timeoutAction);
                }
                throw SqlExFactory.get(ERR_GC4006_TIMEOUT, SqlExType.TIMEOUT_EXCEPTION);
            }
            catch (Exception exception) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": read error: " + exception.getMessage());
                }
                this.close();
                throw SqlExFactory.get(ERR_GC4003_CONNECT_FAIL, exception);
            }
            if (n2 < 0) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": connection closed by server");
                }
                this.close();
                throw SqlExFactory.get(ERR_GC4003_CONNECT_FAIL);
            }
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": received " + n2 + " bytes.");
            }
            if (this.trace.enabled(5)) {
                this.trace.hexdump(this.buffer, this.buf_len, n2);
            }
            this.buf_len += n2;
        }
    }

    private int getSegSize() {
        return this.buffer[this.seg_beg] & 0xFF | this.buffer[this.seg_beg + 1] << 8 & 0xFF00;
    }

    private void setSegSize() {
        if (this.data_ptr <= this.seg_beg + 2) {
            this.data_ptr = this.seg_beg;
        }
        this.seg_end = this.buf_len = this.data_ptr;
        int n = this.seg_end - this.seg_beg;
        if (n > 0) {
            if (this.trace.enabled(4)) {
                this.trace.write(this.title + ": set segment length " + n);
            }
            this.buffer[this.seg_beg] = (byte)(n & 0xFF);
            this.buffer[this.seg_beg + 1] = (byte)(n >> 8 & 0xFF);
        }
    }
}

