/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import javax.transaction.xa.Xid;

public class XaXid
implements Xid {
    private int fid = 0;
    private byte[] gtid = null;
    private byte[] bqual = null;
    private int hash = 0;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public XaXid(Xid xid) {
        this(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public XaXid(int n, byte[] byArray, byte[] byArray2) {
        int n2;
        this.fid = n;
        this.gtid = new byte[byArray.length];
        this.bqual = new byte[byArray2.length];
        this.hash = n;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            this.gtid[n2] = byArray[n2];
            this.hash = (this.hash << 8 | this.hash >>> 24) ^ byArray[n2] & 0xFF;
        }
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            this.bqual[n2] = byArray2[n2];
            this.hash = (this.hash << 8 | this.hash >>> 24) ^ byArray2[n2] & 0xFF;
        }
    }

    @Override
    public int getFormatId() {
        return this.fid;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        byte[] byArray = new byte[this.gtid.length];
        System.arraycopy(this.gtid, 0, byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    public byte[] getBranchQualifier() {
        byte[] byArray = new byte[this.bqual.length];
        System.arraycopy(this.bqual, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("XID:XA:");
        stringBuffer.append(this.fid);
        stringBuffer.append(':');
        for (n = 0; n < this.gtid.length; ++n) {
            stringBuffer.append(hex[this.gtid[n] >> 4 & 0xF]);
            stringBuffer.append(hex[this.gtid[n] & 0xF]);
        }
        stringBuffer.append(':');
        for (n = 0; n < this.bqual.length; ++n) {
            stringBuffer.append(hex[this.bqual[n] >> 4 & 0xF]);
            stringBuffer.append(hex[this.bqual[n] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        int n;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Xid)) {
            return false;
        }
        Xid xid = (Xid)object;
        if (this.fid != xid.getFormatId()) {
            return false;
        }
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        if (this.gtid.length != byArray.length || this.bqual.length != byArray2.length) {
            return false;
        }
        for (n = 0; n < byArray.length; ++n) {
            if (this.gtid[n] == byArray[n]) continue;
            return false;
        }
        for (n = 0; n < byArray2.length; ++n) {
            if (this.bqual[n] == byArray2[n]) continue;
            return false;
        }
        return true;
    }
}

