/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.write.events;

import com.influxdb.client.write.events.AbstractWriteEvent;
import com.influxdb.utils.Arguments;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BackpressureEvent
extends AbstractWriteEvent {
    private final BackpressureReason reason;
    private final List<String> droppedLineProtocol;
    private static final Logger LOG = Logger.getLogger(BackpressureEvent.class.getName());

    public BackpressureEvent(@Nonnull BackpressureReason reason) {
        this(reason, null);
    }

    public BackpressureEvent(@Nonnull BackpressureReason reason, @Nullable List<String> droppedLineProtocol) {
        Arguments.checkNotNull((Object)((Object)reason), (String)"reason");
        this.reason = reason;
        this.droppedLineProtocol = droppedLineProtocol != null ? Collections.unmodifiableList(droppedLineProtocol) : Collections.emptyList();
    }

    @Override
    public void logEvent() {
        Object message = String.format("Backpressure[%s] applied, try increase WriteOptions.bufferLimit.", new Object[]{this.reason});
        if (!this.droppedLineProtocol.isEmpty()) {
            message = (String)message + String.format(" Buffer contains %d line protocol points.", this.droppedLineProtocol.size());
        }
        LOG.log(Level.WARNING, (String)message);
    }

    @Nonnull
    public BackpressureReason getReason() {
        return this.reason;
    }

    @Nonnull
    public List<String> getDroppedLineProtocol() {
        return this.droppedLineProtocol;
    }

    public static enum BackpressureReason {
        FAST_EMITTING,
        TOO_MUCH_BATCHES;

    }
}

