/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.service;

import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.ScraperTargetRequest;
import com.influxdb.client.domain.ScraperTargetResponse;
import com.influxdb.client.domain.ScraperTargetResponses;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ScraperTargetsService {
    @DELETE(value="api/v2/scrapers/{scraperTargetID}")
    public Call<Void> deleteScrapersID(@Path(value="scraperTargetID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @DELETE(value="api/v2/scrapers/{scraperTargetID}/labels/{labelID}")
    public Call<Void> deleteScrapersIDLabelsID(@Path(value="scraperTargetID") String var1, @Path(value="labelID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/scrapers/{scraperTargetID}/members/{userID}")
    public Call<Void> deleteScrapersIDMembersID(@Path(value="userID") String var1, @Path(value="scraperTargetID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/scrapers/{scraperTargetID}/owners/{userID}")
    public Call<Void> deleteScrapersIDOwnersID(@Path(value="userID") String var1, @Path(value="scraperTargetID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @GET(value="api/v2/scrapers")
    public Call<ScraperTargetResponses> getScrapers(@Header(value="Zap-Trace-Span") String var1, @Query(value="name") String var2, @Query(value="id") List<String> var3, @Query(value="orgID") String var4, @Query(value="org") String var5);

    @GET(value="api/v2/scrapers/{scraperTargetID}")
    public Call<ScraperTargetResponse> getScrapersID(@Path(value="scraperTargetID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/scrapers/{scraperTargetID}/labels")
    public Call<LabelsResponse> getScrapersIDLabels(@Path(value="scraperTargetID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/scrapers/{scraperTargetID}/members")
    public Call<ResourceMembers> getScrapersIDMembers(@Path(value="scraperTargetID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/scrapers/{scraperTargetID}/owners")
    public Call<ResourceOwners> getScrapersIDOwners(@Path(value="scraperTargetID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/v2/scrapers/{scraperTargetID}")
    public Call<ScraperTargetResponse> patchScrapersID(@Path(value="scraperTargetID") String var1, @Body ScraperTargetRequest var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/scrapers")
    public Call<ScraperTargetResponse> postScrapers(@Body ScraperTargetRequest var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/scrapers/{scraperTargetID}/labels")
    public Call<LabelResponse> postScrapersIDLabels(@Path(value="scraperTargetID") String var1, @Body LabelMapping var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/scrapers/{scraperTargetID}/members")
    public Call<ResourceMember> postScrapersIDMembers(@Path(value="scraperTargetID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/scrapers/{scraperTargetID}/owners")
    public Call<ResourceOwner> postScrapersIDOwners(@Path(value="scraperTargetID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);
}

