/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal.flowable;

import com.influxdb.client.internal.AbstractWriteClient;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.BackpressureOverflowStrategy;
import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class BackpressureBatchesBufferStrategy
implements FlowableOperator<AbstractWriteClient.BatchWriteItem, AbstractWriteClient.BatchWriteItem> {
    final long bufferSize;
    final Consumer<List<String>> onOverflow;
    final BackpressureOverflowStrategy strategy;
    final boolean captureBackpressureData;

    public BackpressureBatchesBufferStrategy(long bufferSize, Consumer<List<String>> onOverflow, BackpressureOverflowStrategy strategy) {
        this(bufferSize, onOverflow, strategy, false);
    }

    public BackpressureBatchesBufferStrategy(long bufferSize, Consumer<List<String>> onOverflow, BackpressureOverflowStrategy strategy, boolean captureBackpressureData) {
        this.bufferSize = bufferSize;
        this.onOverflow = onOverflow;
        this.strategy = strategy;
        this.captureBackpressureData = captureBackpressureData;
    }

    @NonNull
    public Subscriber<? super AbstractWriteClient.BatchWriteItem> apply(@NonNull Subscriber<? super AbstractWriteClient.BatchWriteItem> subscriber) throws Throwable {
        return new OnBackpressureBufferStrategySubscriber(subscriber, this.onOverflow, this.strategy, this.bufferSize, this.captureBackpressureData);
    }

    static final class OnBackpressureBufferStrategySubscriber
    extends AtomicInteger
    implements FlowableSubscriber<AbstractWriteClient.BatchWriteItem>,
    Subscription {
        private static final long serialVersionUID = 3240706908776709697L;
        final Subscriber<? super AbstractWriteClient.BatchWriteItem> downstream;
        final BackpressureOverflowStrategy strategy;
        final long bufferSize;
        final AtomicLong requested;
        final Deque<AbstractWriteClient.BatchWriteItem> deque;
        Subscription upstream;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        final Consumer<List<String>> onOverflow;
        final boolean captureBackpressureData;

        OnBackpressureBufferStrategySubscriber(Subscriber<? super AbstractWriteClient.BatchWriteItem> actual, Consumer<List<String>> onOverflow, BackpressureOverflowStrategy strategy, long bufferSize, boolean captureBackpressureData) {
            this.downstream = actual;
            this.onOverflow = onOverflow;
            this.strategy = strategy;
            this.bufferSize = bufferSize;
            this.captureBackpressureData = captureBackpressureData;
            this.requested = new AtomicLong();
            this.deque = new ArrayDeque<AbstractWriteClient.BatchWriteItem>();
        }

        public void onSubscribe(@NonNull Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(AbstractWriteClient.BatchWriteItem t) {
            if (this.done) {
                return;
            }
            boolean callOnOverflow = false;
            boolean callError = false;
            Deque<AbstractWriteClient.BatchWriteItem> dq = this.deque;
            List<String> overflowSnapshot = null;
            Deque<AbstractWriteClient.BatchWriteItem> deque = dq;
            synchronized (deque) {
                AtomicLong size = new AtomicLong(t.length());
                dq.forEach(batchWriteItem -> size.addAndGet(batchWriteItem.length()));
                if (size.get() > this.bufferSize) {
                    switch (this.strategy) {
                        case DROP_LATEST: {
                            if (this.captureBackpressureData) {
                                overflowSnapshot = this.captureBatch(t);
                            }
                            dq.pollLast();
                            dq.offer(t);
                            callOnOverflow = true;
                            break;
                        }
                        case DROP_OLDEST: {
                            AbstractWriteClient.BatchWriteItem droppedBatch = dq.poll();
                            if (this.captureBackpressureData) {
                                overflowSnapshot = this.captureBatch(droppedBatch);
                            }
                            dq.offer(t);
                            callOnOverflow = true;
                            break;
                        }
                        default: {
                            callError = true;
                            break;
                        }
                    }
                } else {
                    dq.offer(t);
                }
            }
            if (callOnOverflow) {
                if (this.onOverflow != null) {
                    try {
                        List<String> droppedPoints = this.captureBackpressureData ? overflowSnapshot : Collections.emptyList();
                        this.onOverflow.accept(droppedPoints);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        this.upstream.cancel();
                        this.onError(ex);
                    }
                }
            } else if (callError) {
                this.upstream.cancel();
                this.onError((Throwable)new MissingBackpressureException());
            } else {
                this.drain();
            }
        }

        List<String> captureBatch(AbstractWriteClient.BatchWriteItem item) {
            String lp = item.toLineProtocol();
            if (lp == null || lp.isEmpty()) {
                return Collections.emptyList();
            }
            return Arrays.stream(lp.split("\n")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            if (this.getAndIncrement() == 0) {
                this.clear(this.deque);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear(Deque<AbstractWriteClient.BatchWriteItem> dq) {
            Deque<AbstractWriteClient.BatchWriteItem> deque = dq;
            synchronized (deque) {
                dq.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Deque<AbstractWriteClient.BatchWriteItem> dq = this.deque;
            Subscriber<? super AbstractWriteClient.BatchWriteItem> a = this.downstream;
            do {
                boolean d;
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty2;
                    AbstractWriteClient.BatchWriteItem v;
                    if (this.cancelled) {
                        this.clear(dq);
                        return;
                    }
                    d = this.done;
                    Deque<AbstractWriteClient.BatchWriteItem> deque = dq;
                    synchronized (deque) {
                        v = dq.poll();
                    }
                    boolean bl = empty2 = v == null;
                    if (d) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.clear(dq);
                            a.onError(ex);
                            return;
                        }
                        if (empty2) {
                            a.onComplete();
                            return;
                        }
                    }
                    if (empty2) break;
                    a.onNext((Object)v);
                }
                if (e == r) {
                    boolean empty;
                    if (this.cancelled) {
                        this.clear(dq);
                        return;
                    }
                    d = this.done;
                    Deque<AbstractWriteClient.BatchWriteItem> empty2 = dq;
                    synchronized (empty2) {
                        empty = dq.isEmpty();
                    }
                    if (d) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.clear(dq);
                            a.onError(ex);
                            return;
                        }
                        if (empty) {
                            a.onComplete();
                            return;
                        }
                    }
                }
                if (e == 0L) continue;
                BackpressureHelper.produced((AtomicLong)this.requested, (long)e);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

