package com.impossibl.jdbc.spy;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

interface ConnectionListener {
  void createStatement(Statement targetSuccessResult, int resultSetType, int resultSetConcurrency);

  void createStatement(Throwable targetFailureCause, int resultSetType, int resultSetConcurrency);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql);

  void prepareStatement(Throwable targetFailureCause, String sql);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, String[] columnNames);

  void prepareStatement(Throwable targetFailureCause, String sql, String[] columnNames);

  void close();

  void close(Throwable targetFailureCause);

  void createSQLXML(SQLXML targetSuccessResult);

  void createSQLXML(Throwable targetFailureCause);

  void getTransactionIsolation(int targetSuccessResult);

  void getTransactionIsolation(Throwable targetFailureCause);

  void setSavepoint(Savepoint targetSuccessResult);

  void setSavepoint(Throwable targetFailureCause);

  void createClob(Clob targetSuccessResult);

  void createClob(Throwable targetFailureCause);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency);

  void prepareStatement(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency);

  void setClientInfo(Properties properties);

  void setClientInfo(Throwable targetFailureCause, Properties properties);

  void setClientInfo(String name, String value);

  void setClientInfo(Throwable targetFailureCause, String name, String value);

  void setSchema(String schema);

  void setSchema(Throwable targetFailureCause, String schema);

  void createBlob(Blob targetSuccessResult);

  void createBlob(Throwable targetFailureCause);

  void createArrayOf(Array targetSuccessResult, String typeName, Object[] elements);

  void createArrayOf(Throwable targetFailureCause, String typeName, Object[] elements);

  void getClientInfo(Properties targetSuccessResult);

  void getClientInfo(Throwable targetFailureCause);

  <T> void unwrap(T targetSuccessResult, Class<T> iface);

  <T> void unwrap(Throwable targetFailureCause, Class<T> iface);

  void getCatalog(String targetSuccessResult);

  void getCatalog(Throwable targetFailureCause);

  void prepareCall(CallableStatement targetSuccessResult, String sql);

  void prepareCall(Throwable targetFailureCause, String sql);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int autoGeneratedKeys);

  void prepareStatement(Throwable targetFailureCause, String sql, int autoGeneratedKeys);

  void prepareCall(CallableStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency);

  void prepareCall(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency);

  void getSchema(String targetSuccessResult);

  void getSchema(Throwable targetFailureCause);

  void isWrapperFor(boolean targetSuccessResult, Class<?> iface);

  void isWrapperFor(Throwable targetFailureCause, Class<?> iface);

  void nativeSQL(String targetSuccessResult, String sql);

  void nativeSQL(Throwable targetFailureCause, String sql);

  void isClosed(boolean targetSuccessResult);

  void isClosed(Throwable targetFailureCause);

  void getAutoCommit(boolean targetSuccessResult);

  void getAutoCommit(Throwable targetFailureCause);

  void createNClob(NClob targetSuccessResult);

  void createNClob(Throwable targetFailureCause);

  void setReadOnly(boolean readOnly);

  void setReadOnly(Throwable targetFailureCause, boolean readOnly);

  void getHoldability(int targetSuccessResult);

  void getHoldability(Throwable targetFailureCause);

  void getWarnings(SQLWarning targetSuccessResult);

  void getWarnings(Throwable targetFailureCause);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void prepareStatement(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void setAutoCommit(boolean autoCommit);

  void setAutoCommit(Throwable targetFailureCause, boolean autoCommit);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int[] columnIndexes);

  void prepareStatement(Throwable targetFailureCause, String sql, int[] columnIndexes);

  void setSavepoint(Savepoint targetSuccessResult, String name);

  void setSavepoint(Throwable targetFailureCause, String name);

  void setTransactionIsolation(int level);

  void setTransactionIsolation(Throwable targetFailureCause, int level);

  void createStatement(Statement targetSuccessResult, int resultSetType, int resultSetConcurrency,
      int resultSetHoldability);

  void createStatement(Throwable targetFailureCause, int resultSetType, int resultSetConcurrency,
      int resultSetHoldability);

  void createStatement(Statement targetSuccessResult);

  void createStatement(Throwable targetFailureCause);

  void setNetworkTimeout(Executor executor, int milliseconds);

  void setNetworkTimeout(Throwable targetFailureCause, Executor executor, int milliseconds);

  void getTypeMap(Map<String, Class<?>> targetSuccessResult);

  void getTypeMap(Throwable targetFailureCause);

  void prepareCall(CallableStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void prepareCall(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void getNetworkTimeout(int targetSuccessResult);

  void getNetworkTimeout(Throwable targetFailureCause);

  void clearWarnings();

  void clearWarnings(Throwable targetFailureCause);

  void getMetaData(DatabaseMetaData targetSuccessResult);

  void getMetaData(Throwable targetFailureCause);

  void commit();

  void commit(Throwable targetFailureCause);

  void setTypeMap(Map<String, Class<?>> map);

  void setTypeMap(Throwable targetFailureCause, Map<String, Class<?>> map);

  void createStruct(Struct targetSuccessResult, String typeName, Object[] attributes);

  void createStruct(Throwable targetFailureCause, String typeName, Object[] attributes);

  void setCatalog(String catalog);

  void setCatalog(Throwable targetFailureCause, String catalog);

  void rollback(Savepoint savepoint);

  void rollback(Throwable targetFailureCause, Savepoint savepoint);

  void abort(Executor executor);

  void abort(Throwable targetFailureCause, Executor executor);

  void rollback();

  void rollback(Throwable targetFailureCause);

  void isReadOnly(boolean targetSuccessResult);

  void isReadOnly(Throwable targetFailureCause);

  void setHoldability(int holdability);

  void setHoldability(Throwable targetFailureCause, int holdability);

  void getClientInfo(String targetSuccessResult, String name);

  void getClientInfo(Throwable targetFailureCause, String name);

  void releaseSavepoint(Savepoint savepoint);

  void releaseSavepoint(Throwable targetFailureCause, Savepoint savepoint);

  void isValid(boolean targetSuccessResult, int timeout);

  void isValid(Throwable targetFailureCause, int timeout);

  StatementListener newStatementListener();

  PreparedStatementListener newPreparedStatementListener();

  SQLXMLListener newSQLXMLListener();

  SavepointListener newSavepointListener();

  ClobListener newClobListener();

  BlobListener newBlobListener();

  ArrayListener newArrayListener();

  CallableStatementListener newCallableStatementListener();

  NClobListener newNClobListener();

  DatabaseMetaDataListener newDatabaseMetaDataListener();

  StructListener newStructListener();
}
