package com.impossibl.jdbc.spy;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLWarning;

public class StatementTracer implements StatementListener {
  TraceOutput out;

  public StatementTracer(TraceOutput out) {
    this.out = out;
  }

  public void trace(Trace trace) {
    this.out.trace(trace);
  }

  public void setEscapeProcessing(boolean enable) {
    trace(new Trace.Builder("Statement", "setEscapeProcessing")
        .withParameter("enable", enable)
        .returned()
        .build());
  }

  public void setEscapeProcessing(Throwable cause, boolean enable) {
    trace(new Trace.Builder("Statement", "setEscapeProcessing")
        .withParameter("enable", enable)
        .threw(cause)
        .build());
  }

  public void getUpdateCount(int result) {
    trace(new Trace.Builder("Statement", "getUpdateCount")
        .returned(result)
        .build());
  }

  public void getUpdateCount(Throwable cause) {
    trace(new Trace.Builder("Statement", "getUpdateCount")
        .threw(cause)
        .build());
  }

  public void clearBatch() {
    trace(new Trace.Builder("Statement", "clearBatch")
        .returned()
        .build());
  }

  public void clearBatch(Throwable cause) {
    trace(new Trace.Builder("Statement", "clearBatch")
        .threw(cause)
        .build());
  }

  public void getFetchSize(int result) {
    trace(new Trace.Builder("Statement", "getFetchSize")
        .returned(result)
        .build());
  }

  public void getFetchSize(Throwable cause) {
    trace(new Trace.Builder("Statement", "getFetchSize")
        .threw(cause)
        .build());
  }

  public void getWarnings(SQLWarning result) {
    trace(new Trace.Builder("Statement", "getWarnings")
        .returned(result)
        .build());
  }

  public void getWarnings(Throwable cause) {
    trace(new Trace.Builder("Statement", "getWarnings")
        .threw(cause)
        .build());
  }

  public void clearWarnings() {
    trace(new Trace.Builder("Statement", "clearWarnings")
        .returned()
        .build());
  }

  public void clearWarnings(Throwable cause) {
    trace(new Trace.Builder("Statement", "clearWarnings")
        .threw(cause)
        .build());
  }

  public void getMoreResults(boolean result) {
    trace(new Trace.Builder("Statement", "getMoreResults")
        .returned(result)
        .build());
  }

  public void getMoreResults(Throwable cause) {
    trace(new Trace.Builder("Statement", "getMoreResults")
        .threw(cause)
        .build());
  }

  public void getResultSetType(int result) {
    trace(new Trace.Builder("Statement", "getResultSetType")
        .returned(result)
        .build());
  }

  public void getResultSetType(Throwable cause) {
    trace(new Trace.Builder("Statement", "getResultSetType")
        .threw(cause)
        .build());
  }

  public void execute(boolean result, String sql) {
    trace(new Trace.Builder("Statement", "execute")
        .withParameter("sql", sql)
        .returned(result)
        .build());
  }

  public void execute(Throwable cause, String sql) {
    trace(new Trace.Builder("Statement", "execute")
        .withParameter("sql", sql)
        .threw(cause)
        .build());
  }

  public void getResultSetHoldability(int result) {
    trace(new Trace.Builder("Statement", "getResultSetHoldability")
        .returned(result)
        .build());
  }

  public void getResultSetHoldability(Throwable cause) {
    trace(new Trace.Builder("Statement", "getResultSetHoldability")
        .threw(cause)
        .build());
  }

  public void executeLargeUpdate(long result, String sql) {
    trace(new Trace.Builder("Statement", "executeLargeUpdate")
        .withParameter("sql", sql)
        .returned(result)
        .build());
  }

  public void executeLargeUpdate(Throwable cause, String sql) {
    trace(new Trace.Builder("Statement", "executeLargeUpdate")
        .withParameter("sql", sql)
        .threw(cause)
        .build());
  }

  public void getGeneratedKeys(ResultSet result) {
    trace(new Trace.Builder("Statement", "getGeneratedKeys")
        .returned(result)
        .build());
  }

  public void getGeneratedKeys(Throwable cause) {
    trace(new Trace.Builder("Statement", "getGeneratedKeys")
        .threw(cause)
        .build());
  }

  public void getLargeMaxRows(long result) {
    trace(new Trace.Builder("Statement", "getLargeMaxRows")
        .returned(result)
        .build());
  }

  public void getLargeMaxRows(Throwable cause) {
    trace(new Trace.Builder("Statement", "getLargeMaxRows")
        .threw(cause)
        .build());
  }

  public void executeUpdate(int result, String sql, int autoGeneratedKeys) {
    trace(new Trace.Builder("Statement", "executeUpdate")
        .withParameter("sql", sql)
        .withParameter("autoGeneratedKeys", autoGeneratedKeys)
        .returned(result)
        .build());
  }

  public void executeUpdate(Throwable cause, String sql, int autoGeneratedKeys) {
    trace(new Trace.Builder("Statement", "executeUpdate")
        .withParameter("sql", sql)
        .withParameter("autoGeneratedKeys", autoGeneratedKeys)
        .threw(cause)
        .build());
  }

  public void executeLargeUpdate(long result, String sql, String[] columnNames) {
    trace(new Trace.Builder("Statement", "executeLargeUpdate")
        .withParameter("sql", sql)
        .withParameter("columnNames", columnNames)
        .returned(result)
        .build());
  }

  public void executeLargeUpdate(Throwable cause, String sql, String[] columnNames) {
    trace(new Trace.Builder("Statement", "executeLargeUpdate")
        .withParameter("sql", sql)
        .withParameter("columnNames", columnNames)
        .threw(cause)
        .build());
  }

  public void executeUpdate(int result, String sql, int[] columnIndexes) {
    trace(new Trace.Builder("Statement", "executeUpdate")
        .withParameter("sql", sql)
        .withParameter("columnIndexes", columnIndexes)
        .returned(result)
        .build());
  }

  public void executeUpdate(Throwable cause, String sql, int[] columnIndexes) {
    trace(new Trace.Builder("Statement", "executeUpdate")
        .withParameter("sql", sql)
        .withParameter("columnIndexes", columnIndexes)
        .threw(cause)
        .build());
  }

  public void executeUpdate(int result, String sql) {
    trace(new Trace.Builder("Statement", "executeUpdate")
        .withParameter("sql", sql)
        .returned(result)
        .build());
  }

  public void executeUpdate(Throwable cause, String sql) {
    trace(new Trace.Builder("Statement", "executeUpdate")
        .withParameter("sql", sql)
        .threw(cause)
        .build());
  }

  public void isClosed(boolean result) {
    trace(new Trace.Builder("Statement", "isClosed")
        .returned(result)
        .build());
  }

  public void isClosed(Throwable cause) {
    trace(new Trace.Builder("Statement", "isClosed")
        .threw(cause)
        .build());
  }

  public void isCloseOnCompletion(boolean result) {
    trace(new Trace.Builder("Statement", "isCloseOnCompletion")
        .returned(result)
        .build());
  }

  public void isCloseOnCompletion(Throwable cause) {
    trace(new Trace.Builder("Statement", "isCloseOnCompletion")
        .threw(cause)
        .build());
  }

  public void setPoolable(boolean poolable) {
    trace(new Trace.Builder("Statement", "setPoolable")
        .withParameter("poolable", poolable)
        .returned()
        .build());
  }

  public void setPoolable(Throwable cause, boolean poolable) {
    trace(new Trace.Builder("Statement", "setPoolable")
        .withParameter("poolable", poolable)
        .threw(cause)
        .build());
  }

  public void getLargeUpdateCount(long result) {
    trace(new Trace.Builder("Statement", "getLargeUpdateCount")
        .returned(result)
        .build());
  }

  public void getLargeUpdateCount(Throwable cause) {
    trace(new Trace.Builder("Statement", "getLargeUpdateCount")
        .threw(cause)
        .build());
  }

  public void addBatch(String sql) {
    trace(new Trace.Builder("Statement", "addBatch")
        .withParameter("sql", sql)
        .returned()
        .build());
  }

  public void addBatch(Throwable cause, String sql) {
    trace(new Trace.Builder("Statement", "addBatch")
        .withParameter("sql", sql)
        .threw(cause)
        .build());
  }

  public void getConnection(Connection result) {
    trace(new Trace.Builder("Statement", "getConnection")
        .returned(result)
        .build());
  }

  public void getConnection(Throwable cause) {
    trace(new Trace.Builder("Statement", "getConnection")
        .threw(cause)
        .build());
  }

  public void executeLargeUpdate(long result, String sql, int[] columnIndexes) {
    trace(new Trace.Builder("Statement", "executeLargeUpdate")
        .withParameter("sql", sql)
        .withParameter("columnIndexes", columnIndexes)
        .returned(result)
        .build());
  }

  public void executeLargeUpdate(Throwable cause, String sql, int[] columnIndexes) {
    trace(new Trace.Builder("Statement", "executeLargeUpdate")
        .withParameter("sql", sql)
        .withParameter("columnIndexes", columnIndexes)
        .threw(cause)
        .build());
  }

  public void close() {
    trace(new Trace.Builder("Statement", "close")
        .returned()
        .build());
  }

  public void close(Throwable cause) {
    trace(new Trace.Builder("Statement", "close")
        .threw(cause)
        .build());
  }

  public void cancel() {
    trace(new Trace.Builder("Statement", "cancel")
        .returned()
        .build());
  }

  public void cancel(Throwable cause) {
    trace(new Trace.Builder("Statement", "cancel")
        .threw(cause)
        .build());
  }

  public void isWrapperFor(boolean result, Class<?> iface) {
    trace(new Trace.Builder("Statement", "isWrapperFor")
        .withParameter("iface", iface)
        .returned(result)
        .build());
  }

  public void isWrapperFor(Throwable cause, Class<?> iface) {
    trace(new Trace.Builder("Statement", "isWrapperFor")
        .withParameter("iface", iface)
        .threw(cause)
        .build());
  }

  public void execute(boolean result, String sql, int[] columnIndexes) {
    trace(new Trace.Builder("Statement", "execute")
        .withParameter("sql", sql)
        .withParameter("columnIndexes", columnIndexes)
        .returned(result)
        .build());
  }

  public void execute(Throwable cause, String sql, int[] columnIndexes) {
    trace(new Trace.Builder("Statement", "execute")
        .withParameter("sql", sql)
        .withParameter("columnIndexes", columnIndexes)
        .threw(cause)
        .build());
  }

  public <T> void unwrap(T result, Class<T> iface) {
    trace(new Trace.Builder("Statement", "unwrap")
        .withParameter("iface", iface)
        .returned(result)
        .build());
  }

  public <T> void unwrap(Throwable cause, Class<T> iface) {
    trace(new Trace.Builder("Statement", "unwrap")
        .withParameter("iface", iface)
        .threw(cause)
        .build());
  }

  public void getQueryTimeout(int result) {
    trace(new Trace.Builder("Statement", "getQueryTimeout")
        .returned(result)
        .build());
  }

  public void getQueryTimeout(Throwable cause) {
    trace(new Trace.Builder("Statement", "getQueryTimeout")
        .threw(cause)
        .build());
  }

  public void closeOnCompletion() {
    trace(new Trace.Builder("Statement", "closeOnCompletion")
        .returned()
        .build());
  }

  public void closeOnCompletion(Throwable cause) {
    trace(new Trace.Builder("Statement", "closeOnCompletion")
        .threw(cause)
        .build());
  }

  public void getMoreResults(boolean result, int current) {
    trace(new Trace.Builder("Statement", "getMoreResults")
        .withParameter("current", current)
        .returned(result)
        .build());
  }

  public void getMoreResults(Throwable cause, int current) {
    trace(new Trace.Builder("Statement", "getMoreResults")
        .withParameter("current", current)
        .threw(cause)
        .build());
  }

  public void executeLargeUpdate(long result, String sql, int autoGeneratedKeys) {
    trace(new Trace.Builder("Statement", "executeLargeUpdate")
        .withParameter("sql", sql)
        .withParameter("autoGeneratedKeys", autoGeneratedKeys)
        .returned(result)
        .build());
  }

  public void executeLargeUpdate(Throwable cause, String sql, int autoGeneratedKeys) {
    trace(new Trace.Builder("Statement", "executeLargeUpdate")
        .withParameter("sql", sql)
        .withParameter("autoGeneratedKeys", autoGeneratedKeys)
        .threw(cause)
        .build());
  }

  public void setFetchDirection(int direction) {
    trace(new Trace.Builder("Statement", "setFetchDirection")
        .withParameter("direction", direction)
        .returned()
        .build());
  }

  public void setFetchDirection(Throwable cause, int direction) {
    trace(new Trace.Builder("Statement", "setFetchDirection")
        .withParameter("direction", direction)
        .threw(cause)
        .build());
  }

  public void executeUpdate(int result, String sql, String[] columnNames) {
    trace(new Trace.Builder("Statement", "executeUpdate")
        .withParameter("sql", sql)
        .withParameter("columnNames", columnNames)
        .returned(result)
        .build());
  }

  public void executeUpdate(Throwable cause, String sql, String[] columnNames) {
    trace(new Trace.Builder("Statement", "executeUpdate")
        .withParameter("sql", sql)
        .withParameter("columnNames", columnNames)
        .threw(cause)
        .build());
  }

  public void isPoolable(boolean result) {
    trace(new Trace.Builder("Statement", "isPoolable")
        .returned(result)
        .build());
  }

  public void isPoolable(Throwable cause) {
    trace(new Trace.Builder("Statement", "isPoolable")
        .threw(cause)
        .build());
  }

  public void setCursorName(String name) {
    trace(new Trace.Builder("Statement", "setCursorName")
        .withParameter("name", name)
        .returned()
        .build());
  }

  public void setCursorName(Throwable cause, String name) {
    trace(new Trace.Builder("Statement", "setCursorName")
        .withParameter("name", name)
        .threw(cause)
        .build());
  }

  public void getFetchDirection(int result) {
    trace(new Trace.Builder("Statement", "getFetchDirection")
        .returned(result)
        .build());
  }

  public void getFetchDirection(Throwable cause) {
    trace(new Trace.Builder("Statement", "getFetchDirection")
        .threw(cause)
        .build());
  }

  public void setLargeMaxRows(long max) {
    trace(new Trace.Builder("Statement", "setLargeMaxRows")
        .withParameter("max", max)
        .returned()
        .build());
  }

  public void setLargeMaxRows(Throwable cause, long max) {
    trace(new Trace.Builder("Statement", "setLargeMaxRows")
        .withParameter("max", max)
        .threw(cause)
        .build());
  }

  public void getResultSet(ResultSet result) {
    trace(new Trace.Builder("Statement", "getResultSet")
        .returned(result)
        .build());
  }

  public void getResultSet(Throwable cause) {
    trace(new Trace.Builder("Statement", "getResultSet")
        .threw(cause)
        .build());
  }

  public void execute(boolean result, String sql, String[] columnNames) {
    trace(new Trace.Builder("Statement", "execute")
        .withParameter("sql", sql)
        .withParameter("columnNames", columnNames)
        .returned(result)
        .build());
  }

  public void execute(Throwable cause, String sql, String[] columnNames) {
    trace(new Trace.Builder("Statement", "execute")
        .withParameter("sql", sql)
        .withParameter("columnNames", columnNames)
        .threw(cause)
        .build());
  }

  public void setQueryTimeout(int seconds) {
    trace(new Trace.Builder("Statement", "setQueryTimeout")
        .withParameter("seconds", seconds)
        .returned()
        .build());
  }

  public void setQueryTimeout(Throwable cause, int seconds) {
    trace(new Trace.Builder("Statement", "setQueryTimeout")
        .withParameter("seconds", seconds)
        .threw(cause)
        .build());
  }

  public void setFetchSize(int rows) {
    trace(new Trace.Builder("Statement", "setFetchSize")
        .withParameter("rows", rows)
        .returned()
        .build());
  }

  public void setFetchSize(Throwable cause, int rows) {
    trace(new Trace.Builder("Statement", "setFetchSize")
        .withParameter("rows", rows)
        .threw(cause)
        .build());
  }

  public void setMaxRows(int max) {
    trace(new Trace.Builder("Statement", "setMaxRows")
        .withParameter("max", max)
        .returned()
        .build());
  }

  public void setMaxRows(Throwable cause, int max) {
    trace(new Trace.Builder("Statement", "setMaxRows")
        .withParameter("max", max)
        .threw(cause)
        .build());
  }

  public void getMaxFieldSize(int result) {
    trace(new Trace.Builder("Statement", "getMaxFieldSize")
        .returned(result)
        .build());
  }

  public void getMaxFieldSize(Throwable cause) {
    trace(new Trace.Builder("Statement", "getMaxFieldSize")
        .threw(cause)
        .build());
  }

  public void executeQuery(ResultSet result, String sql) {
    trace(new Trace.Builder("Statement", "executeQuery")
        .withParameter("sql", sql)
        .returned(result)
        .build());
  }

  public void executeQuery(Throwable cause, String sql) {
    trace(new Trace.Builder("Statement", "executeQuery")
        .withParameter("sql", sql)
        .threw(cause)
        .build());
  }

  public void execute(boolean result, String sql, int autoGeneratedKeys) {
    trace(new Trace.Builder("Statement", "execute")
        .withParameter("sql", sql)
        .withParameter("autoGeneratedKeys", autoGeneratedKeys)
        .returned(result)
        .build());
  }

  public void execute(Throwable cause, String sql, int autoGeneratedKeys) {
    trace(new Trace.Builder("Statement", "execute")
        .withParameter("sql", sql)
        .withParameter("autoGeneratedKeys", autoGeneratedKeys)
        .threw(cause)
        .build());
  }

  public void getMaxRows(int result) {
    trace(new Trace.Builder("Statement", "getMaxRows")
        .returned(result)
        .build());
  }

  public void getMaxRows(Throwable cause) {
    trace(new Trace.Builder("Statement", "getMaxRows")
        .threw(cause)
        .build());
  }

  public void executeLargeBatch(long[] result) {
    trace(new Trace.Builder("Statement", "executeLargeBatch")
        .returned(result)
        .build());
  }

  public void executeLargeBatch(Throwable cause) {
    trace(new Trace.Builder("Statement", "executeLargeBatch")
        .threw(cause)
        .build());
  }

  public void executeBatch(int[] result) {
    trace(new Trace.Builder("Statement", "executeBatch")
        .returned(result)
        .build());
  }

  public void executeBatch(Throwable cause) {
    trace(new Trace.Builder("Statement", "executeBatch")
        .threw(cause)
        .build());
  }

  public void getResultSetConcurrency(int result) {
    trace(new Trace.Builder("Statement", "getResultSetConcurrency")
        .returned(result)
        .build());
  }

  public void getResultSetConcurrency(Throwable cause) {
    trace(new Trace.Builder("Statement", "getResultSetConcurrency")
        .threw(cause)
        .build());
  }

  public void setMaxFieldSize(int max) {
    trace(new Trace.Builder("Statement", "setMaxFieldSize")
        .withParameter("max", max)
        .returned()
        .build());
  }

  public void setMaxFieldSize(Throwable cause, int max) {
    trace(new Trace.Builder("Statement", "setMaxFieldSize")
        .withParameter("max", max)
        .threw(cause)
        .build());
  }

  public ResultSetListener newResultSetListener() {
    return new ResultSetTracer(out);
  }

  public ConnectionListener newConnectionListener() {
    return new ConnectionTracer(out);
  }
}
