package com.impossibl.jdbc.spy;

import java.sql.Connection;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;

interface PooledConnectionListener {
  void close();

  void close(Throwable targetFailureCause);

  void addStatementEventListener(StatementEventListener listener);

  void addStatementEventListener(Throwable targetFailureCause, StatementEventListener listener);

  void getConnection(Connection targetSuccessResult);

  void getConnection(Throwable targetFailureCause);

  void removeStatementEventListener(StatementEventListener listener);

  void removeStatementEventListener(Throwable targetFailureCause, StatementEventListener listener);

  void addConnectionEventListener(ConnectionEventListener listener);

  void addConnectionEventListener(Throwable targetFailureCause, ConnectionEventListener listener);

  void removeConnectionEventListener(ConnectionEventListener listener);

  void removeConnectionEventListener(Throwable targetFailureCause,
      ConnectionEventListener listener);

  ConnectionListener newConnectionListener();
}
