package com.impossibl.jdbc.spy;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

interface ConnectionListener {
  void prepareStatement(PreparedStatement targetSuccessResult, String sql);

  void prepareStatement(Throwable targetFailureCause, String sql);

  void getCatalog(String targetSuccessResult);

  void getCatalog(Throwable targetFailureCause);

  void getNetworkTimeout(int targetSuccessResult);

  void getNetworkTimeout(Throwable targetFailureCause);

  void setHoldability(int holdability);

  void setHoldability(Throwable targetFailureCause, int holdability);

  void prepareCall(CallableStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency);

  void prepareCall(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency);

  void createNClob(NClob targetSuccessResult);

  void createNClob(Throwable targetFailureCause);

  void setClientInfo(Properties properties);

  void setClientInfo(Throwable targetFailureCause, Properties properties);

  void setCatalog(String catalog);

  void setCatalog(Throwable targetFailureCause, String catalog);

  void getAutoCommit(boolean targetSuccessResult);

  void getAutoCommit(Throwable targetFailureCause);

  void rollback();

  void rollback(Throwable targetFailureCause);

  void rollback(Savepoint savepoint);

  void rollback(Throwable targetFailureCause, Savepoint savepoint);

  void commit();

  void commit(Throwable targetFailureCause);

  void setSavepoint(Savepoint targetSuccessResult, String name);

  void setSavepoint(Throwable targetFailureCause, String name);

  void setClientInfo(String name, String value);

  void setClientInfo(Throwable targetFailureCause, String name, String value);

  void setTypeMap(Map<String, Class<?>> map);

  void setTypeMap(Throwable targetFailureCause, Map<String, Class<?>> map);

  void isWrapperFor(boolean targetSuccessResult, Class<?> iface);

  void isWrapperFor(Throwable targetFailureCause, Class<?> iface);

  void isReadOnly(boolean targetSuccessResult);

  void isReadOnly(Throwable targetFailureCause);

  void getClientInfo(Properties targetSuccessResult);

  void getClientInfo(Throwable targetFailureCause);

  void nativeSQL(String targetSuccessResult, String sql);

  void nativeSQL(Throwable targetFailureCause, String sql);

  void createStruct(Struct targetSuccessResult, String typeName, Object[] attributes);

  void createStruct(Throwable targetFailureCause, String typeName, Object[] attributes);

  void getWarnings(SQLWarning targetSuccessResult);

  void getWarnings(Throwable targetFailureCause);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int autoGeneratedKeys);

  void prepareStatement(Throwable targetFailureCause, String sql, int autoGeneratedKeys);

  void createBlob(Blob targetSuccessResult);

  void createBlob(Throwable targetFailureCause);

  void createArrayOf(Array targetSuccessResult, String typeName, Object[] elements);

  void createArrayOf(Throwable targetFailureCause, String typeName, Object[] elements);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void prepareStatement(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  <T> void unwrap(T targetSuccessResult, Class<T> iface);

  <T> void unwrap(Throwable targetFailureCause, Class<T> iface);

  void setAutoCommit(boolean autoCommit);

  void setAutoCommit(Throwable targetFailureCause, boolean autoCommit);

  void createStatement(Statement targetSuccessResult, int resultSetType, int resultSetConcurrency,
      int resultSetHoldability);

  void createStatement(Throwable targetFailureCause, int resultSetType, int resultSetConcurrency,
      int resultSetHoldability);

  void createStatement(Statement targetSuccessResult);

  void createStatement(Throwable targetFailureCause);

  void prepareCall(CallableStatement targetSuccessResult, String sql);

  void prepareCall(Throwable targetFailureCause, String sql);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, String[] columnNames);

  void prepareStatement(Throwable targetFailureCause, String sql, String[] columnNames);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency);

  void prepareStatement(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency);

  void setSavepoint(Savepoint targetSuccessResult);

  void setSavepoint(Throwable targetFailureCause);

  void abort(Executor executor);

  void abort(Throwable targetFailureCause, Executor executor);

  void isValid(boolean targetSuccessResult, int timeout);

  void isValid(Throwable targetFailureCause, int timeout);

  void prepareCall(CallableStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void prepareCall(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void setReadOnly(boolean readOnly);

  void setReadOnly(Throwable targetFailureCause, boolean readOnly);

  void setSchema(String schema);

  void setSchema(Throwable targetFailureCause, String schema);

  void setNetworkTimeout(Executor executor, int milliseconds);

  void setNetworkTimeout(Throwable targetFailureCause, Executor executor, int milliseconds);

  void getTypeMap(Map<String, Class<?>> targetSuccessResult);

  void getTypeMap(Throwable targetFailureCause);

  void isClosed(boolean targetSuccessResult);

  void isClosed(Throwable targetFailureCause);

  void getClientInfo(String targetSuccessResult, String name);

  void getClientInfo(Throwable targetFailureCause, String name);

  void releaseSavepoint(Savepoint savepoint);

  void releaseSavepoint(Throwable targetFailureCause, Savepoint savepoint);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int[] columnIndexes);

  void prepareStatement(Throwable targetFailureCause, String sql, int[] columnIndexes);

  void setTransactionIsolation(int level);

  void setTransactionIsolation(Throwable targetFailureCause, int level);

  void close();

  void close(Throwable targetFailureCause);

  void createSQLXML(SQLXML targetSuccessResult);

  void createSQLXML(Throwable targetFailureCause);

  void getSchema(String targetSuccessResult);

  void getSchema(Throwable targetFailureCause);

  void getTransactionIsolation(int targetSuccessResult);

  void getTransactionIsolation(Throwable targetFailureCause);

  void createStatement(Statement targetSuccessResult, int resultSetType, int resultSetConcurrency);

  void createStatement(Throwable targetFailureCause, int resultSetType, int resultSetConcurrency);

  void getMetaData(DatabaseMetaData targetSuccessResult);

  void getMetaData(Throwable targetFailureCause);

  void clearWarnings();

  void clearWarnings(Throwable targetFailureCause);

  void getHoldability(int targetSuccessResult);

  void getHoldability(Throwable targetFailureCause);

  void createClob(Clob targetSuccessResult);

  void createClob(Throwable targetFailureCause);

  PreparedStatementListener newPreparedStatementListener();

  CallableStatementListener newCallableStatementListener();

  NClobListener newNClobListener();

  SavepointListener newSavepointListener();

  StructListener newStructListener();

  BlobListener newBlobListener();

  ArrayListener newArrayListener();

  StatementListener newStatementListener();

  SQLXMLListener newSQLXMLListener();

  DatabaseMetaDataListener newDatabaseMetaDataListener();

  ClobListener newClobListener();
}
