package com.impossibl.jdbc.spy;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

interface CallableStatementListener {
  void getString(String targetSuccessResult, int parameterIndex);

  void getString(Throwable targetFailureCause, int parameterIndex);

  void setBlob(int parameterIndex, Blob x);

  void setBlob(Throwable targetFailureCause, int parameterIndex, Blob x);

  void getObject(Object targetSuccessResult, int parameterIndex);

  void getObject(Throwable targetFailureCause, int parameterIndex);

  void getMoreResults(boolean targetSuccessResult, int current);

  void getMoreResults(Throwable targetFailureCause, int current);

  void setBlob(String parameterName, InputStream inputStream);

  void setBlob(Throwable targetFailureCause, String parameterName, InputStream inputStream);

  void registerOutParameter(String parameterName, SQLType sqlType, String typeName);

  void registerOutParameter(Throwable targetFailureCause, String parameterName, SQLType sqlType,
      String typeName);

  void isPoolable(boolean targetSuccessResult);

  void isPoolable(Throwable targetFailureCause);

  void setNClob(String parameterName, NClob value);

  void setNClob(Throwable targetFailureCause, String parameterName, NClob value);

  void getFetchSize(int targetSuccessResult);

  void getFetchSize(Throwable targetFailureCause);

  void getResultSetHoldability(int targetSuccessResult);

  void getResultSetHoldability(Throwable targetFailureCause);

  void cancel();

  void cancel(Throwable targetFailureCause);

  void setInt(int parameterIndex, int x);

  void setInt(Throwable targetFailureCause, int parameterIndex, int x);

  void setLong(String parameterName, long x);

  void setLong(Throwable targetFailureCause, String parameterName, long x);

  void setObject(int parameterIndex, Object x, SQLType targetSqlType);

  void setObject(Throwable targetFailureCause, int parameterIndex, Object x, SQLType targetSqlType);

  void registerOutParameter(String parameterName, SQLType sqlType, int scale);

  void registerOutParameter(Throwable targetFailureCause, String parameterName, SQLType sqlType,
      int scale);

  void executeQuery(ResultSet targetSuccessResult, String sql);

  void executeQuery(Throwable targetFailureCause, String sql);

  void getNString(String targetSuccessResult, String parameterName);

  void getNString(Throwable targetFailureCause, String parameterName);

  void getNCharacterStream(Reader targetSuccessResult, int parameterIndex);

  void getNCharacterStream(Throwable targetFailureCause, int parameterIndex);

  void registerOutParameter(int parameterIndex, int sqlType);

  void registerOutParameter(Throwable targetFailureCause, int parameterIndex, int sqlType);

  void setAsciiStream(String parameterName, InputStream x);

  void setAsciiStream(Throwable targetFailureCause, String parameterName, InputStream x);

  void addBatch(String sql);

  void addBatch(Throwable targetFailureCause, String sql);

  void setShort(int parameterIndex, short x);

  void setShort(Throwable targetFailureCause, int parameterIndex, short x);

  void getTimestamp(Timestamp targetSuccessResult, String parameterName, Calendar cal);

  void getTimestamp(Throwable targetFailureCause, String parameterName, Calendar cal);

  void getBytes(byte[] targetSuccessResult, int parameterIndex);

  void getBytes(Throwable targetFailureCause, int parameterIndex);

  void setCharacterStream(String parameterName, Reader reader, int length);

  void setCharacterStream(Throwable targetFailureCause, String parameterName, Reader reader,
      int length);

  void isClosed(boolean targetSuccessResult);

  void isClosed(Throwable targetFailureCause);

  void getRef(Ref targetSuccessResult, int parameterIndex);

  void getRef(Throwable targetFailureCause, int parameterIndex);

  void clearParameters();

  void clearParameters(Throwable targetFailureCause);

  void setRowId(String parameterName, RowId x);

  void setRowId(Throwable targetFailureCause, String parameterName, RowId x);

  void getInt(int targetSuccessResult, String parameterName);

  void getInt(Throwable targetFailureCause, String parameterName);

  void setCharacterStream(String parameterName, Reader reader, long length);

  void setCharacterStream(Throwable targetFailureCause, String parameterName, Reader reader,
      long length);

  void getFetchDirection(int targetSuccessResult);

  void getFetchDirection(Throwable targetFailureCause);

  void setBlob(String parameterName, Blob x);

  void setBlob(Throwable targetFailureCause, String parameterName, Blob x);

  void getByte(byte targetSuccessResult, String parameterName);

  void getByte(Throwable targetFailureCause, String parameterName);

  void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName);

  void registerOutParameter(Throwable targetFailureCause, int parameterIndex, SQLType sqlType,
      String typeName);

  void setTimestamp(String parameterName, Timestamp x);

  void setTimestamp(Throwable targetFailureCause, String parameterName, Timestamp x);

  void setCharacterStream(int parameterIndex, Reader reader, int length);

  void setCharacterStream(Throwable targetFailureCause, int parameterIndex, Reader reader,
      int length);

  void setObject(String parameterName, Object x, SQLType targetSqlType);

  void setObject(Throwable targetFailureCause, String parameterName, Object x,
      SQLType targetSqlType);

  void setBytes(String parameterName, byte[] x);

  void setBytes(Throwable targetFailureCause, String parameterName, byte[] x);

  void executeLargeBatch(long[] targetSuccessResult);

  void executeLargeBatch(Throwable targetFailureCause);

  void executeUpdate(int targetSuccessResult, String sql, String[] columnNames);

  void executeUpdate(Throwable targetFailureCause, String sql, String[] columnNames);

  void getClob(Clob targetSuccessResult, int parameterIndex);

  void getClob(Throwable targetFailureCause, int parameterIndex);

  void setArray(int parameterIndex, Array x);

  void setArray(Throwable targetFailureCause, int parameterIndex, Array x);

  void registerOutParameter(String parameterName, SQLType sqlType);

  void registerOutParameter(Throwable targetFailureCause, String parameterName, SQLType sqlType);

  void setTime(int parameterIndex, Time x);

  void setTime(Throwable targetFailureCause, int parameterIndex, Time x);

  void setTime(String parameterName, Time x);

  void setTime(Throwable targetFailureCause, String parameterName, Time x);

  void setClob(String parameterName, Reader reader);

  void setClob(Throwable targetFailureCause, String parameterName, Reader reader);

  void setBigDecimal(String parameterName, BigDecimal x);

  void setBigDecimal(Throwable targetFailureCause, String parameterName, BigDecimal x);

  void setClob(int parameterIndex, Reader reader);

  void setClob(Throwable targetFailureCause, int parameterIndex, Reader reader);

  void setNString(int parameterIndex, String value);

  void setNString(Throwable targetFailureCause, int parameterIndex, String value);

  void executeLargeUpdate(long targetSuccessResult, String sql, int autoGeneratedKeys);

  void executeLargeUpdate(Throwable targetFailureCause, String sql, int autoGeneratedKeys);

  void setByte(String parameterName, byte x);

  void setByte(Throwable targetFailureCause, String parameterName, byte x);

  void getMaxRows(int targetSuccessResult);

  void getMaxRows(Throwable targetFailureCause);

  void getBlob(Blob targetSuccessResult, int parameterIndex);

  void getBlob(Throwable targetFailureCause, int parameterIndex);

  void getQueryTimeout(int targetSuccessResult);

  void getQueryTimeout(Throwable targetFailureCause);

  void setBoolean(String parameterName, boolean x);

  void setBoolean(Throwable targetFailureCause, String parameterName, boolean x);

  <T> void getObject(T targetSuccessResult, int parameterIndex, Class<T> type);

  <T> void getObject(Throwable targetFailureCause, int parameterIndex, Class<T> type);

  void setBlob(String parameterName, InputStream inputStream, long length);

  void setBlob(Throwable targetFailureCause, String parameterName, InputStream inputStream,
      long length);

  void getGeneratedKeys(ResultSet targetSuccessResult);

  void getGeneratedKeys(Throwable targetFailureCause);

  void setSQLXML(String parameterName, SQLXML xmlObject);

  void setSQLXML(Throwable targetFailureCause, String parameterName, SQLXML xmlObject);

  void getBigDecimal(BigDecimal targetSuccessResult, int parameterIndex);

  void getBigDecimal(Throwable targetFailureCause, int parameterIndex);

  void getCharacterStream(Reader targetSuccessResult, int parameterIndex);

  void getCharacterStream(Throwable targetFailureCause, int parameterIndex);

  void addBatch();

  void addBatch(Throwable targetFailureCause);

  void getLargeUpdateCount(long targetSuccessResult);

  void getLargeUpdateCount(Throwable targetFailureCause);

  void setAsciiStream(int parameterIndex, InputStream x);

  void setAsciiStream(Throwable targetFailureCause, int parameterIndex, InputStream x);

  void setTime(int parameterIndex, Time x, Calendar cal);

  void setTime(Throwable targetFailureCause, int parameterIndex, Time x, Calendar cal);

  void setNClob(String parameterName, Reader reader, long length);

  void setNClob(Throwable targetFailureCause, String parameterName, Reader reader, long length);

  void registerOutParameter(int parameterIndex, int sqlType, int scale);

  void registerOutParameter(Throwable targetFailureCause, int parameterIndex, int sqlType,
      int scale);

  void getResultSet(ResultSet targetSuccessResult);

  void getResultSet(Throwable targetFailureCause);

  void getUpdateCount(int targetSuccessResult);

  void getUpdateCount(Throwable targetFailureCause);

  void setQueryTimeout(int seconds);

  void setQueryTimeout(Throwable targetFailureCause, int seconds);

  void setNull(String parameterName, int sqlType, String typeName);

  void setNull(Throwable targetFailureCause, String parameterName, int sqlType, String typeName);

  void setNull(int parameterIndex, int sqlType);

  void setNull(Throwable targetFailureCause, int parameterIndex, int sqlType);

  void registerOutParameter(int parameterIndex, int sqlType, String typeName);

  void registerOutParameter(Throwable targetFailureCause, int parameterIndex, int sqlType,
      String typeName);

  void executeLargeUpdate(long targetSuccessResult, String sql, int[] columnIndexes);

  void executeLargeUpdate(Throwable targetFailureCause, String sql, int[] columnIndexes);

  void setNString(String parameterName, String value);

  void setNString(Throwable targetFailureCause, String parameterName, String value);

  void getLong(long targetSuccessResult, String parameterName);

  void getLong(Throwable targetFailureCause, String parameterName);

  void getString(String targetSuccessResult, String parameterName);

  void getString(Throwable targetFailureCause, String parameterName);

  void setNClob(int parameterIndex, Reader reader);

  void setNClob(Throwable targetFailureCause, int parameterIndex, Reader reader);

  void setClob(int parameterIndex, Reader reader, long length);

  void setClob(Throwable targetFailureCause, int parameterIndex, Reader reader, long length);

  void getTimestamp(Timestamp targetSuccessResult, int parameterIndex, Calendar cal);

  void getTimestamp(Throwable targetFailureCause, int parameterIndex, Calendar cal);

  void getNCharacterStream(Reader targetSuccessResult, String parameterName);

  void getNCharacterStream(Throwable targetFailureCause, String parameterName);

  void getShort(short targetSuccessResult, int parameterIndex);

  void getShort(Throwable targetFailureCause, int parameterIndex);

  void execute(boolean targetSuccessResult);

  void execute(Throwable targetFailureCause);

  void executeBatch(int[] targetSuccessResult);

  void executeBatch(Throwable targetFailureCause);

  void execute(boolean targetSuccessResult, String sql, int[] columnIndexes);

  void execute(Throwable targetFailureCause, String sql, int[] columnIndexes);

  void setAsciiStream(String parameterName, InputStream x, int length);

  void setAsciiStream(Throwable targetFailureCause, String parameterName, InputStream x,
      int length);

  void setBinaryStream(String parameterName, InputStream x, int length);

  void setBinaryStream(Throwable targetFailureCause, String parameterName, InputStream x,
      int length);

  void setTimestamp(String parameterName, Timestamp x, Calendar cal);

  void setTimestamp(Throwable targetFailureCause, String parameterName, Timestamp x, Calendar cal);

  <T> void unwrap(T targetSuccessResult, Class<T> iface);

  <T> void unwrap(Throwable targetFailureCause, Class<T> iface);

  void setFloat(String parameterName, float x);

  void setFloat(Throwable targetFailureCause, String parameterName, float x);

  void setObject(int parameterIndex, Object x);

  void setObject(Throwable targetFailureCause, int parameterIndex, Object x);

  void getShort(short targetSuccessResult, String parameterName);

  void getShort(Throwable targetFailureCause, String parameterName);

  void setObject(int parameterIndex, Object x, int targetSqlType);

  void setObject(Throwable targetFailureCause, int parameterIndex, Object x, int targetSqlType);

  void executeUpdate(int targetSuccessResult, String sql, int autoGeneratedKeys);

  void executeUpdate(Throwable targetFailureCause, String sql, int autoGeneratedKeys);

  void getDate(Date targetSuccessResult, String parameterName);

  void getDate(Throwable targetFailureCause, String parameterName);

  void getLargeMaxRows(long targetSuccessResult);

  void getLargeMaxRows(Throwable targetFailureCause);

  void executeLargeUpdate(long targetSuccessResult, String sql, String[] columnNames);

  void executeLargeUpdate(Throwable targetFailureCause, String sql, String[] columnNames);

  void getURL(URL targetSuccessResult, String parameterName);

  void getURL(Throwable targetFailureCause, String parameterName);

  void getNClob(NClob targetSuccessResult, int parameterIndex);

  void getNClob(Throwable targetFailureCause, int parameterIndex);

  void setNCharacterStream(int parameterIndex, Reader value);

  void setNCharacterStream(Throwable targetFailureCause, int parameterIndex, Reader value);

  void setNClob(int parameterIndex, NClob value);

  void setNClob(Throwable targetFailureCause, int parameterIndex, NClob value);

  void getBigDecimal(BigDecimal targetSuccessResult, String parameterName);

  void getBigDecimal(Throwable targetFailureCause, String parameterName);

  void getCharacterStream(Reader targetSuccessResult, String parameterName);

  void getCharacterStream(Throwable targetFailureCause, String parameterName);

  void getSQLXML(SQLXML targetSuccessResult, String parameterName);

  void getSQLXML(Throwable targetFailureCause, String parameterName);

  void setNull(String parameterName, int sqlType);

  void setNull(Throwable targetFailureCause, String parameterName, int sqlType);

  void getTime(Time targetSuccessResult, int parameterIndex, Calendar cal);

  void getTime(Throwable targetFailureCause, int parameterIndex, Calendar cal);

  void setObject(String parameterName, Object x);

  void setObject(Throwable targetFailureCause, String parameterName, Object x);

  void setNCharacterStream(String parameterName, Reader value);

  void setNCharacterStream(Throwable targetFailureCause, String parameterName, Reader value);

  void setBinaryStream(String parameterName, InputStream x);

  void setBinaryStream(Throwable targetFailureCause, String parameterName, InputStream x);

  void setShort(String parameterName, short x);

  void setShort(Throwable targetFailureCause, String parameterName, short x);

  void setDate(String parameterName, Date x);

  void setDate(Throwable targetFailureCause, String parameterName, Date x);

  void getTime(Time targetSuccessResult, String parameterName);

  void getTime(Throwable targetFailureCause, String parameterName);

  void getObject(Object targetSuccessResult, int parameterIndex, Map<String, Class<?>> map);

  void getObject(Throwable targetFailureCause, int parameterIndex, Map<String, Class<?>> map);

  void getBlob(Blob targetSuccessResult, String parameterName);

  void getBlob(Throwable targetFailureCause, String parameterName);

  void setBinaryStream(int parameterIndex, InputStream x);

  void setBinaryStream(Throwable targetFailureCause, int parameterIndex, InputStream x);

  void executeLargeUpdate(long targetSuccessResult);

  void executeLargeUpdate(Throwable targetFailureCause);

  void setCharacterStream(int parameterIndex, Reader reader);

  void setCharacterStream(Throwable targetFailureCause, int parameterIndex, Reader reader);

  void getFloat(float targetSuccessResult, String parameterName);

  void getFloat(Throwable targetFailureCause, String parameterName);

  void setAsciiStream(int parameterIndex, InputStream x, long length);

  void setAsciiStream(Throwable targetFailureCause, int parameterIndex, InputStream x, long length);

  void setNCharacterStream(int parameterIndex, Reader value, long length);

  void setNCharacterStream(Throwable targetFailureCause, int parameterIndex, Reader value,
      long length);

  void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength);

  void setObject(Throwable targetFailureCause, int parameterIndex, Object x, SQLType targetSqlType,
      int scaleOrLength);

  void setNCharacterStream(String parameterName, Reader value, long length);

  void setNCharacterStream(Throwable targetFailureCause, String parameterName, Reader value,
      long length);

  void setURL(String parameterName, URL val);

  void setURL(Throwable targetFailureCause, String parameterName, URL val);

  void registerOutParameter(int parameterIndex, SQLType sqlType);

  void registerOutParameter(Throwable targetFailureCause, int parameterIndex, SQLType sqlType);

  void setBoolean(int parameterIndex, boolean x);

  void setBoolean(Throwable targetFailureCause, int parameterIndex, boolean x);

  void setCharacterStream(String parameterName, Reader reader);

  void setCharacterStream(Throwable targetFailureCause, String parameterName, Reader reader);

  void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength);

  void setObject(Throwable targetFailureCause, int parameterIndex, Object x, int targetSqlType,
      int scaleOrLength);

  void getRowId(RowId targetSuccessResult, int parameterIndex);

  void getRowId(Throwable targetFailureCause, int parameterIndex);

  void setFetchSize(int rows);

  void setFetchSize(Throwable targetFailureCause, int rows);

  void getResultSetType(int targetSuccessResult);

  void getResultSetType(Throwable targetFailureCause);

  void setLargeMaxRows(long max);

  void setLargeMaxRows(Throwable targetFailureCause, long max);

  void registerOutParameter(int parameterIndex, SQLType sqlType, int scale);

  void registerOutParameter(Throwable targetFailureCause, int parameterIndex, SQLType sqlType,
      int scale);

  void getMetaData(ResultSetMetaData targetSuccessResult);

  void getMetaData(Throwable targetFailureCause);

  void getMaxFieldSize(int targetSuccessResult);

  void getMaxFieldSize(Throwable targetFailureCause);

  void setMaxRows(int max);

  void setMaxRows(Throwable targetFailureCause, int max);

  void setDouble(String parameterName, double x);

  void setDouble(Throwable targetFailureCause, String parameterName, double x);

  void setInt(String parameterName, int x);

  void setInt(Throwable targetFailureCause, String parameterName, int x);

  void setRowId(int parameterIndex, RowId x);

  void setRowId(Throwable targetFailureCause, int parameterIndex, RowId x);

  void getDate(Date targetSuccessResult, int parameterIndex);

  void getDate(Throwable targetFailureCause, int parameterIndex);

  void setPoolable(boolean poolable);

  void setPoolable(Throwable targetFailureCause, boolean poolable);

  void setBinaryStream(int parameterIndex, InputStream x, int length);

  void setBinaryStream(Throwable targetFailureCause, int parameterIndex, InputStream x, int length);

  void setURL(int parameterIndex, URL x);

  void setURL(Throwable targetFailureCause, int parameterIndex, URL x);

  void executeQuery(ResultSet targetSuccessResult);

  void executeQuery(Throwable targetFailureCause);

  void getMoreResults(boolean targetSuccessResult);

  void getMoreResults(Throwable targetFailureCause);

  void setDate(int parameterIndex, Date x);

  void setDate(Throwable targetFailureCause, int parameterIndex, Date x);

  void setDate(String parameterName, Date x, Calendar cal);

  void setDate(Throwable targetFailureCause, String parameterName, Date x, Calendar cal);

  void getTimestamp(Timestamp targetSuccessResult, int parameterIndex);

  void getTimestamp(Throwable targetFailureCause, int parameterIndex);

  void getDouble(double targetSuccessResult, int parameterIndex);

  void getDouble(Throwable targetFailureCause, int parameterIndex);

  void setByte(int parameterIndex, byte x);

  void setByte(Throwable targetFailureCause, int parameterIndex, byte x);

  void isCloseOnCompletion(boolean targetSuccessResult);

  void isCloseOnCompletion(Throwable targetFailureCause);

  void getClob(Clob targetSuccessResult, String parameterName);

  void getClob(Throwable targetFailureCause, String parameterName);

  void getBoolean(boolean targetSuccessResult, int parameterIndex);

  void getBoolean(Throwable targetFailureCause, int parameterIndex);

  void setAsciiStream(String parameterName, InputStream x, long length);

  void setAsciiStream(Throwable targetFailureCause, String parameterName, InputStream x,
      long length);

  void setBinaryStream(String parameterName, InputStream x, long length);

  void setBinaryStream(Throwable targetFailureCause, String parameterName, InputStream x,
      long length);

  void setNull(int parameterIndex, int sqlType, String typeName);

  void setNull(Throwable targetFailureCause, int parameterIndex, int sqlType, String typeName);

  void getParameterMetaData(ParameterMetaData targetSuccessResult);

  void getParameterMetaData(Throwable targetFailureCause);

  void getNString(String targetSuccessResult, int parameterIndex);

  void getNString(Throwable targetFailureCause, int parameterIndex);

  void getArray(Array targetSuccessResult, int parameterIndex);

  void getArray(Throwable targetFailureCause, int parameterIndex);

  void setBlob(int parameterIndex, InputStream inputStream, long length);

  void setBlob(Throwable targetFailureCause, int parameterIndex, InputStream inputStream,
      long length);

  void getTime(Time targetSuccessResult, int parameterIndex);

  void getTime(Throwable targetFailureCause, int parameterIndex);

  void getRef(Ref targetSuccessResult, String parameterName);

  void getRef(Throwable targetFailureCause, String parameterName);

  <T> void getObject(T targetSuccessResult, String parameterName, Class<T> type);

  <T> void getObject(Throwable targetFailureCause, String parameterName, Class<T> type);

  void getObject(Object targetSuccessResult, String parameterName);

  void getObject(Throwable targetFailureCause, String parameterName);

  void getBytes(byte[] targetSuccessResult, String parameterName);

  void getBytes(Throwable targetFailureCause, String parameterName);

  void closeOnCompletion();

  void closeOnCompletion(Throwable targetFailureCause);

  void getInt(int targetSuccessResult, int parameterIndex);

  void getInt(Throwable targetFailureCause, int parameterIndex);

  void setBinaryStream(int parameterIndex, InputStream x, long length);

  void setBinaryStream(Throwable targetFailureCause, int parameterIndex, InputStream x,
      long length);

  void setNClob(String parameterName, Reader reader);

  void setNClob(Throwable targetFailureCause, String parameterName, Reader reader);

  void getObject(Object targetSuccessResult, String parameterName, Map<String, Class<?>> map);

  void getObject(Throwable targetFailureCause, String parameterName, Map<String, Class<?>> map);

  void setBigDecimal(int parameterIndex, BigDecimal x);

  void setBigDecimal(Throwable targetFailureCause, int parameterIndex, BigDecimal x);

  void setString(String parameterName, String x);

  void setString(Throwable targetFailureCause, String parameterName, String x);

  void setBlob(int parameterIndex, InputStream inputStream);

  void setBlob(Throwable targetFailureCause, int parameterIndex, InputStream inputStream);

  void setRef(int parameterIndex, Ref x);

  void setRef(Throwable targetFailureCause, int parameterIndex, Ref x);

  void setObject(String parameterName, Object x, int targetSqlType, int scale);

  void setObject(Throwable targetFailureCause, String parameterName, Object x, int targetSqlType,
      int scale);

  void executeUpdate(int targetSuccessResult, String sql, int[] columnIndexes);

  void executeUpdate(Throwable targetFailureCause, String sql, int[] columnIndexes);

  void getDouble(double targetSuccessResult, String parameterName);

  void getDouble(Throwable targetFailureCause, String parameterName);

  void setClob(String parameterName, Reader reader, long length);

  void setClob(Throwable targetFailureCause, String parameterName, Reader reader, long length);

  void setDouble(int parameterIndex, double x);

  void setDouble(Throwable targetFailureCause, int parameterIndex, double x);

  void setTimestamp(int parameterIndex, Timestamp x);

  void setTimestamp(Throwable targetFailureCause, int parameterIndex, Timestamp x);

  void close();

  void close(Throwable targetFailureCause);

  void setMaxFieldSize(int max);

  void setMaxFieldSize(Throwable targetFailureCause, int max);

  void setTimestamp(int parameterIndex, Timestamp x, Calendar cal);

  void setTimestamp(Throwable targetFailureCause, int parameterIndex, Timestamp x, Calendar cal);

  void setClob(int parameterIndex, Clob x);

  void setClob(Throwable targetFailureCause, int parameterIndex, Clob x);

  void registerOutParameter(String parameterName, int sqlType, int scale);

  void registerOutParameter(Throwable targetFailureCause, String parameterName, int sqlType,
      int scale);

  void setTime(String parameterName, Time x, Calendar cal);

  void setTime(Throwable targetFailureCause, String parameterName, Time x, Calendar cal);

  void getSQLXML(SQLXML targetSuccessResult, int parameterIndex);

  void getSQLXML(Throwable targetFailureCause, int parameterIndex);

  void clearWarnings();

  void clearWarnings(Throwable targetFailureCause);

  void clearBatch();

  void clearBatch(Throwable targetFailureCause);

  void setLong(int parameterIndex, long x);

  void setLong(Throwable targetFailureCause, int parameterIndex, long x);

  void getNClob(NClob targetSuccessResult, String parameterName);

  void getNClob(Throwable targetFailureCause, String parameterName);

  void executeUpdate(int targetSuccessResult, String sql);

  void executeUpdate(Throwable targetFailureCause, String sql);

  void isWrapperFor(boolean targetSuccessResult, Class<?> iface);

  void isWrapperFor(Throwable targetFailureCause, Class<?> iface);

  void getDate(Date targetSuccessResult, int parameterIndex, Calendar cal);

  void getDate(Throwable targetFailureCause, int parameterIndex, Calendar cal);

  void setClob(String parameterName, Clob x);

  void setClob(Throwable targetFailureCause, String parameterName, Clob x);

  void setCharacterStream(int parameterIndex, Reader reader, long length);

  void setCharacterStream(Throwable targetFailureCause, int parameterIndex, Reader reader,
      long length);

  void getBoolean(boolean targetSuccessResult, String parameterName);

  void getBoolean(Throwable targetFailureCause, String parameterName);

  void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength);

  void setObject(Throwable targetFailureCause, String parameterName, Object x,
      SQLType targetSqlType, int scaleOrLength);

  void setDate(int parameterIndex, Date x, Calendar cal);

  void setDate(Throwable targetFailureCause, int parameterIndex, Date x, Calendar cal);

  void setUnicodeStream(int parameterIndex, InputStream x, int length);

  void setUnicodeStream(Throwable targetFailureCause, int parameterIndex, InputStream x,
      int length);

  void getConnection(Connection targetSuccessResult);

  void getConnection(Throwable targetFailureCause);

  void execute(boolean targetSuccessResult, String sql, String[] columnNames);

  void execute(Throwable targetFailureCause, String sql, String[] columnNames);

  void getDate(Date targetSuccessResult, String parameterName, Calendar cal);

  void getDate(Throwable targetFailureCause, String parameterName, Calendar cal);

  void getArray(Array targetSuccessResult, String parameterName);

  void getArray(Throwable targetFailureCause, String parameterName);

  void setObject(String parameterName, Object x, int targetSqlType);

  void setObject(Throwable targetFailureCause, String parameterName, Object x, int targetSqlType);

  void getTimestamp(Timestamp targetSuccessResult, String parameterName);

  void getTimestamp(Throwable targetFailureCause, String parameterName);

  void execute(boolean targetSuccessResult, String sql, int autoGeneratedKeys);

  void execute(Throwable targetFailureCause, String sql, int autoGeneratedKeys);

  void setSQLXML(int parameterIndex, SQLXML xmlObject);

  void setSQLXML(Throwable targetFailureCause, int parameterIndex, SQLXML xmlObject);

  void setNClob(int parameterIndex, Reader reader, long length);

  void setNClob(Throwable targetFailureCause, int parameterIndex, Reader reader, long length);

  void getFloat(float targetSuccessResult, int parameterIndex);

  void getFloat(Throwable targetFailureCause, int parameterIndex);

  void registerOutParameter(String parameterName, int sqlType);

  void registerOutParameter(Throwable targetFailureCause, String parameterName, int sqlType);

  void setCursorName(String name);

  void setCursorName(Throwable targetFailureCause, String name);

  void executeLargeUpdate(long targetSuccessResult, String sql);

  void executeLargeUpdate(Throwable targetFailureCause, String sql);

  void setAsciiStream(int parameterIndex, InputStream x, int length);

  void setAsciiStream(Throwable targetFailureCause, int parameterIndex, InputStream x, int length);

  void getByte(byte targetSuccessResult, int parameterIndex);

  void getByte(Throwable targetFailureCause, int parameterIndex);

  void getBigDecimal(BigDecimal targetSuccessResult, int parameterIndex, int scale);

  void getBigDecimal(Throwable targetFailureCause, int parameterIndex, int scale);

  void setFloat(int parameterIndex, float x);

  void setFloat(Throwable targetFailureCause, int parameterIndex, float x);

  void getResultSetConcurrency(int targetSuccessResult);

  void getResultSetConcurrency(Throwable targetFailureCause);

  void getWarnings(SQLWarning targetSuccessResult);

  void getWarnings(Throwable targetFailureCause);

  void getTime(Time targetSuccessResult, String parameterName, Calendar cal);

  void getTime(Throwable targetFailureCause, String parameterName, Calendar cal);

  void executeUpdate(int targetSuccessResult);

  void executeUpdate(Throwable targetFailureCause);

  void setBytes(int parameterIndex, byte[] x);

  void setBytes(Throwable targetFailureCause, int parameterIndex, byte[] x);

  void setEscapeProcessing(boolean enable);

  void setEscapeProcessing(Throwable targetFailureCause, boolean enable);

  void execute(boolean targetSuccessResult, String sql);

  void execute(Throwable targetFailureCause, String sql);

  void getLong(long targetSuccessResult, int parameterIndex);

  void getLong(Throwable targetFailureCause, int parameterIndex);

  void getURL(URL targetSuccessResult, int parameterIndex);

  void getURL(Throwable targetFailureCause, int parameterIndex);

  void wasNull(boolean targetSuccessResult);

  void wasNull(Throwable targetFailureCause);

  void setFetchDirection(int direction);

  void setFetchDirection(Throwable targetFailureCause, int direction);

  void registerOutParameter(String parameterName, int sqlType, String typeName);

  void registerOutParameter(Throwable targetFailureCause, String parameterName, int sqlType,
      String typeName);

  void setString(int parameterIndex, String x);

  void setString(Throwable targetFailureCause, int parameterIndex, String x);

  void getRowId(RowId targetSuccessResult, String parameterName);

  void getRowId(Throwable targetFailureCause, String parameterName);

  ResultSetListener newResultSetListener();

  RefListener newRefListener();

  ClobListener newClobListener();

  BlobListener newBlobListener();

  NClobListener newNClobListener();

  SQLXMLListener newSQLXMLListener();

  RowIdListener newRowIdListener();

  ResultSetMetaDataListener newResultSetMetaDataListener();

  ParameterMetaDataListener newParameterMetaDataListener();

  ArrayListener newArrayListener();

  ConnectionListener newConnectionListener();
}
