package com.impossibl.jdbc.spy;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class StatementRelay implements Relay<Statement>, Statement {
  public Statement target;

  public StatementListener listener;

  public StatementRelay(Statement target, StatementListener listener) {
    this.target = target;
    this.listener = listener;
  }

  public Statement getTarget() {
    return target;
  }

  public Connection getConnection() throws SQLException {
    try {
      Connection targetSuccessResult = this.target.getConnection();
      this.listener.getConnection(targetSuccessResult);
      targetSuccessResult = targetSuccessResult != null ? new ConnectionRelay(targetSuccessResult, this.listener.newConnectionListener()) : null;
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getConnection(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public int getFetchSize() throws SQLException {
    try {
      int targetSuccessResult = this.target.getFetchSize();
      this.listener.getFetchSize(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getFetchSize(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public void closeOnCompletion() throws SQLException {
    try {
      this.target.closeOnCompletion();
      this.listener.closeOnCompletion();

    }
    catch(SQLException targetFailureCause) {
      this.listener.closeOnCompletion(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public boolean isClosed() throws SQLException {
    try {
      boolean targetSuccessResult = this.target.isClosed();
      this.listener.isClosed(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.isClosed(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public void setLargeMaxRows(long max) throws SQLException {
    try {
      this.target.setLargeMaxRows(max);
      this.listener.setLargeMaxRows(max);

    }
    catch(SQLException targetFailureCause) {
      this.listener.setLargeMaxRows(targetFailureCause, max);
      throw targetFailureCause;

    }
  }

  public int getFetchDirection() throws SQLException {
    try {
      int targetSuccessResult = this.target.getFetchDirection();
      this.listener.getFetchDirection(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getFetchDirection(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public void setCursorName(String name) throws SQLException {
    try {
      this.target.setCursorName(name);
      this.listener.setCursorName(name);

    }
    catch(SQLException targetFailureCause) {
      this.listener.setCursorName(targetFailureCause, name);
      throw targetFailureCause;

    }
  }

  public void setQueryTimeout(int seconds) throws SQLException {
    try {
      this.target.setQueryTimeout(seconds);
      this.listener.setQueryTimeout(seconds);

    }
    catch(SQLException targetFailureCause) {
      this.listener.setQueryTimeout(targetFailureCause, seconds);
      throw targetFailureCause;

    }
  }

  public void setMaxFieldSize(int max) throws SQLException {
    try {
      this.target.setMaxFieldSize(max);
      this.listener.setMaxFieldSize(max);

    }
    catch(SQLException targetFailureCause) {
      this.listener.setMaxFieldSize(targetFailureCause, max);
      throw targetFailureCause;

    }
  }

  public long executeLargeUpdate(String sql) throws SQLException {
    try {
      long targetSuccessResult = this.target.executeLargeUpdate(sql);
      this.listener.executeLargeUpdate(targetSuccessResult, sql);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.executeLargeUpdate(targetFailureCause, sql);
      throw targetFailureCause;

    }
  }

  public int executeUpdate(String sql) throws SQLException {
    try {
      int targetSuccessResult = this.target.executeUpdate(sql);
      this.listener.executeUpdate(targetSuccessResult, sql);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.executeUpdate(targetFailureCause, sql);
      throw targetFailureCause;

    }
  }

  public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
    try {
      long targetSuccessResult = this.target.executeLargeUpdate(sql, autoGeneratedKeys);
      this.listener.executeLargeUpdate(targetSuccessResult, sql, autoGeneratedKeys);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.executeLargeUpdate(targetFailureCause, sql, autoGeneratedKeys);
      throw targetFailureCause;

    }
  }

  public boolean execute(String sql) throws SQLException {
    try {
      boolean targetSuccessResult = this.target.execute(sql);
      this.listener.execute(targetSuccessResult, sql);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.execute(targetFailureCause, sql);
      throw targetFailureCause;

    }
  }

  public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
    try {
      long targetSuccessResult = this.target.executeLargeUpdate(sql, columnIndexes);
      this.listener.executeLargeUpdate(targetSuccessResult, sql, columnIndexes);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.executeLargeUpdate(targetFailureCause, sql, columnIndexes);
      throw targetFailureCause;

    }
  }

  public ResultSet executeQuery(String sql) throws SQLException {
    try {
      ResultSet targetSuccessResult = this.target.executeQuery(sql);
      this.listener.executeQuery(targetSuccessResult, sql);
      targetSuccessResult = targetSuccessResult != null ? new ResultSetRelay(targetSuccessResult, this.listener.newResultSetListener()) : null;
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.executeQuery(targetFailureCause, sql);
      throw targetFailureCause;

    }
  }

  public int getResultSetConcurrency() throws SQLException {
    try {
      int targetSuccessResult = this.target.getResultSetConcurrency();
      this.listener.getResultSetConcurrency(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getResultSetConcurrency(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public int executeUpdate(String sql, String[] columnNames) throws SQLException {
    try {
      int targetSuccessResult = this.target.executeUpdate(sql, columnNames);
      this.listener.executeUpdate(targetSuccessResult, sql, columnNames);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.executeUpdate(targetFailureCause, sql, columnNames);
      throw targetFailureCause;

    }
  }

  public void clearBatch() throws SQLException {
    try {
      this.target.clearBatch();
      this.listener.clearBatch();

    }
    catch(SQLException targetFailureCause) {
      this.listener.clearBatch(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public void setMaxRows(int max) throws SQLException {
    try {
      this.target.setMaxRows(max);
      this.listener.setMaxRows(max);

    }
    catch(SQLException targetFailureCause) {
      this.listener.setMaxRows(targetFailureCause, max);
      throw targetFailureCause;

    }
  }

  public void setFetchSize(int rows) throws SQLException {
    try {
      this.target.setFetchSize(rows);
      this.listener.setFetchSize(rows);

    }
    catch(SQLException targetFailureCause) {
      this.listener.setFetchSize(targetFailureCause, rows);
      throw targetFailureCause;

    }
  }

  public boolean execute(String sql, int[] columnIndexes) throws SQLException {
    try {
      boolean targetSuccessResult = this.target.execute(sql, columnIndexes);
      this.listener.execute(targetSuccessResult, sql, columnIndexes);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.execute(targetFailureCause, sql, columnIndexes);
      throw targetFailureCause;

    }
  }

  public void clearWarnings() throws SQLException {
    try {
      this.target.clearWarnings();
      this.listener.clearWarnings();

    }
    catch(SQLException targetFailureCause) {
      this.listener.clearWarnings(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public boolean getMoreResults(int current) throws SQLException {
    try {
      boolean targetSuccessResult = this.target.getMoreResults(current);
      this.listener.getMoreResults(targetSuccessResult, current);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getMoreResults(targetFailureCause, current);
      throw targetFailureCause;

    }
  }

  public int getResultSetType() throws SQLException {
    try {
      int targetSuccessResult = this.target.getResultSetType();
      this.listener.getResultSetType(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getResultSetType(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public void setFetchDirection(int direction) throws SQLException {
    try {
      this.target.setFetchDirection(direction);
      this.listener.setFetchDirection(direction);

    }
    catch(SQLException targetFailureCause) {
      this.listener.setFetchDirection(targetFailureCause, direction);
      throw targetFailureCause;

    }
  }

  public boolean execute(String sql, String[] columnNames) throws SQLException {
    try {
      boolean targetSuccessResult = this.target.execute(sql, columnNames);
      this.listener.execute(targetSuccessResult, sql, columnNames);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.execute(targetFailureCause, sql, columnNames);
      throw targetFailureCause;

    }
  }

  public int[] executeBatch() throws SQLException {
    try {
      int[] targetSuccessResult = this.target.executeBatch();
      this.listener.executeBatch(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.executeBatch(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public long getLargeMaxRows() throws SQLException {
    try {
      long targetSuccessResult = this.target.getLargeMaxRows();
      this.listener.getLargeMaxRows(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getLargeMaxRows(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
    try {
      long targetSuccessResult = this.target.executeLargeUpdate(sql, columnNames);
      this.listener.executeLargeUpdate(targetSuccessResult, sql, columnNames);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.executeLargeUpdate(targetFailureCause, sql, columnNames);
      throw targetFailureCause;

    }
  }

  public int getQueryTimeout() throws SQLException {
    try {
      int targetSuccessResult = this.target.getQueryTimeout();
      this.listener.getQueryTimeout(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getQueryTimeout(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
    try {
      int targetSuccessResult = this.target.executeUpdate(sql, columnIndexes);
      this.listener.executeUpdate(targetSuccessResult, sql, columnIndexes);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.executeUpdate(targetFailureCause, sql, columnIndexes);
      throw targetFailureCause;

    }
  }

  public int getMaxFieldSize() throws SQLException {
    try {
      int targetSuccessResult = this.target.getMaxFieldSize();
      this.listener.getMaxFieldSize(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getMaxFieldSize(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public boolean isWrapperFor(Class<?> iface) throws SQLException {
    try {
      boolean targetSuccessResult = this.target.isWrapperFor(iface);
      this.listener.isWrapperFor(targetSuccessResult, iface);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.isWrapperFor(targetFailureCause, iface);
      throw targetFailureCause;

    }
  }

  public void addBatch(String sql) throws SQLException {
    try {
      this.target.addBatch(sql);
      this.listener.addBatch(sql);

    }
    catch(SQLException targetFailureCause) {
      this.listener.addBatch(targetFailureCause, sql);
      throw targetFailureCause;

    }
  }

  public void setPoolable(boolean poolable) throws SQLException {
    try {
      this.target.setPoolable(poolable);
      this.listener.setPoolable(poolable);

    }
    catch(SQLException targetFailureCause) {
      this.listener.setPoolable(targetFailureCause, poolable);
      throw targetFailureCause;

    }
  }

  public ResultSet getGeneratedKeys() throws SQLException {
    try {
      ResultSet targetSuccessResult = this.target.getGeneratedKeys();
      this.listener.getGeneratedKeys(targetSuccessResult);
      targetSuccessResult = targetSuccessResult != null ? new ResultSetRelay(targetSuccessResult, this.listener.newResultSetListener()) : null;
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getGeneratedKeys(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public boolean isPoolable() throws SQLException {
    try {
      boolean targetSuccessResult = this.target.isPoolable();
      this.listener.isPoolable(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.isPoolable(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public void setEscapeProcessing(boolean enable) throws SQLException {
    try {
      this.target.setEscapeProcessing(enable);
      this.listener.setEscapeProcessing(enable);

    }
    catch(SQLException targetFailureCause) {
      this.listener.setEscapeProcessing(targetFailureCause, enable);
      throw targetFailureCause;

    }
  }

  public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
    try {
      int targetSuccessResult = this.target.executeUpdate(sql, autoGeneratedKeys);
      this.listener.executeUpdate(targetSuccessResult, sql, autoGeneratedKeys);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.executeUpdate(targetFailureCause, sql, autoGeneratedKeys);
      throw targetFailureCause;

    }
  }

  public long[] executeLargeBatch() throws SQLException {
    try {
      long[] targetSuccessResult = this.target.executeLargeBatch();
      this.listener.executeLargeBatch(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.executeLargeBatch(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public ResultSet getResultSet() throws SQLException {
    try {
      ResultSet targetSuccessResult = this.target.getResultSet();
      this.listener.getResultSet(targetSuccessResult);
      targetSuccessResult = targetSuccessResult != null ? new ResultSetRelay(targetSuccessResult, this.listener.newResultSetListener()) : null;
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getResultSet(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public int getResultSetHoldability() throws SQLException {
    try {
      int targetSuccessResult = this.target.getResultSetHoldability();
      this.listener.getResultSetHoldability(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getResultSetHoldability(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
    try {
      boolean targetSuccessResult = this.target.execute(sql, autoGeneratedKeys);
      this.listener.execute(targetSuccessResult, sql, autoGeneratedKeys);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.execute(targetFailureCause, sql, autoGeneratedKeys);
      throw targetFailureCause;

    }
  }

  public <T> T unwrap(Class<T> iface) throws SQLException {
    try {
      T targetSuccessResult = this.target.unwrap(iface);
      this.listener.unwrap(targetSuccessResult, iface);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.unwrap(targetFailureCause, iface);
      throw targetFailureCause;

    }
  }

  public long getLargeUpdateCount() throws SQLException {
    try {
      long targetSuccessResult = this.target.getLargeUpdateCount();
      this.listener.getLargeUpdateCount(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getLargeUpdateCount(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public int getMaxRows() throws SQLException {
    try {
      int targetSuccessResult = this.target.getMaxRows();
      this.listener.getMaxRows(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getMaxRows(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public SQLWarning getWarnings() throws SQLException {
    try {
      SQLWarning targetSuccessResult = this.target.getWarnings();
      this.listener.getWarnings(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getWarnings(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public boolean isCloseOnCompletion() throws SQLException {
    try {
      boolean targetSuccessResult = this.target.isCloseOnCompletion();
      this.listener.isCloseOnCompletion(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.isCloseOnCompletion(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public void close() throws SQLException {
    try {
      this.target.close();
      this.listener.close();

    }
    catch(SQLException targetFailureCause) {
      this.listener.close(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public void cancel() throws SQLException {
    try {
      this.target.cancel();
      this.listener.cancel();

    }
    catch(SQLException targetFailureCause) {
      this.listener.cancel(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public int getUpdateCount() throws SQLException {
    try {
      int targetSuccessResult = this.target.getUpdateCount();
      this.listener.getUpdateCount(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getUpdateCount(targetFailureCause);
      throw targetFailureCause;

    }
  }

  public boolean getMoreResults() throws SQLException {
    try {
      boolean targetSuccessResult = this.target.getMoreResults();
      this.listener.getMoreResults(targetSuccessResult);
      return targetSuccessResult;

    }
    catch(SQLException targetFailureCause) {
      this.listener.getMoreResults(targetFailureCause);
      throw targetFailureCause;

    }
  }
}
