package com.impossibl.jdbc.spy;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

interface ConnectionListener {
  void rollback(Savepoint savepoint);

  void rollback(Throwable targetFailureCause, Savepoint savepoint);

  void getAutoCommit(boolean targetSuccessResult);

  void getAutoCommit(Throwable targetFailureCause);

  void getMetaData(DatabaseMetaData targetSuccessResult);

  void getMetaData(Throwable targetFailureCause);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency);

  void prepareStatement(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency);

  void setHoldability(int holdability);

  void setHoldability(Throwable targetFailureCause, int holdability);

  void setClientInfo(String name, String value);

  void setClientInfo(Throwable targetFailureCause, String name, String value);

  void setTypeMap(Map<String, Class<?>> map);

  void setTypeMap(Throwable targetFailureCause, Map<String, Class<?>> map);

  void rollback();

  void rollback(Throwable targetFailureCause);

  void setSavepoint(Savepoint targetSuccessResult, String name);

  void setSavepoint(Throwable targetFailureCause, String name);

  void setTransactionIsolation(int level);

  void setTransactionIsolation(Throwable targetFailureCause, int level);

  void isWrapperFor(boolean targetSuccessResult, Class<?> iface);

  void isWrapperFor(Throwable targetFailureCause, Class<?> iface);

  void createStruct(Struct targetSuccessResult, String typeName, Object[] attributes);

  void createStruct(Throwable targetFailureCause, String typeName, Object[] attributes);

  void prepareCall(CallableStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency);

  void prepareCall(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency);

  void getHoldability(int targetSuccessResult);

  void getHoldability(Throwable targetFailureCause);

  void prepareCall(CallableStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void prepareCall(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void abort(Executor executor);

  void abort(Throwable targetFailureCause, Executor executor);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int autoGeneratedKeys);

  void prepareStatement(Throwable targetFailureCause, String sql, int autoGeneratedKeys);

  void createClob(Clob targetSuccessResult);

  void createClob(Throwable targetFailureCause);

  void isReadOnly(boolean targetSuccessResult);

  void isReadOnly(Throwable targetFailureCause);

  void createStatement(Statement targetSuccessResult);

  void createStatement(Throwable targetFailureCause);

  void getCatalog(String targetSuccessResult);

  void getCatalog(Throwable targetFailureCause);

  void close();

  void close(Throwable targetFailureCause);

  void commit();

  void commit(Throwable targetFailureCause);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void prepareStatement(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void clearWarnings();

  void clearWarnings(Throwable targetFailureCause);

  void isValid(boolean targetSuccessResult, int timeout);

  void isValid(Throwable targetFailureCause, int timeout);

  void setClientInfo(Properties properties);

  void setClientInfo(Throwable targetFailureCause, Properties properties);

  void createStatement(Statement targetSuccessResult, int resultSetType, int resultSetConcurrency,
      int resultSetHoldability);

  void createStatement(Throwable targetFailureCause, int resultSetType, int resultSetConcurrency,
      int resultSetHoldability);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, String[] columnNames);

  void prepareStatement(Throwable targetFailureCause, String sql, String[] columnNames);

  void getTypeMap(Map<String, Class<?>> targetSuccessResult);

  void getTypeMap(Throwable targetFailureCause);

  void getNetworkTimeout(int targetSuccessResult);

  void getNetworkTimeout(Throwable targetFailureCause);

  void nativeSQL(String targetSuccessResult, String sql);

  void nativeSQL(Throwable targetFailureCause, String sql);

  void getTransactionIsolation(int targetSuccessResult);

  void getTransactionIsolation(Throwable targetFailureCause);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql);

  void prepareStatement(Throwable targetFailureCause, String sql);

  void createSQLXML(SQLXML targetSuccessResult);

  void createSQLXML(Throwable targetFailureCause);

  void createNClob(NClob targetSuccessResult);

  void createNClob(Throwable targetFailureCause);

  <T> void unwrap(T targetSuccessResult, Class<T> iface);

  <T> void unwrap(Throwable targetFailureCause, Class<T> iface);

  void prepareCall(CallableStatement targetSuccessResult, String sql);

  void prepareCall(Throwable targetFailureCause, String sql);

  void getSchema(String targetSuccessResult);

  void getSchema(Throwable targetFailureCause);

  void createStatement(Statement targetSuccessResult, int resultSetType, int resultSetConcurrency);

  void createStatement(Throwable targetFailureCause, int resultSetType, int resultSetConcurrency);

  void setReadOnly(boolean readOnly);

  void setReadOnly(Throwable targetFailureCause, boolean readOnly);

  void setNetworkTimeout(Executor executor, int milliseconds);

  void setNetworkTimeout(Throwable targetFailureCause, Executor executor, int milliseconds);

  void createBlob(Blob targetSuccessResult);

  void createBlob(Throwable targetFailureCause);

  void getWarnings(SQLWarning targetSuccessResult);

  void getWarnings(Throwable targetFailureCause);

  void getClientInfo(String targetSuccessResult, String name);

  void getClientInfo(Throwable targetFailureCause, String name);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int[] columnIndexes);

  void prepareStatement(Throwable targetFailureCause, String sql, int[] columnIndexes);

  void createArrayOf(Array targetSuccessResult, String typeName, Object[] elements);

  void createArrayOf(Throwable targetFailureCause, String typeName, Object[] elements);

  void isClosed(boolean targetSuccessResult);

  void isClosed(Throwable targetFailureCause);

  void setAutoCommit(boolean autoCommit);

  void setAutoCommit(Throwable targetFailureCause, boolean autoCommit);

  void releaseSavepoint(Savepoint savepoint);

  void releaseSavepoint(Throwable targetFailureCause, Savepoint savepoint);

  void setSchema(String schema);

  void setSchema(Throwable targetFailureCause, String schema);

  void setSavepoint(Savepoint targetSuccessResult);

  void setSavepoint(Throwable targetFailureCause);

  void setCatalog(String catalog);

  void setCatalog(Throwable targetFailureCause, String catalog);

  void getClientInfo(Properties targetSuccessResult);

  void getClientInfo(Throwable targetFailureCause);

  DatabaseMetaDataListener newDatabaseMetaDataListener();

  PreparedStatementListener newPreparedStatementListener();

  SavepointListener newSavepointListener();

  StructListener newStructListener();

  CallableStatementListener newCallableStatementListener();

  ClobListener newClobListener();

  StatementListener newStatementListener();

  SQLXMLListener newSQLXMLListener();

  NClobListener newNClobListener();

  BlobListener newBlobListener();

  ArrayListener newArrayListener();
}
