/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp;

import com.icegreen.greenmail.server.AbstractSocketProtocolHandler;
import com.icegreen.greenmail.server.BuildInfo;
import com.icegreen.greenmail.smtp.SmtpConnection;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import com.icegreen.greenmail.smtp.commands.SmtpCommandRegistry;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class SmtpHandler
extends AbstractSocketProtocolHandler {
    protected SmtpCommandRegistry registry;
    protected SmtpManager manager;
    protected SmtpConnection conn;
    protected SmtpState state;
    protected String currentLine;

    public SmtpHandler(SmtpCommandRegistry registry, SmtpManager manager, Socket socket) {
        super(socket);
        this.registry = registry;
        this.manager = manager;
    }

    @Override
    public void run() {
        try {
            this.conn = new SmtpConnection(this, this.socket);
            this.state = new SmtpState();
            this.sendGreetings();
            while (!this.isQuitting()) {
                this.handleCommand();
            }
        }
        catch (SocketTimeoutException ste) {
            this.conn.send("421 Service shutting down and closing transmission channel (socket timeout, SO_TIMEOUT: " + this.getSoTimeout() + "ms)");
            this.conn.quit();
        }
        catch (Exception e) {
            if (!this.isQuitting()) {
                throw new IllegalStateException("Unexpected error handling connection", e);
            }
        }
        finally {
            if (null != this.state) {
                this.state.clearMessage();
            }
            this.close();
        }
    }

    protected void sendGreetings() {
        this.conn.send("220 " + this.conn.getServerGreetingsName() + " GreenMail SMTP Service v" + BuildInfo.INSTANCE.getProjectVersion() + " ready");
    }

    protected void handleCommand() throws IOException {
        this.currentLine = this.conn.readLine();
        if (this.currentLine == null) {
            this.close();
            return;
        }
        if (!this.commandLegalSize()) {
            return;
        }
        String commandName = this.currentLine.substring(0, 4).toUpperCase();
        SmtpCommand command = this.registry.getCommand(commandName);
        if (command == null) {
            this.conn.send("500 Command not recognized");
            return;
        }
        command.execute(this.conn, this.state, this.manager, this.currentLine);
    }

    protected boolean commandLegalSize() {
        if (this.currentLine.length() < 4) {
            this.conn.send("500 Invalid command. Must be 4 characters");
            return false;
        }
        if (this.currentLine.length() > 4 && this.currentLine.charAt(4) != ' ') {
            this.conn.send("500 Invalid command. Must be 4 characters");
            return false;
        }
        if (this.currentLine.length() > 1000) {
            this.conn.send("500 Command too long.  1000 character maximum.");
            return false;
        }
        return true;
    }
}

