/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import javax.mail.Flags;

class StoreCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "STORE";
    public static final String ARGS = "<Message-set> ['+'|'-']FLAG[.SILENT] <flag-list>";
    private final StoreCommandParser parser = new StoreCommandParser();

    StoreCommand() {
    }

    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        IdRange[] idSet = this.parser.parseIdRange(request);
        StoreDirective directive = this.parser.storeDirective(request);
        Flags flags = this.parser.flagList(request);
        this.parser.endLine(request);
        ImapSessionFolder mailbox = session.getSelected();
        ImapSessionFolder silentListener = null;
        if (directive.isSilent()) {
            silentListener = mailbox;
        }
        long[] uids = mailbox.getMessageUids();
        for (int i = 0; i < uids.length; ++i) {
            long uid = uids[i];
            int msn = mailbox.getMsn(uid);
            if ((!useUids || !this.includes(idSet, uid)) && (useUids || !this.includes(idSet, msn))) continue;
            if (directive.getSign() < 0) {
                mailbox.setFlags(flags, false, uid, silentListener, useUids);
                continue;
            }
            if (directive.getSign() > 0) {
                mailbox.setFlags(flags, true, uid, silentListener, useUids);
                continue;
            }
            mailbox.replaceFlags(flags, uid, silentListener, useUids);
        }
        boolean omitExpunged = !useUids;
        session.unsolicitedResponses(response, omitExpunged);
        response.commandComplete(this);
    }

    private void storeFlags(SimpleStoredMessage storedMessage, StoreDirective directive, Flags newFlags) {
        Flags messageFlags = storedMessage.getFlags();
        if (directive.getSign() == 0) {
            messageFlags.remove(MessageFlags.ALL_FLAGS);
            messageFlags.add(newFlags);
        } else if (directive.getSign() < 0) {
            messageFlags.remove(newFlags);
        } else if (directive.getSign() > 0) {
            messageFlags.add(newFlags);
        }
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }

    private class StoreDirective {
        private int sign;
        private boolean silent;

        public StoreDirective(int sign, boolean silent) {
            this.sign = sign;
            this.silent = silent;
        }

        public int getSign() {
            return this.sign;
        }

        public boolean isSilent() {
            return this.silent;
        }
    }

    private class StoreCommandParser
    extends CommandParser {
        private StoreCommandParser() {
        }

        StoreDirective storeDirective(ImapRequestLineReader request) throws ProtocolException {
            int sign = 0;
            boolean silent = false;
            char next = request.nextWordChar();
            if (next == '+') {
                sign = 1;
                request.consume();
            } else if (next == '-') {
                sign = -1;
                request.consume();
            } else {
                sign = 0;
            }
            String directive = this.consumeWord(request, new CommandParser.NoopCharValidator());
            if ("FLAGS".equalsIgnoreCase(directive)) {
                silent = false;
            } else if ("FLAGS.SILENT".equalsIgnoreCase(directive)) {
                silent = true;
            } else {
                throw new ProtocolException("Invalid Store Directive: '" + directive + "'");
            }
            return new StoreDirective(sign, silent);
        }
    }
}

