/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;

class CopyCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "COPY";
    public static final String ARGS = "<message-set> <mailbox>";

    CopyCommand() {
    }

    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        MailFolder toFolder;
        IdRange[] idSet = this.parser.parseIdRange(request);
        String mailboxName = this.parser.mailbox(request);
        this.parser.endLine(request);
        ImapSessionFolder currentMailbox = session.getSelected();
        try {
            toFolder = this.getMailbox(mailboxName, session, true);
        }
        catch (FolderException e) {
            e.setResponseCode("TRYCREATE");
            throw e;
        }
        long[] uids = currentMailbox.getMessageUids();
        for (int i = 0; i < uids.length; ++i) {
            boolean inSet;
            long uid = uids[i];
            if (useUids) {
                inSet = this.includes(idSet, uid);
            } else {
                int msn = currentMailbox.getMsn(uid);
                inSet = this.includes(idSet, msn);
            }
            if (!inSet) continue;
            currentMailbox.copyMessage(uid, toFolder);
        }
        session.unsolicitedResponses(response);
        response.commandComplete(this);
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }
}

