/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool;

import com.ibm.watsonx.ai.core.Experimental;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Experimental
public interface ToolRequest {
    public String toolName();

    public Object input();

    public Map<String, Object> config();

    public static ToolRequest structuredInput(String toolName, Map<String, Object> input) {
        return ToolRequest.structuredInput(toolName, input, null);
    }

    public static ToolRequest structuredInput(String toolName, Map<String, Object> input, Map<String, Object> config) {
        return new StructuredInput(toolName, input, config);
    }

    public static ToolRequest unstructuredInput(String toolName, String input) {
        return ToolRequest.unstructuredInput(toolName, input, null);
    }

    public static ToolRequest unstructuredInput(String toolName, String input, Map<String, Object> config) {
        return new UnstructuredInput(toolName, input, config);
    }

    public static final class StructuredInput
    extends Record
    implements ToolRequest {
        private final String toolName;
        private final Map<String, Object> input;
        private final Map<String, Object> config;

        public StructuredInput(String toolName, Map<String, Object> input, Map<String, Object> config) {
            this.toolName = toolName;
            this.input = input;
            this.config = config;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StructuredInput.class, "toolName;input;config", "toolName", "input", "config"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StructuredInput.class, "toolName;input;config", "toolName", "input", "config"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StructuredInput.class, "toolName;input;config", "toolName", "input", "config"}, this, o);
        }

        @Override
        public String toolName() {
            return this.toolName;
        }

        @Override
        public Map<String, Object> input() {
            return this.input;
        }

        @Override
        public Map<String, Object> config() {
            return this.config;
        }
    }

    public static final class UnstructuredInput
    extends Record
    implements ToolRequest {
        private final String toolName;
        private final String input;
        private final Map<String, Object> config;

        public UnstructuredInput(String toolName, String input, Map<String, Object> config) {
            this.toolName = toolName;
            this.input = input;
            this.config = config;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{UnstructuredInput.class, "toolName;input;config", "toolName", "input", "config"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UnstructuredInput.class, "toolName;input;config", "toolName", "input", "config"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UnstructuredInput.class, "toolName;input;config", "toolName", "input", "config"}, this, o);
        }

        @Override
        public String toolName() {
            return this.toolName;
        }

        @Override
        public String input() {
            return this.input;
        }

        @Override
        public Map<String, Object> config() {
            return this.config;
        }
    }
}

