/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.rerank;

import com.ibm.watsonx.ai.WatsonxParameters;
import com.ibm.watsonx.ai.rerank.RerankRequest;
import java.util.Objects;

public final class RerankParameters
extends WatsonxParameters.WatsonxModelParameters {
    private final Integer truncateInputTokens;
    private final Integer topN;
    private final Boolean inputs;
    private final Boolean query;

    public RerankParameters(Builder builder) {
        super(builder);
        this.truncateInputTokens = builder.truncateInputTokens;
        this.topN = builder.topN;
        this.inputs = builder.inputs;
        this.query = builder.query;
    }

    public Integer getTruncateInputTokens() {
        return this.truncateInputTokens;
    }

    public Integer getTopN() {
        return this.topN;
    }

    public Boolean getInputs() {
        return this.inputs;
    }

    public Boolean getQuery() {
        return this.query;
    }

    RerankRequest.Parameters toRerankRequestParameters() {
        RerankRequest.Parameters parameters = null;
        RerankRequest.ReturnOptions returnOptions = null;
        if (Objects.nonNull(this.topN) || Objects.nonNull(this.inputs) || Objects.nonNull(this.query)) {
            returnOptions = new RerankRequest.ReturnOptions(this.topN, this.inputs, this.query);
        }
        if (Objects.nonNull(this.truncateInputTokens) || Objects.nonNull(returnOptions)) {
            parameters = new RerankRequest.Parameters(this.truncateInputTokens, returnOptions);
        }
        return parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxParameters.WatsonxModelParameters.Builder<Builder> {
        private Integer truncateInputTokens;
        private Integer topN;
        private Boolean inputs;
        private Boolean query;

        private Builder() {
        }

        public Builder truncateInputTokens(Integer truncateInputTokens) {
            this.truncateInputTokens = truncateInputTokens;
            return this;
        }

        public Builder topN(Integer topN) {
            this.topN = topN;
            return this;
        }

        public Builder inputs(Boolean inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder query(Boolean query) {
            this.query = query;
            return this;
        }

        public RerankParameters build() {
            return new RerankParameters(this);
        }
    }
}

