/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.foundationmodel;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.spi.json.TypeToken;
import com.ibm.watsonx.ai.foundationmodel.FoundationModel;
import com.ibm.watsonx.ai.foundationmodel.FoundationModelParameters;
import com.ibm.watsonx.ai.foundationmodel.FoundationModelResponse;
import com.ibm.watsonx.ai.foundationmodel.FoundationModelTask;
import com.ibm.watsonx.ai.foundationmodel.filter.Filter;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public final class FoundationModelService
extends WatsonxService {
    private final boolean techPreview;

    protected FoundationModelService(Builder builder) {
        super(builder);
        this.techPreview = Objects.requireNonNullElse(builder.techPreview, false);
    }

    public FoundationModelResponse<FoundationModel> getModels() {
        return this.getModels(FoundationModelParameters.builder().build());
    }

    public FoundationModelResponse<FoundationModel> getModels(Filter filter) {
        return this.getModels(FoundationModelParameters.builder().filter(filter).build());
    }

    public FoundationModelResponse<FoundationModel> getModels(FoundationModelParameters parameters) {
        parameters = Objects.requireNonNullElse(parameters, FoundationModelParameters.builder().build());
        Boolean techPreview = Optional.ofNullable(parameters.getTechPreview()).orElse(this.techPreview);
        return this.getModels(parameters.getStart(), parameters.getLimit(), parameters.getTransactionId(), techPreview, parameters.getFilter());
    }

    protected FoundationModelResponse<FoundationModel> getModels(Integer start, Integer limit, String transactionId, Boolean techPreview, String filters) {
        try {
            StringJoiner queryParameters = new StringJoiner("&", "", "");
            queryParameters.add("version=" + this.version);
            if (Objects.nonNull(start)) {
                queryParameters.add("start=" + start);
            }
            if (Objects.nonNull(limit)) {
                queryParameters.add("limit=" + limit);
            }
            if (techPreview.booleanValue()) {
                queryParameters.add("tech_preview=" + techPreview);
            }
            if (Objects.nonNull(filters)) {
                queryParameters.add("filters=" + URLEncoder.encode(filters.toString(), StandardCharsets.UTF_8));
            }
            URI uri = URI.create(this.url.toString() + "%s/foundation_model_specs?%s".formatted("/ml/v1", queryParameters));
            HttpRequest.Builder httpRequest = HttpRequest.newBuilder(uri).header("Accept", "application/json").timeout(this.timeout).GET();
            if (Objects.nonNull(transactionId)) {
                httpRequest.header("X-Global-Transaction-Id", transactionId);
            }
            HttpResponse response = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (FoundationModelResponse)Json.fromJson((String)((String)response.body()), (TypeToken)new TypeToken<FoundationModelResponse<FoundationModel>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public FoundationModelResponse<FoundationModelTask> getTasks() {
        return this.getTasks(FoundationModelParameters.builder().build());
    }

    public FoundationModelResponse<FoundationModelTask> getTasks(FoundationModelParameters parameters) {
        StringJoiner queryParameters = new StringJoiner("&", "", "");
        queryParameters.add("version=" + this.version);
        if (Objects.nonNull(parameters.getStart())) {
            queryParameters.add("start=" + parameters.getStart());
        }
        if (Objects.nonNull(parameters.getLimit())) {
            queryParameters.add("limit=" + parameters.getLimit());
        }
        URI uri = URI.create(this.url.toString() + "%s/foundation_model_tasks?%s".formatted("/ml/v1", queryParameters));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(uri).GET();
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            HttpResponse response = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (FoundationModelResponse)Json.fromJson((String)((String)response.body()), (TypeToken)new TypeToken<FoundationModelResponse<FoundationModelTask>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.Builder<Builder> {
        private Boolean techPreview;

        private Builder() {
        }

        public Builder techPreview(boolean techPreview) {
            this.techPreview = techPreview;
            return this;
        }

        public FoundationModelService build() {
            return new FoundationModelService(this);
        }
    }
}

